/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.asnjc;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.asnlab.asndt.asnjc.IdGenerator;
import org.asnlab.asndt.asnjc.JavaCompilerOptions;
import org.asnlab.asndt.asnjc.NamingConventions;
import org.asnlab.asndt.core.asn.Alternative;
import org.asnlab.asndt.core.asn.BitStringType;
import org.asnlab.asndt.core.asn.BooleanType;
import org.asnlab.asndt.core.asn.CharacterStringType;
import org.asnlab.asndt.core.asn.ChoiceType;
import org.asnlab.asndt.core.asn.ClassFieldFixType;
import org.asnlab.asndt.core.asn.ClassFieldOpenType;
import org.asnlab.asndt.core.asn.Component;
import org.asnlab.asndt.core.asn.CompositeType;
import org.asnlab.asndt.core.asn.Constraint;
import org.asnlab.asndt.core.asn.ConstraintType;
import org.asnlab.asndt.core.asn.ElementSet;
import org.asnlab.asndt.core.asn.EnumeratedType;
import org.asnlab.asndt.core.asn.ExtensionAddition;
import org.asnlab.asndt.core.asn.ExtensionAdditionGroup;
import org.asnlab.asndt.core.asn.ExtensionAdditionType;
import org.asnlab.asndt.core.asn.FieldSpec;
import org.asnlab.asndt.core.asn.FixedTypeValueFieldSpec;
import org.asnlab.asndt.core.asn.FixedTypeValueSetFieldSpec;
import org.asnlab.asndt.core.asn.GeneralizedTimeType;
import org.asnlab.asndt.core.asn.InformationObject;
import org.asnlab.asndt.core.asn.IntegerRange;
import org.asnlab.asndt.core.asn.IntegerType;
import org.asnlab.asndt.core.asn.ListType;
import org.asnlab.asndt.core.asn.Module;
import org.asnlab.asndt.core.asn.NamedNumber;
import org.asnlab.asndt.core.asn.NullType;
import org.asnlab.asndt.core.asn.ObjectClass;
import org.asnlab.asndt.core.asn.ObjectClassDefn;
import org.asnlab.asndt.core.asn.ObjectClassReference;
import org.asnlab.asndt.core.asn.ObjectDescriptorType;
import org.asnlab.asndt.core.asn.ObjectFieldSpec;
import org.asnlab.asndt.core.asn.ObjectIdentifierType;
import org.asnlab.asndt.core.asn.ObjectSet;
import org.asnlab.asndt.core.asn.ObjectSetDefn;
import org.asnlab.asndt.core.asn.ObjectSetFieldSpec;
import org.asnlab.asndt.core.asn.ObjectSetReference;
import org.asnlab.asndt.core.asn.OctetStringType;
import org.asnlab.asndt.core.asn.RealType;
import org.asnlab.asndt.core.asn.RelativeOidType;
import org.asnlab.asndt.core.asn.SingleType;
import org.asnlab.asndt.core.asn.SizeConstraint;
import org.asnlab.asndt.core.asn.TableConstraint;
import org.asnlab.asndt.core.asn.TaggedType;
import org.asnlab.asndt.core.asn.Type;
import org.asnlab.asndt.core.asn.TypeFieldSpec;
import org.asnlab.asndt.core.asn.TypeReference;
import org.asnlab.asndt.core.asn.UTCTimeType;
import org.asnlab.asndt.core.asn.ValueFieldSpec;
import org.asnlab.asndt.core.asn.ValueSet;
import org.asnlab.asndt.runtime.conv.BitStringConverter;
import org.asnlab.asndt.runtime.conv.ChoiceConverter;
import org.asnlab.asndt.runtime.conv.CompositeConverter;
import org.asnlab.asndt.runtime.conv.EnumeratedConverter;

class CodeGeneration {
    private static BigInteger INTEGER_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    private static BigInteger INTEGER_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    static String CIPHER_ALG = "AES/ECB/NoPadding";

    private CodeGeneration() {
    }

    static String generateModule(String pkg, Module module, JavaCompilerOptions options) {
        boolean jdk14orUnder = "J2SE-1.4".equals(options.execution_environment);
        String moduleName = NamingConventions.toJavaModuleName(module.name);
        StringBuffer buf = new StringBuffer();
        CodeGeneration.printLogo(buf, module);
        buf.append("package " + pkg + ";\n");
        buf.append("\n");
        buf.append("import java.util.*;\n");
        if (options.generate_sample_test_code) {
            buf.append("import org.asnlab.asndt.runtime.type.Buffer;\n");
        }
        buf.append("import org.asnlab.asndt.runtime.type.AsnType;\n");
        buf.append("import org.asnlab.asndt.runtime.type.AsnModule;\n");
        buf.append("import org.asnlab.asndt.runtime.value.*;\n");
        buf.append("import org.asnlab.asndt.runtime.conv.*;\n");
        buf.append("\n");
        buf.append("\n");
        buf.append("public class ").append(moduleName).append(" extends AsnModule {\n");
        buf.append("\n");
        buf.append("\tpublic final static ").append(moduleName).append(" instance = new ").append(moduleName).append("();\n");
        buf.append("\n");
        buf.append("\n");
        buf.append("\t/**\n");
        buf.append("\t/* Creates the ASN.1 module.\n");
        buf.append("\t/* The ASN.1 module instance is created automatically, clients must not call.\n");
        buf.append("\t/* A metadata file named ").append(moduleName).append(".meta must exist in the same package of this class.\n");
        buf.append("\t **/\n");
        buf.append("\tprivate ").append(moduleName).append("() {\n");
        buf.append("\t\tsuper(").append(moduleName).append(".class); \n");
        buf.append("\t}\n");
        buf.append("\n");
        buf.append("\n");
        buf.append("\tpublic static AsnType type(int id) {\n");
        buf.append("\t\treturn instance.getType(id);\n");
        buf.append("\t}\n");
        buf.append("\n");
        buf.append("\tpublic static Object value(int valueId, AsnConverter converter) {\n");
        buf.append("\t\treturn instance.getValue(valueId, converter);\n");
        buf.append("\t}\n");
        buf.append("\n");
        buf.append("\tpublic static Object object(int objectId, AsnConverter converter) {\n");
        buf.append("\t\treturn instance.getObject(objectId, converter);\n");
        buf.append("\t}\n");
        buf.append("\n");
        buf.append("\tpublic static Vector objectSet(int objectSetId, AsnConverter converter) {\n");
        buf.append("\t\treturn instance.getObjectSet(objectSetId, converter);\n");
        buf.append("\t}\n");
        buf.append("\n");
        if (options.generate_sample_test_code) {
            buf.append("\t/**\n");
            buf.append("\t * Sample test code\n");
            buf.append("\t */\n");
            buf.append("\tpublic static void main(String[] args) {\n");
            for (Map.Entry entry : module.types.entrySet()) {
                String typeName = NamingConventions.toJavaTypeName((String)entry.getKey());
                Type type = (Type)entry.getValue();
                if (type.values.size() <= 0) continue;
                buf.append("\t\tSystem.out.println(\"").append(typeName).append("\");\n");
                for (Map.Entry valueEntry : type.values.entrySet()) {
                    String valueName = NamingConventions.toJavaName((String)valueEntry.getKey());
                    buf.append("\t\tSystem.out.println(\"test of ").append(valueName).append(":\");\n");
                    buf.append("\t\ttest(").append(typeName).append(".").append(valueName).append(", ").append(typeName).append(".TYPE, ").append(typeName).append(".CONV);\n");
                }
                buf.append("\n");
            }
            buf.append("\t}\n");
            buf.append("\n");
            buf.append("\n");
            if (jdk14orUnder) {
                buf.append("\tprivate static void test(Object value, AsnType type, AsnConverter converter) {\n");
                buf.append("\t\tSystem.out.println(\"======== print ========\");\n");
                buf.append("\t\ttype.print(value, converter, System.out);\n");
                buf.append("\t\tSystem.out.println();\n");
                buf.append("\t\tSystem.out.println();\n");
                buf.append("\n");
                buf.append("\t\tSystem.out.println(\"======== encode ========\");\n");
                buf.append("\t\tBuffer buffer = Buffer.allocate(1024, EncodingRules.BASIC_ENCODING_RULES);\n");
                buf.append("\t\ttype.encode(value, buffer, converter);\n");
                buf.append("\t\tbyte[] bytes = buffer.array();\n");
                buf.append("\t\tfor(byte b : bytes) {\n");
                buf.append("\t\t\tSystem.out.printf(\"%02X \", b & 0xFF);\n");
                buf.append("\t\t}\n");
                buf.append("\t\tSystem.out.println();\n");
                buf.append("\t\tSystem.out.println();\n");
                buf.append("\n");
                buf.append("\t\tSystem.out.println(\"======== decode ========\");\n");
                buf.append("\t\tBuffer buffer2 = Buffer.wrap(bytes, EncodingRules.BASIC_ENCODING_RULES);\n");
                buf.append("\t\tObject newValue = type.decode(buffer2, converter);\n");
                buf.append("\t\ttype.print(newValue, converter, System.out);\n");
                buf.append("\t\tSystem.out.println();\n");
                buf.append("\t\tSystem.out.println();\n");
                buf.append("\n");
                buf.append("\t\tSystem.out.println(\"======== equality ========\");\n");
                buf.append("\t\tSystem.out.println(type.equals(value, newValue, converter));\n");
                buf.append("\t}\n");
            } else {
                buf.append("\tprivate static <V> void test(V value, AsnType type, AsnConverter converter) {\n");
                buf.append("\t\tSystem.out.println(\"======== print ========\");\n");
                buf.append("\t\ttype.print(value, converter, System.out);\n");
                buf.append("\t\tSystem.out.println();\n");
                buf.append("\t\tSystem.out.println();\n");
                buf.append("\n");
                buf.append("\t\tSystem.out.println(\"======== encode ========\");\n");
                buf.append("\t\tBuffer buffer = Buffer.allocate(1024, EncodingRules.BASIC_ENCODING_RULES);\n");
                buf.append("\t\ttype.encode(value, buffer, converter);\n");
                buf.append("\t\tbyte[] bytes = buffer.array();\n");
                buf.append("\t\tfor(byte b : bytes) {\n");
                buf.append("\t\t\tSystem.out.printf(\"%02X \", b & 0xFF);\n");
                buf.append("\t\t}\n");
                buf.append("\t\tSystem.out.println();\n");
                buf.append("\t\tSystem.out.println();\n");
                buf.append("\n");
                buf.append("\t\tSystem.out.println(\"======== decode ========\");\n");
                buf.append("\t\tBuffer buffer2 = Buffer.wrap(bytes, EncodingRules.BASIC_ENCODING_RULES);\n");
                buf.append("\t\tV newValue = (V) type.decode(buffer2, converter);\n");
                buf.append("\t\ttype.print(newValue, converter, System.out);\n");
                buf.append("\t\tSystem.out.println();\n");
                buf.append("\t\tSystem.out.println();\n");
                buf.append("\n");
                buf.append("\t\tSystem.out.println(\"======== equality ========\");\n");
                buf.append("\t\tSystem.out.println(type.equals(value, newValue, converter));\n");
                buf.append("\t}\n");
            }
        }
        buf.append("\n");
        buf.append("}\n");
        return buf.toString();
    }

    static void printImports(StringBuffer buf, String packageName, ObjectClass objectClass, JavaCompilerOptions options) {
        List<String> imports = CodeGeneration.calculateImports(packageName, objectClass, options);
        for (String imprt : imports) {
            buf.append("import ").append(imprt).append(";\n");
        }
        buf.append("\n");
    }

    static List<String> calculateImports(String packageName, ObjectClass objectClass, JavaCompilerOptions options) {
        if (objectClass instanceof ObjectClassReference) {
            return CodeGeneration.calculateImports(packageName, ((ObjectClassReference)objectClass).underlyingObjectClass, options);
        }
        HashSet<String> imports = new HashSet<String>();
        imports.add("java.util.*");
        imports.add("org.asnlab.asndt.runtime.type.AsnType");
        imports.add("org.asnlab.asndt.runtime.conv.*");
        imports.add("org.asnlab.asndt.runtime.value.*");
        boolean jdk14orUnder = "J2SE-1.4".equals(options.execution_environment);
        if (!jdk14orUnder && options.using_annotation) {
            imports.add("org.asnlab.asndt.runtime.conv.annotation.*");
        }
        ObjectClassDefn objectClassDefn = (ObjectClassDefn)objectClass;
        FieldSpec[] fieldSpecArray = objectClassDefn.fields;
        int n = objectClassDefn.fields.length;
        int n2 = 0;
        while (n2 < n) {
            FieldSpec field = fieldSpecArray[n2];
            if (field instanceof ValueFieldSpec) {
                ValueFieldSpec valueFieldSpec = (ValueFieldSpec)field;
                CodeGeneration.calculateImports(packageName, valueFieldSpec.type, options, imports);
            }
            ++n2;
        }
        ArrayList<String> sortedImports = new ArrayList<String>();
        sortedImports.addAll(imports);
        Collections.sort(sortedImports);
        return sortedImports;
    }

    static String generateClass(String pkg, String javaModuleName, String typeName, Integer id, Type type, IdGenerator idGenerator, JavaCompilerOptions options) {
        String javaTypeName = NamingConventions.toJavaTypeName(typeName);
        StringBuffer buf = new StringBuffer();
        CodeGeneration.printLogo(buf, type.module);
        CodeGeneration.printPackage(buf, pkg);
        CodeGeneration.printImports(buf, pkg, type, options);
        CodeGeneration.printClassBody("", false, buf, javaModuleName, javaTypeName, id, type, null, idGenerator, options);
        return buf.toString();
    }

    static String generateClass(String pkg, String javaModuleName, String className, Integer id, ObjectClassDefn clazz, IdGenerator idGenerator, JavaCompilerOptions options) {
        String javaTypeName = NamingConventions.toJavaTypeName(className);
        StringBuffer buf = new StringBuffer();
        CodeGeneration.printLogo(buf, clazz.module);
        CodeGeneration.printPackage(buf, pkg);
        CodeGeneration.printImports(buf, pkg, (ObjectClass)clazz, options);
        CodeGeneration.printTypeOfClass("", buf, javaModuleName, javaTypeName, id, clazz, idGenerator, options);
        return buf.toString();
    }

    private static void printLogo(StringBuffer buffer, Module module) {
        buffer.append("/*\n");
        buffer.append(" * Generated by ASN.1 Java Compiler (https://www.asnlab.org/)\n");
        buffer.append(" * From ASN.1 module \"").append(module.name).append("\"\n");
        buffer.append(" */\n");
    }

    private static void printPackage(StringBuffer buf, String pkg) {
        if (pkg.length() > 0) {
            buf.append("package " + pkg + ";\n");
            buf.append("\n");
        }
    }

    private static void printImports(StringBuffer buf, String pkg, Type type, JavaCompilerOptions options) {
        List<String> imports = CodeGeneration.calculateImports(pkg, type, options);
        for (String imprt : imports) {
            buf.append("import ").append(imprt).append(";\n");
        }
        buf.append("\n");
    }

    private static List<String> calculateImports(String pkg, Type type, JavaCompilerOptions options) {
        HashSet<String> imports = new HashSet<String>();
        if (options.generate_ber_encoder || options.generate_cer_encoder || options.generate_der_encoder || options.generate_per_encoder || options.generate_prints) {
            imports.add("java.io.*");
        }
        imports.add("org.asnlab.asndt.runtime.type.AsnType");
        imports.add("org.asnlab.asndt.runtime.conv.*");
        imports.add("org.asnlab.asndt.runtime.value.*");
        boolean jdk14orUnder = "J2SE-1.4".equals(options.execution_environment);
        if (!jdk14orUnder && options.using_annotation) {
            imports.add("org.asnlab.asndt.runtime.conv.annotation.*");
        }
        if ("jsr303".equals(options.generate_annotations_for_validation)) {
            imports.add("javax.validation.constraints.*");
        } else if ("jsr305".equals(options.generate_annotations_for_validation)) {
            imports.add("javax.annotation.*");
        }
        while (type instanceof TypeReference) {
            type = ((TypeReference)type).underlyingType;
        }
        CodeGeneration.calculateImports(pkg, type, options, imports);
        ArrayList<String> sortedImports = new ArrayList<String>();
        sortedImports.addAll(imports);
        Collections.sort(sortedImports);
        return sortedImports;
    }

    private static void calculateImports(String pkg, Type type, JavaCompilerOptions options, Set<String> imports) {
        if (type instanceof ClassFieldFixType) {
            CodeGeneration.calculateImports(pkg, ((ClassFieldFixType)type).acutalType, options, imports);
        } else if (type instanceof TaggedType) {
            CodeGeneration.calculateImports(pkg, ((TaggedType)type).underlyingType, options, imports);
        } else if (type instanceof ConstraintType) {
            CodeGeneration.calculateImports(pkg, ((ConstraintType)type).underlyingType, options, imports);
        } else if (type instanceof TypeReference) {
            CodeGeneration.calculateImports(pkg, (TypeReference)type, options, imports);
        } else if (type instanceof ChoiceType) {
            CodeGeneration.calculateImports(pkg, (ChoiceType)type, options, imports);
        } else if (type instanceof CompositeType) {
            CodeGeneration.calculateImports(pkg, (CompositeType)type, options, imports);
        } else if (type instanceof ListType) {
            CodeGeneration.calculateImports(pkg, (ListType)type, options, imports);
        } else if (type instanceof GeneralizedTimeType || type instanceof UTCTimeType) {
            imports.add("java.util.Date");
        } else if (type instanceof BitStringType) {
            imports.add("org.asnlab.asndt.runtime.value.BitString");
        } else if (type instanceof ObjectIdentifierType) {
            imports.add("org.asnlab.asndt.runtime.value.ObjectIdentifier");
        } else if (type instanceof IntegerType) {
            imports.add("java.math.*");
        }
    }

    private static void calculateImports(String pkg, ChoiceType type, JavaCompilerOptions options, Set<String> imports) {
        Alternative alternative;
        Alternative[] alternativeArray = type.rootAlternatives;
        int n = type.rootAlternatives.length;
        int n2 = 0;
        while (n2 < n) {
            alternative = alternativeArray[n2];
            CodeGeneration.calculateImports(pkg, alternative.type, options, imports);
            ++n2;
        }
        alternativeArray = type.extensionAlternatives;
        n = type.extensionAlternatives.length;
        n2 = 0;
        while (n2 < n) {
            alternative = alternativeArray[n2];
            CodeGeneration.calculateImports(pkg, alternative.type, options, imports);
            ++n2;
        }
    }

    private static void calculateImports(String pkg, TypeReference type, JavaCompilerOptions options, Set<String> imports) {
        if (type.isAtomicType()) {
            CodeGeneration.calculateImports(pkg, type.underlyingType, options, imports);
        } else {
            type.isCustomizedType();
        }
    }

    private static void calculateImports(String pkg, CompositeType type, JavaCompilerOptions options, Set<String> imports) {
        Component[] componentArray = type.rootComponents;
        int n = type.rootComponents.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            CodeGeneration.calculateImports(pkg, component.type, options, imports);
            ++n2;
        }
        componentArray = type.extensionAdditions;
        n = type.extensionAdditions.length;
        n2 = 0;
        while (n2 < n) {
            Component extensionAddition = componentArray[n2];
            if (extensionAddition instanceof ExtensionAdditionType) {
                ExtensionAdditionType extensionAdditionType = (ExtensionAdditionType)extensionAddition;
                CodeGeneration.calculateImports(pkg, extensionAdditionType.type, options, imports);
            } else if (extensionAddition instanceof ExtensionAdditionGroup) {
                ExtensionAdditionGroup extensionAdditionGroup = (ExtensionAdditionGroup)extensionAddition;
                ExtensionAdditionType[] extensionAdditionTypeArray = extensionAdditionGroup.extensionAdditionTypes;
                int n3 = extensionAdditionGroup.extensionAdditionTypes.length;
                int n4 = 0;
                while (n4 < n3) {
                    ExtensionAdditionType extensionAdditionType = extensionAdditionTypeArray[n4];
                    CodeGeneration.calculateImports(pkg, extensionAdditionType.type, options, imports);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private static void calculateImports(String pkg, ListType type, JavaCompilerOptions options, Set<String> imports) {
        imports.add("java.util.*");
        CodeGeneration.calculateImports(pkg, type.componentType, options, imports);
    }

    private static void printClassBody(String indent, boolean anonymous, StringBuffer buf, String javaModuleName, String javaTypeName, Integer id, Type type, Constraint constraint, IdGenerator idGenerator, JavaCompilerOptions options) {
        boolean bl = anonymous = anonymous || type.anonymous;
        if (type instanceof TaggedType) {
            TaggedType derivedType = (TaggedType)type;
            CodeGeneration.printClassBody(indent, anonymous, buf, javaModuleName, javaTypeName, id, derivedType.underlyingType, constraint, idGenerator, options);
        } else if (type instanceof ConstraintType) {
            ConstraintType constraintType = (ConstraintType)type;
            constraint = Constraint.safeSerial((Constraint)constraintType.constraint, (Constraint)constraint);
            CodeGeneration.printClassBody(indent, anonymous, buf, javaModuleName, javaTypeName, id, constraintType.underlyingType, constraint, idGenerator, options);
        } else if (type instanceof TypeReference) {
            TypeReference typeReference = (TypeReference)type;
            CodeGeneration.printClassBody(indent, anonymous, buf, javaModuleName, javaTypeName, id, typeReference.underlyingType, constraint, idGenerator, options);
        } else if (type instanceof CompositeType) {
            CodeGeneration.printCompositeClass(indent, anonymous, buf, javaModuleName, javaTypeName, id, (CompositeType)type, idGenerator, options);
        } else if (type instanceof ChoiceType) {
            CodeGeneration.printChoiceClass(indent, anonymous, buf, javaModuleName, javaTypeName, id, (ChoiceType)type, idGenerator, options);
        } else if (type instanceof EnumeratedType) {
            EnumeratedType enumeratedType = (EnumeratedType)type;
            if ("enum type".equals(options.enumerated_mapping)) {
                CodeGeneration.printEnumeratedClass(indent, anonymous, buf, javaModuleName, javaTypeName, id, enumeratedType, idGenerator, options);
            } else {
                CodeGeneration.printSingletonEnumeratedClass(indent, anonymous, buf, javaModuleName, javaTypeName, id, enumeratedType, idGenerator, options);
            }
        } else if (type instanceof BitStringType) {
            CodeGeneration.printBitStringClass(indent, anonymous, buf, javaModuleName, javaTypeName, id, (BitStringType)type, idGenerator, options);
        } else if (type instanceof IntegerType) {
            CodeGeneration.printIntegerClass(indent, buf, javaModuleName, javaTypeName, id, (IntegerType)type, constraint, idGenerator, options);
        } else {
            CodeGeneration.printGenericClass(indent, buf, javaModuleName, javaTypeName, id, type, constraint, idGenerator, options);
        }
    }

    private static void printCompositeClass(String indent, boolean anonymous, StringBuffer buf, String javaModuleName, String javaTypeName, Integer id, CompositeType type, IdGenerator idGenerator, JavaCompilerOptions options) {
        boolean jdk14orUnder = "J2SE-1.4".equals(options.execution_environment);
        String converterName = String.valueOf(javaTypeName) + "Converter";
        ArrayList<ExtensionAdditionType> extensionAdditionTypes = new ArrayList<ExtensionAdditionType>();
        int i = 0;
        while (i < type.extensionAdditions.length) {
            ExtensionAddition extensionAddition = type.extensionAdditions[i];
            if (extensionAddition instanceof ExtensionAdditionType) {
                extensionAdditionTypes.add((ExtensionAdditionType)extensionAddition);
            } else {
                ExtensionAdditionGroup extensionAdditionGroup = (ExtensionAdditionGroup)extensionAddition;
                ExtensionAdditionType[] extensionAdditionTypeArray = extensionAdditionGroup.extensionAdditionTypes;
                int n = extensionAdditionGroup.extensionAdditionTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    ExtensionAdditionType extensionAdditionType = extensionAdditionTypeArray[n2];
                    extensionAdditionTypes.add(extensionAdditionType);
                    ++n2;
                }
            }
            ++i;
        }
        int size = type.rootComponents.length + extensionAdditionTypes.size();
        Type[] componentTypes = new Type[size];
        String[] componentFieldNames = new String[size];
        String[] componentTypeNames = new String[size];
        String[] componentConverterNames = new String[size];
        boolean[] optionals = new boolean[size];
        Object[] defvals = new Object[size];
        int i2 = 0;
        while (i2 < type.rootComponents.length) {
            Component component = type.rootComponents[i2];
            componentFieldNames[i2] = NamingConventions.toJavaFieldName(component.name);
            componentTypes[i2] = component.type;
            componentTypeNames[i2] = CodeGeneration.getTypeName(component.type, null, options);
            componentConverterNames[i2] = CodeGeneration.getConverterName(component.type, null, options);
            optionals[i2] = component.optional;
            defvals[i2] = component.defaultValue;
            ++i2;
        }
        i2 = 0;
        while (i2 < extensionAdditionTypes.size()) {
            ExtensionAdditionType extensionAdditionType = (ExtensionAdditionType)extensionAdditionTypes.get(i2);
            componentTypes[type.rootComponents.length + i2] = extensionAdditionType.type;
            componentFieldNames[type.rootComponents.length + i2] = NamingConventions.toJavaFieldName(extensionAdditionType.name);
            componentTypeNames[type.rootComponents.length + i2] = CodeGeneration.getTypeName(extensionAdditionType.type, null, options);
            componentConverterNames[type.rootComponents.length + i2] = CodeGeneration.getConverterName(extensionAdditionType.type, null, options);
            optionals[type.rootComponents.length + i2] = extensionAdditionType.optional;
            defvals[type.rootComponents.length + i2] = extensionAdditionType.defaultValue;
            ++i2;
        }
        if (anonymous) {
            buf.append(indent).append("@Anonymous\n");
        }
        buf.append(indent).append("public class ").append(javaTypeName).append(" {\n");
        buf.append(indent).append("\n");
        i2 = 0;
        while (i2 < componentFieldNames.length) {
            if (!jdk14orUnder && options.using_annotation) {
                if ("jsr303".equals(options.generate_annotations_for_validation)) {
                    buf.append(indent).append("\t").append(optionals[i2] ? "@Null\n" : "@NotNull\n");
                    String annotation = CodeGeneration.getAnnotation(componentTypes[i2], null, options);
                    if (annotation != null) {
                        buf.append(indent).append("\t").append(annotation).append("\n");
                    }
                } else if ("jsr305".equals(options.generate_annotations_for_validation)) {
                    buf.append(indent).append("\t").append(optionals[i2] ? "@Nullable\n" : "@Nonnull\n");
                }
                buf.append(indent).append("\t@Component(").append(i2).append(")\n");
            }
            buf.append(indent).append("\t").append(options.generate_setters_getters ? "private " : "public ").append(componentTypeNames[i2]).append(" ").append(componentFieldNames[i2]).append(";");
            if (optionals[i2]) {
                buf.append("\t").append("/* OPTIONAL */");
            } else if (defvals[i2] != null) {
                buf.append("\t").append("/* DEFAULT ").append(defvals[i2]).append(" */");
            }
            buf.append(indent).append("\n");
            buf.append(indent).append("\n");
            ++i2;
        }
        buf.append(indent).append("\n");
        if (options.generate_setters_getters) {
            i2 = 0;
            while (i2 < componentFieldNames.length) {
                String setterGetterName = NamingConventions.toSetterGetterName(componentFieldNames[i2]);
                buf.append(indent).append("\tpublic ").append(componentTypeNames[i2]).append(" get").append(setterGetterName).append("() {\n");
                buf.append(indent).append("\t\treturn ").append(componentFieldNames[i2]).append(";\n");
                buf.append(indent).append("\t}\n");
                buf.append(indent).append("\n");
                buf.append(indent).append("\tpublic void set").append(setterGetterName).append("(").append(componentTypeNames[i2]).append(" ").append(componentFieldNames[i2]).append(") {\n");
                buf.append(indent).append("\t\tthis.").append(componentFieldNames[i2]).append(" = ").append(componentFieldNames[i2]).append(";\n");
                buf.append(indent).append("\t}\n");
                buf.append(indent).append("\n");
                ++i2;
            }
        }
        CodeGeneration.generateMethods(indent, buf, javaTypeName, options);
        CodeGeneration.generateEncoder(indent, buf, javaTypeName, options);
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic final static AsnType TYPE = ").append(javaModuleName).append(".type(").append(id).append(");\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic final static CompositeConverter CONV;\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tstatic {\n");
        if (jdk14orUnder) {
            buf.append(indent).append("\t\tCONV = new ").append(converterName).append("();\n");
        } else if (options.using_annotation) {
            buf.append(indent).append("\t\tCONV = new AnnotationCompositeConverter(").append(javaTypeName).append(".class);\n");
        } else {
            buf.append(indent).append("\t\tCONV = new ReflectionCompositeConverter(").append(javaTypeName).append(".class");
            i2 = 0;
            while (i2 < componentFieldNames.length) {
                buf.append(", \"").append(componentFieldNames[i2]).append("\"");
                ++i2;
            }
            buf.append(");\n");
        }
        i2 = 0;
        while (i2 < componentFieldNames.length) {
            buf.append(indent).append("\t\tAsnConverter ").append(String.valueOf(componentFieldNames[i2]) + "Converter").append(" = ").append(componentConverterNames[i2]).append(";\n");
            ++i2;
        }
        buf.append(indent).append("\t\tCONV.setComponentConverters(new AsnConverter[] { ");
        i2 = 0;
        while (i2 < componentFieldNames.length) {
            if (i2 != componentFieldNames.length - 1) {
                buf.append(String.valueOf(componentFieldNames[i2]) + "Converter").append(", ");
            } else {
                buf.append(String.valueOf(componentFieldNames[i2]) + "Converter");
            }
            ++i2;
        }
        buf.append(" });\n");
        buf.append(indent).append("\t}\n");
        buf.append(indent).append("\n");
        CodeGeneration.printValues(indent, buf, javaModuleName, javaTypeName, (Type)type, idGenerator, options);
        buf.append(indent).append("\n");
        if (jdk14orUnder) {
            buf.append(indent).append("\tpublic static class ").append(converterName).append(" extends ").append(CompositeConverter.class.getSimpleName()).append(" {\n");
            buf.append(indent).append("\n");
            i2 = 0;
            while (i2 < componentFieldNames.length) {
                buf.append(indent).append("\t\tprivate static final int ").append(String.valueOf(componentFieldNames[i2]) + "Index").append(" = ").append(i2).append(";\n");
                ++i2;
            }
            buf.append(indent).append("\n");
            buf.append(indent).append("\t\tpublic ").append(converterName).append("() {\n");
            buf.append(indent).append("\t\t\tsuper();\n");
            buf.append(indent).append("\t\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\t\tpublic Object createObject() {\n");
            buf.append(indent).append("\t\t\treturn new ").append(javaTypeName).append("();\n");
            buf.append(indent).append("\t\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\t\tpublic Object getComponentObject(Object object, int index) {\n");
            buf.append(indent).append("\t\t\t").append(javaTypeName).append(" model = (").append(javaTypeName).append(") object;\n");
            buf.append(indent).append("\t\t\tswitch(index){\n");
            i2 = 0;
            while (i2 < componentFieldNames.length) {
                buf.append(indent).append("\t\t\t\tcase ").append(String.valueOf(componentFieldNames[i2]) + "Index").append(":\n");
                buf.append(indent).append("\t\t\t\t\treturn model.").append(componentFieldNames[i2]).append(";\n");
                ++i2;
            }
            buf.append(indent).append("\t\t\t}\n");
            buf.append(indent).append("\t\t\treturn null;\n");
            buf.append(indent).append("\t\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\t\tpublic void setComponentObject(Object object, int index, Object componentObject) {\n");
            buf.append(indent).append("\t\t\t").append(javaTypeName).append(" model = (").append(javaTypeName).append(") object;\n");
            buf.append(indent).append("\t\t\tswitch (index) {\n");
            i2 = 0;
            while (i2 < componentFieldNames.length) {
                buf.append(indent).append("\t\t\t\tcase ").append(String.valueOf(componentFieldNames[i2]) + "Index").append(":\n");
                buf.append(indent).append("\t\t\t\t\tmodel.").append(componentFieldNames[i2]).append(" = (").append(componentTypeNames[i2]).append(") componentObject;\n");
                buf.append(indent).append("\t\t\t\t\tbreak;\n");
                ++i2;
            }
            buf.append(indent).append("\t\t\t}\n");
            buf.append(indent).append("\t\t}\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
        }
        buf.append(indent).append("}\n");
    }

    private static void printTypeOfClass(String indent, StringBuffer buf, String javaModuleName, String javaTypeName, Integer id, ObjectClassDefn clazz, IdGenerator idGenerator, JavaCompilerOptions options) {
        boolean jdk14orUnder = "J2SE-1.4".equals(options.execution_environment);
        String converterName = String.valueOf(javaTypeName) + "Converter";
        int size = clazz.fields.length;
        String[] componentFieldNames = new String[size];
        String[] componentTypeNames = new String[size];
        String[] componentConverterNames = new String[size];
        boolean[] optionals = new boolean[size];
        Object[] defvals = new Object[size];
        int i = 0;
        while (i < size) {
            FieldSpec field = clazz.fields[i];
            componentFieldNames[i] = NamingConventions.classFieldName2JavaFieldName(field.name);
            componentTypeNames[i] = CodeGeneration.getTypeName(field, options);
            componentConverterNames[i] = CodeGeneration.getConverterName(javaModuleName, field, options);
            optionals[i] = field.optional;
            defvals[i] = null;
            ++i;
        }
        buf.append(indent).append("public class ").append(javaTypeName).append(" {\n");
        buf.append(indent).append("\n");
        i = 0;
        while (i < componentFieldNames.length) {
            if (!jdk14orUnder && options.using_annotation) {
                buf.append(indent).append("\t@Component(").append(i).append(")\n");
            }
            buf.append(indent).append("\t").append(options.generate_setters_getters ? "private " : "public ").append(componentTypeNames[i]).append(" ").append(componentFieldNames[i]).append(";");
            if (optionals[i]) {
                buf.append("\t").append("/* OPTIONAL */");
            } else if (defvals[i] != null) {
                buf.append("\t").append("/* DEFAULT ").append(defvals[i]).append(" */");
            }
            buf.append(indent).append("\n");
            buf.append(indent).append("\n");
            ++i;
        }
        buf.append(indent).append("\n");
        if (options.generate_setters_getters) {
            i = 0;
            while (i < componentFieldNames.length) {
                String setterGetterName = NamingConventions.toSetterGetterName(componentFieldNames[i]);
                buf.append(indent).append("\tpublic ").append(componentTypeNames[i]).append(" get").append(setterGetterName).append("() {\n");
                buf.append(indent).append("\t\treturn ").append(componentFieldNames[i]).append(";\n");
                buf.append(indent).append("\t}\n");
                buf.append(indent).append("\n");
                buf.append(indent).append("\tpublic void set").append(setterGetterName).append("(").append(componentTypeNames[i]).append(" ").append(componentFieldNames[i]).append(") {\n");
                buf.append(indent).append("\t\tthis.").append(componentFieldNames[i]).append(" = ").append(componentFieldNames[i]).append(";\n");
                buf.append(indent).append("\t}\n");
                buf.append(indent).append("\n");
                ++i;
            }
        }
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic final static AsnType TYPE = ").append(javaModuleName).append(".type(").append(id).append(");\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic final static CompositeConverter CONV;\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tstatic {\n");
        if (jdk14orUnder) {
            buf.append(indent).append("\t\tCONV = new ").append(converterName).append("();\n");
        } else if (options.using_annotation) {
            buf.append(indent).append("\t\tCONV = new AnnotationCompositeConverter(").append(javaTypeName).append(".class);\n");
        } else {
            buf.append(indent).append("\t\tCONV = new ReflectionCompositeConverter(").append(javaTypeName).append(".class");
            i = 0;
            while (i < componentFieldNames.length) {
                buf.append(", \"").append(componentFieldNames[i]).append("\"");
                ++i;
            }
            buf.append(");\n");
        }
        i = 0;
        while (i < componentFieldNames.length) {
            buf.append(indent).append("\t\tAsnConverter ").append(String.valueOf(componentFieldNames[i]) + "Converter").append(" = ").append(componentConverterNames[i]).append(";\n");
            ++i;
        }
        buf.append(indent).append("\t\tCONV.setComponentConverters(new AsnConverter[] { ");
        i = 0;
        while (i < componentFieldNames.length) {
            if (i != componentFieldNames.length - 1) {
                buf.append(String.valueOf(componentFieldNames[i]) + "Converter").append(", ");
            } else {
                buf.append(String.valueOf(componentFieldNames[i]) + "Converter");
            }
            ++i;
        }
        buf.append(" });\n");
        buf.append(indent).append("\t}\n");
        buf.append(indent).append("\n");
        CodeGeneration.printObjectAndObjectSets(indent, buf, javaModuleName, javaTypeName, clazz, idGenerator, options);
        if (jdk14orUnder) {
            buf.append(indent).append("\tpublic static class ").append(converterName).append(" extends ").append(CompositeConverter.class.getSimpleName()).append(" {\n");
            buf.append(indent).append("\n");
            i = 0;
            while (i < componentFieldNames.length) {
                buf.append(indent).append("\t\tprivate static final int ").append(String.valueOf(componentFieldNames[i]) + "Index").append(" = ").append(i).append(";\n");
                ++i;
            }
            buf.append(indent).append("\n");
            buf.append(indent).append("\t\tpublic ").append(converterName).append("() {\n");
            buf.append(indent).append("\t\t\tsuper();\n");
            buf.append(indent).append("\t\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\t\tpublic Object createObject() {\n");
            buf.append(indent).append("\t\t\treturn new ").append(javaTypeName).append("();\n");
            buf.append(indent).append("\t\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\t\tpublic Object getComponentObject(Object object, int index) {\n");
            buf.append(indent).append("\t\t\t").append(javaTypeName).append(" model = (").append(javaTypeName).append(") object;\n");
            buf.append(indent).append("\t\t\tswitch(index){\n");
            i = 0;
            while (i < componentFieldNames.length) {
                buf.append(indent).append("\t\t\t\tcase ").append(String.valueOf(componentFieldNames[i]) + "Index").append(":\n");
                buf.append(indent).append("\t\t\t\t\treturn model.").append(componentFieldNames[i]).append(";\n");
                ++i;
            }
            buf.append(indent).append("\t\t\t}\n");
            buf.append(indent).append("\t\t\treturn null;\n");
            buf.append(indent).append("\t\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\t\tpublic void setComponentObject(Object object, int index, Object componentObject) {\n");
            buf.append(indent).append("\t\t\t").append(javaTypeName).append(" model = (").append(javaTypeName).append(") object;\n");
            buf.append(indent).append("\t\t\tswitch (index) {\n");
            i = 0;
            while (i < componentFieldNames.length) {
                buf.append(indent).append("\t\t\t\tcase ").append(String.valueOf(componentFieldNames[i]) + "Index").append(":\n");
                buf.append(indent).append("\t\t\t\t\tmodel.").append(componentFieldNames[i]).append(" = (").append(componentTypeNames[i]).append(") componentObject;\n");
                buf.append(indent).append("\t\t\t\t\tbreak;\n");
                ++i;
            }
            buf.append(indent).append("\t\t\t}\n");
            buf.append(indent).append("\t\t}\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
        }
        buf.append(indent).append("}\n");
    }

    private static void printChoiceClass(String indent, boolean anonymous, StringBuffer buf, String javaModuleName, String javaTypeName, Integer id, ChoiceType type, IdGenerator idGenerator, JavaCompilerOptions options) {
        boolean jdk14orUnder = "J2SE-1.4".equals(options.execution_environment);
        String converterName = String.valueOf(javaTypeName) + "Converter";
        Alternative[] alternatives = new Alternative[type.rootAlternatives.length + type.extensionAlternatives.length];
        System.arraycopy(type.rootAlternatives, 0, alternatives, 0, type.rootAlternatives.length);
        System.arraycopy(type.extensionAlternatives, 0, alternatives, type.rootAlternatives.length, type.extensionAlternatives.length);
        String[] alternativeFieldNames = new String[alternatives.length];
        String[] componentTypeNames = new String[alternatives.length];
        String[] componentConverterNames = new String[alternatives.length];
        int i = 0;
        while (i < alternatives.length) {
            Alternative alternative = alternatives[i];
            alternativeFieldNames[i] = NamingConventions.toJavaFieldName(alternative.name);
            componentTypeNames[i] = CodeGeneration.getTypeName(alternative.type, null, options);
            componentConverterNames[i] = CodeGeneration.getConverterName(alternative.type, null, options);
            ++i;
        }
        if (anonymous) {
            buf.append(indent).append("@Anonymous\n");
        }
        buf.append(indent).append("public class ").append(javaTypeName).append(" {\n");
        buf.append(indent).append("\n");
        i = 0;
        while (i < alternativeFieldNames.length) {
            buf.append(indent).append("\tpublic static final int ").append(String.valueOf(alternativeFieldNames[i]) + "Chosen").append(" = ").append(i).append(";\n");
            ++i;
        }
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic final int choiceID;\n");
        buf.append(indent).append("\n");
        i = 0;
        while (i < alternativeFieldNames.length) {
            if (!jdk14orUnder && options.using_annotation) {
                String annotation;
                if ("jsr303".equals(options.generate_annotations_for_validation) && (annotation = CodeGeneration.getAnnotation(alternatives[i].type, null, options)) != null) {
                    buf.append(indent).append("\t").append(annotation).append("\n");
                }
                buf.append(indent).append("\t@Alternative(").append(i).append(")\n");
            }
            buf.append(indent).append("\t").append(options.generate_setters_getters ? "private" : "public").append(" final ").append(componentTypeNames[i]).append(" ").append(alternativeFieldNames[i]).append(";\n");
            buf.append(indent).append("\n");
            ++i;
        }
        buf.append(indent).append("\n");
        buf.append(indent).append("\tprivate ").append(javaTypeName).append("(int choiceID");
        i = 0;
        while (i < alternativeFieldNames.length) {
            buf.append(", ").append(componentTypeNames[i]).append(" ").append(alternativeFieldNames[i]);
            ++i;
        }
        buf.append(") {\n");
        buf.append(indent).append("\t\tthis.choiceID = choiceID;\n");
        i = 0;
        while (i < alternativeFieldNames.length) {
            buf.append(indent).append("\t\tthis.").append(alternativeFieldNames[i]).append(" = ").append(alternativeFieldNames[i]).append(";\n");
            ++i;
        }
        buf.append(indent).append("\t}\n");
        buf.append(indent).append("\n");
        i = 0;
        while (i < alternativeFieldNames.length) {
            buf.append(indent).append("\tpublic static ").append(javaTypeName).append(" ").append(alternativeFieldNames[i]);
            buf.append("(").append(componentTypeNames[i]).append(" ").append(alternativeFieldNames[i]).append(") {\n");
            buf.append(indent).append("\t\treturn new ").append(javaTypeName).append("(").append(alternativeFieldNames[i]).append("Chosen");
            int j = 0;
            while (j < alternativeFieldNames.length) {
                buf.append(", ");
                if (j == i) {
                    buf.append(alternativeFieldNames[j]);
                } else {
                    buf.append(indent).append("null");
                }
                ++j;
            }
            buf.append(");\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
            ++i;
        }
        if (options.generate_setters_getters) {
            i = 0;
            while (i < alternativeFieldNames.length) {
                String setterGetterName = NamingConventions.toSetterGetterName(alternativeFieldNames[i]);
                buf.append(indent).append("\tpublic ").append(componentTypeNames[i]).append(" get").append(setterGetterName).append("() {\n");
                buf.append(indent).append("\t\treturn ").append(alternativeFieldNames[i]).append(";\n");
                buf.append(indent).append("\t}\n");
                buf.append(indent).append("\n");
                ++i;
            }
        }
        CodeGeneration.generateMethods(indent, buf, javaTypeName, options);
        CodeGeneration.generateEncoder(indent, buf, javaTypeName, options);
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic final static AsnType TYPE = ").append(javaModuleName).append(".type(").append(id).append(");\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic final static ChoiceConverter CONV;\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tstatic {\n");
        if (jdk14orUnder) {
            buf.append(indent).append("\t\tCONV = new ").append(converterName).append("();\n");
        } else if (options.using_annotation) {
            buf.append(indent).append("\t\tCONV = new AnnotationChoiceConverter(").append(javaTypeName).append(".class);\n");
        } else {
            buf.append(indent).append("\t\tCONV = new ReflectionChoiceConverter(").append(javaTypeName).append(".class");
            i = 0;
            while (i < alternativeFieldNames.length) {
                buf.append(", \"").append(alternativeFieldNames[i]).append("\"");
                ++i;
            }
            buf.append(");\n");
        }
        i = 0;
        while (i < alternativeFieldNames.length) {
            buf.append(indent).append("\t\tAsnConverter ").append(String.valueOf(alternativeFieldNames[i]) + "Converter").append(" = ").append(componentConverterNames[i]).append(";\n");
            ++i;
        }
        buf.append(indent).append("\t\tCONV.setAlternativeConverters(new AsnConverter[] { ");
        i = 0;
        while (i < alternativeFieldNames.length) {
            if (i != alternativeFieldNames.length - 1) {
                buf.append(String.valueOf(alternativeFieldNames[i]) + "Converter").append(", ");
            } else {
                buf.append(String.valueOf(alternativeFieldNames[i]) + "Converter");
            }
            ++i;
        }
        buf.append(" });\n");
        buf.append(indent).append("\t}\n");
        buf.append(indent).append("\n");
        CodeGeneration.printValues(indent, buf, javaModuleName, javaTypeName, (Type)type, idGenerator, options);
        buf.append(indent).append("\n");
        if (jdk14orUnder) {
            buf.append(indent).append("\tpublic static class ").append(converterName).append(" extends ").append(ChoiceConverter.class.getSimpleName()).append(" {\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\t\tpublic ").append(converterName).append("() {\n");
            buf.append(indent).append("\t\t\tsuper();\n");
            buf.append(indent).append("\t\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\t\tpublic Object createAlternative(int index, Object alternativeObject) {\n");
            buf.append(indent).append("\t\t\tswitch(index) {\n");
            i = 0;
            while (i < alternativeFieldNames.length) {
                buf.append(indent).append("\t\t\t\tcase ").append(alternativeFieldNames[i]).append("Chosen").append(":\n");
                buf.append(indent).append("\t\t\t\t\treturn ").append(alternativeFieldNames[i]).append("((").append(componentTypeNames[i]).append(")alternativeObject);\n");
                ++i;
            }
            buf.append(indent).append("\t\t\t\tdefault:\n");
            buf.append(indent).append("\t\t\t\t\tthrow new IllegalArgumentException();\n");
            buf.append(indent).append("\t\t\t}\n");
            buf.append(indent).append("\t\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\t\tpublic int getAlternativeIndex(Object object) {\n");
            buf.append(indent).append("\t\t\t").append(javaTypeName).append(" model = (").append(javaTypeName).append(") object;\n");
            buf.append(indent).append("\t\t\treturn model.choiceID;\n");
            buf.append(indent).append("\t\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\t\tpublic Object getAlternativeObject(Object object) {\n");
            buf.append(indent).append("\t\t\t").append(javaTypeName).append(" model = (").append(javaTypeName).append(") object;\n");
            buf.append(indent).append("\t\t\tswitch (model.choiceID) {\n");
            i = 0;
            while (i < alternativeFieldNames.length) {
                buf.append(indent).append("\t\t\t\tcase ").append(String.valueOf(alternativeFieldNames[i]) + "Chosen").append(":\n");
                buf.append(indent).append("\t\t\t\t\treturn model.").append(alternativeFieldNames[i]).append(";\n");
                ++i;
            }
            buf.append(indent).append("\t\t\t}\n");
            buf.append(indent).append("\t\t\treturn null;\n");
            buf.append(indent).append("\t\t}\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
        }
        buf.append(indent).append("}\n");
    }

    private static void printEnumeratedClass(String indent, boolean anonymous, StringBuffer buf, String javaModuleName, String javaTypeName, Integer id, EnumeratedType type, IdGenerator idGenerator, JavaCompilerOptions options) {
        boolean jdk14orUnder = "J2SE-1.4".equals(options.execution_environment);
        String converterName = String.valueOf(javaTypeName) + "Converter";
        if (anonymous) {
            buf.append(indent).append("@Anonymous\n");
        }
        buf.append(indent).append("public enum ").append(javaTypeName).append(" {\n");
        NamedNumber[] enumeration = new NamedNumber[type.rootEnumeration.length + type.additionalEnumeration.length];
        System.arraycopy(type.rootEnumeration, 0, enumeration, 0, type.rootEnumeration.length);
        System.arraycopy(type.additionalEnumeration, 0, enumeration, type.rootEnumeration.length, type.additionalEnumeration.length);
        int i = 0;
        while (i < enumeration.length) {
            NamedNumber enumeratedItem = enumeration[i];
            String enumeratedItemName = NamingConventions.toJavaName(enumeratedItem.name);
            if (i == enumeration.length - 1) {
                buf.append(indent).append("\t").append(enumeratedItemName).append("(").append(enumeratedItem.number).append(");\n");
            } else {
                buf.append(indent).append("\t").append(enumeratedItemName).append("(").append(enumeratedItem.number).append("),\n");
            }
            ++i;
        }
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic static ").append(javaTypeName).append(" valueOf(int value){\n");
        buf.append(indent).append("\t\t").append(javaTypeName).append("[] values = values();\n");
        buf.append(indent).append("\t\tfor(int i=0;i<values.length;i++){\n");
        buf.append(indent).append("\t\t\tif(values[i].value==value){\n");
        buf.append(indent).append("\t\t\t\treturn values[i];\n");
        buf.append(indent).append("\t\t\t}\n");
        buf.append(indent).append("\t\t}\n");
        buf.append(indent).append("\t\t throw new IllegalArgumentException(\"No enum const value for \" + value);\n");
        buf.append(indent).append("\t}\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tprivate int value;\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tprivate ").append(javaTypeName).append("(int value) {\n");
        buf.append(indent).append("\t\tthis.value = value;\n");
        buf.append(indent).append("\t}\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic int value(){\n");
        buf.append(indent).append("\t\treturn value;\n");
        buf.append(indent).append("\t}\n");
        buf.append(indent).append("\n");
        if (options.generate_prints) {
            buf.append(indent).append("\tpublic void print(PrintStream out) {\n");
            buf.append(indent).append("\t\tTYPE.print(this, CONV, out);\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
        }
        CodeGeneration.generateEncoder(indent, buf, javaTypeName, options);
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic final static AsnType TYPE = ").append(javaModuleName).append(".type(").append(id).append(");\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic final static AsnConverter CONV;\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tstatic {\n");
        if (jdk14orUnder) {
            buf.append(indent).append("\t\tCONV = new ").append(converterName).append("();\n");
        } else {
            buf.append(indent).append("\t\tCONV = new ReflectionEnumeratedConverter(").append(javaTypeName).append(".class);\n");
        }
        buf.append(indent).append("\t}\n");
        buf.append(indent).append("\n");
        CodeGeneration.printValues(indent, buf, javaModuleName, javaTypeName, (Type)type, idGenerator, options);
        buf.append(indent).append("\n");
        if (jdk14orUnder) {
            buf.append(indent).append("\tpublic static class ").append(converterName).append(" extends ").append(EnumeratedConverter.class.getSimpleName()).append(" {\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\t\tpublic Object toObject(int value) {\n");
            buf.append(indent).append("\t\t\treturn " + javaTypeName + ".valueOf(value);\n");
            buf.append(indent).append("\t\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\t\tpublic int toValue(Object object) {\n");
            buf.append(indent).append("\t\t\treturn ((").append(javaTypeName).append(")object).value();\n");
            buf.append(indent).append("\t\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\t\tpublic Object toEnum(int ordinal) {\n");
            buf.append(indent).append("\t\t\treturn ").append(javaTypeName).append(".values()[ordinal];\n");
            buf.append(indent).append("\t\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\t\tpublic int toOrdinal(Object object) {\n");
            buf.append(indent).append("\t\t\treturn ((").append(javaTypeName).append(") object).ordinal();\n");
            buf.append(indent).append("\t\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
        }
        buf.append(indent).append("}\n");
    }

    private static void printSingletonEnumeratedClass(String indent, boolean anonymous, StringBuffer buf, String javaModuleName, String javaTypeName, Integer id, EnumeratedType type, IdGenerator idGenerator, JavaCompilerOptions options) {
        String enumeratedItemName;
        NamedNumber enumeratedItem;
        boolean jdk14orUnder = "J2SE-1.4".equals(options.execution_environment);
        String converterName = String.valueOf(javaTypeName) + "Converter";
        NamedNumber[] enumeration = new NamedNumber[type.rootEnumeration.length + type.additionalEnumeration.length];
        System.arraycopy(type.rootEnumeration, 0, enumeration, 0, type.rootEnumeration.length);
        System.arraycopy(type.additionalEnumeration, 0, enumeration, type.rootEnumeration.length, type.additionalEnumeration.length);
        if (anonymous) {
            buf.append(indent).append("@Anonymous\n");
        }
        buf.append(indent).append("public class ").append(javaTypeName).append(" {\n");
        int i = 0;
        while (i < enumeration.length) {
            enumeratedItem = enumeration[i];
            enumeratedItemName = NamingConventions.toJavaName(enumeratedItem.name);
            buf.append(indent).append("\tpublic static final ").append(javaTypeName).append(" ").append(enumeratedItemName);
            buf.append(indent).append(" = new ").append(javaTypeName).append("(").append(i).append(", ").append(enumeratedItem.number).append(");\n");
            ++i;
        }
        buf.append(indent).append("\n");
        buf.append(indent).append("\tprivate static ").append(javaTypeName).append("[] values = new ").append(javaTypeName).append("[] { ");
        i = 0;
        while (i < enumeration.length) {
            enumeratedItem = enumeration[i];
            enumeratedItemName = NamingConventions.toJavaName(enumeratedItem.name);
            buf.append(enumeratedItemName);
            if (i != enumeration.length - 1) {
                buf.append(", ");
            } else {
                buf.append(" };\n");
            }
            ++i;
        }
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic static ").append(javaTypeName).append(" valueOf(int value){\n");
        buf.append(indent).append("\t\tfor(int i=0;i<values.length;i++){\n");
        buf.append(indent).append("\t\t\tif(values[i].value==value){\n");
        buf.append(indent).append("\t\t\t\treturn values[i];\n");
        buf.append(indent).append("\t\t\t}\n");
        buf.append(indent).append("\t\t}\n");
        buf.append(indent).append("\t\t throw new IllegalArgumentException(\"No enum const value for \" + value);\n");
        buf.append(indent).append("\t}\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tprivate int ordinal;\n");
        buf.append(indent).append("\tprivate int value;\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tprivate ").append(javaTypeName).append("(int ordinal, int value) {\n");
        buf.append(indent).append("\t\tthis.ordinal=ordinal;\n");
        buf.append(indent).append("\t\tthis.value = value;\n");
        buf.append(indent).append("\t}\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic final int ordinal(){\n");
        buf.append(indent).append("\t\treturn ordinal;\n");
        buf.append(indent).append("\t}\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic final int value(){\n");
        buf.append(indent).append("\t\treturn value;\n");
        buf.append(indent).append("\t}\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic static ").append(javaTypeName).append("[] values() {\n");
        buf.append(indent).append("\t\treturn values;\n");
        buf.append(indent).append("\t}\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic String toString() {\n");
        i = 0;
        while (i < enumeration.length) {
            enumeratedItem = enumeration[i];
            enumeratedItemName = NamingConventions.toJavaName(enumeratedItem.name);
            if (i == 0) {
                buf.append(indent).append("\t\tif(this==").append(enumeratedItemName).append("){\n");
            } else {
                buf.append(indent).append("\t\telse if(this==").append(enumeratedItemName).append("){\n");
            }
            buf.append(indent).append("\t\t\treturn \"").append(enumeratedItemName).append("\";\n");
            buf.append(indent).append("\t\t}\n");
            ++i;
        }
        buf.append(indent).append("\t\treturn \"\";\n");
        buf.append(indent).append("\t}\n");
        buf.append(indent).append("\n");
        CodeGeneration.generateMethods(indent, buf, javaTypeName, options);
        CodeGeneration.generateEncoder(indent, buf, javaTypeName, options);
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic final static AsnType TYPE = ").append(javaModuleName).append(".type(").append(id).append(");\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic final static AsnConverter CONV;\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tstatic {\n");
        if (jdk14orUnder) {
            buf.append(indent).append("\t\tCONV = new ").append(converterName).append("();\n");
        } else {
            buf.append(indent).append("\t\tCONV = new ReflectionEnumeratedConverter(").append(javaTypeName).append(".class);\n");
        }
        buf.append(indent).append("\t}\n");
        buf.append(indent).append("\n");
        CodeGeneration.printValues(indent, buf, javaModuleName, javaTypeName, (Type)type, idGenerator, options);
        buf.append(indent).append("\n");
        if (jdk14orUnder) {
            buf.append(indent).append("\tpublic static class ").append(converterName).append(" extends ").append(EnumeratedConverter.class.getSimpleName()).append(" {\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\t\tpublic Object toObject(int value) {\n");
            buf.append(indent).append("\t\t\treturn " + javaTypeName + ".valueOf(value);\n");
            buf.append(indent).append("\t\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\t\tpublic int toValue(Object object) {\n");
            buf.append(indent).append("\t\t\treturn ((").append(javaTypeName).append(")object).value();\n");
            buf.append(indent).append("\t\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\t\tpublic Object toEnum(int ordinal) {\n");
            buf.append(indent).append("\t\t\treturn ").append(javaTypeName).append(".values()[ordinal];\n");
            buf.append(indent).append("\t\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\t\tpublic int toOrdinal(Object object) {\n");
            buf.append(indent).append("\t\t\treturn ((").append(javaTypeName).append(") object).ordinal();\n");
            buf.append(indent).append("\t\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
        }
        buf.append(indent).append("}\n");
    }

    private static void printBitStringClass(String indent, boolean anonymous, StringBuffer buf, String javaModuleName, String javaTypeName, Integer id, BitStringType type, IdGenerator idGenerator, JavaCompilerOptions options) {
        String name;
        NamedNumber namedBit;
        boolean jdk14orUnder = "J2SE-1.4".equals(options.execution_environment);
        String converterName = String.valueOf(javaTypeName) + "Converter";
        if (anonymous) {
            buf.append(indent).append("@Anonymous\n");
        }
        buf.append(indent).append("public class ").append(javaTypeName).append(" extends BitString {\n");
        buf.append(indent).append("\n");
        int i = 0;
        while (i < type.namedBits.length) {
            namedBit = type.namedBits[i];
            name = NamingConventions.toJavaName(namedBit.name);
            buf.append(indent).append("\tpublic static final int ").append(name).append(" = ").append(namedBit.number).append(";\n");
            ++i;
        }
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic ").append(javaTypeName).append("(byte[] bytes, byte unusedBits) {\n");
        buf.append(indent).append("\t\tsuper(bytes, unusedBits);\n");
        buf.append(indent).append("\t}\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic ").append(javaTypeName).append("(int size) {\n");
        buf.append(indent).append("\t\tsuper(size);\n");
        buf.append(indent).append("\t}\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic ").append(javaTypeName).append("() {\n");
        buf.append(indent).append("\t\tsuper(0);\n");
        buf.append(indent).append("\t}\n");
        buf.append(indent).append("\n");
        i = 0;
        while (i < type.namedBits.length) {
            namedBit = type.namedBits[i];
            name = NamingConventions.toJavaName(namedBit.name);
            String setterGetterName = NamingConventions.toSetterGetterName(namedBit.name);
            buf.append(indent).append("\tpublic boolean get").append(setterGetterName).append("(){\n");
            buf.append(indent).append("\t\treturn getBit(").append(name).append(");\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\tpublic void set").append(setterGetterName).append("(){\n");
            buf.append(indent).append("\t\tsetBit(").append(name).append(", true);\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\tpublic void clear").append(setterGetterName).append("(){\n");
            buf.append(indent).append("\t\tsetBit(").append(name).append(", false);\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
            ++i;
        }
        CodeGeneration.generateMethods(indent, buf, javaTypeName, options);
        CodeGeneration.generateEncoder(indent, buf, javaTypeName, options);
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic final static AsnType TYPE = ").append(javaModuleName).append(".type(").append(id).append(");\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic final static AsnConverter CONV;\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tstatic {\n");
        if (jdk14orUnder) {
            buf.append(indent).append("\t\tCONV = new ").append(converterName).append("();\n");
        } else {
            buf.append(indent).append("\t\tCONV = new ReflectionBitStringConverter(").append(javaTypeName).append(".class);\n");
        }
        buf.append(indent).append("\t}\n");
        buf.append(indent).append("\n");
        CodeGeneration.printValues(indent, buf, javaModuleName, javaTypeName, (Type)type, idGenerator, options);
        buf.append(indent).append("\n");
        if (jdk14orUnder) {
            buf.append(indent).append("\tpublic static class ").append(converterName).append(" extends ").append(BitStringConverter.class.getSimpleName()).append(" {\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\t\tpublic Object createObject(byte[] bytes, byte unusedBits) {\n");
            buf.append(indent).append("\t\t\treturn new ").append(javaTypeName).append("(bytes, unusedBits);\n");
            buf.append(indent).append("\t\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
        }
        buf.append(indent).append("}\n");
    }

    private static void printIntegerClass(String indent, StringBuffer buf, String javaModuleName, String javaTypeName, Integer id, IntegerType type, Constraint constraint, IdGenerator idGenerator, JavaCompilerOptions options) {
        buf.append(indent).append("public class ").append(javaTypeName).append(" {\n");
        buf.append(indent).append("\n");
        String typeName = null;
        if ("automatic".equals(options.intger_mapping)) {
            if (constraint != null) {
                BigInteger upperBound;
                IntegerRange effectiveRange = constraint.reduceEffectiveIntegerRange();
                BigInteger lowerBound = effectiveRange == null || effectiveRange.lowerBound == null ? IntegerType.MIN : effectiveRange.lowerBound;
                BigInteger bigInteger = upperBound = effectiveRange == null || effectiveRange.upperBound == null ? IntegerType.MAX : effectiveRange.upperBound;
                typeName = lowerBound.compareTo(INTEGER_MIN) >= 0 && upperBound.compareTo(INTEGER_MAX) <= 0 ? "Integer" : (lowerBound.compareTo(LONG_MIN) >= 0 && upperBound.compareTo(LONG_MAX) <= 0 ? "Long" : "BigInteger");
            } else {
                typeName = "Long";
            }
        } else if ("integer".equals(options.intger_mapping)) {
            typeName = "Integer";
        } else if ("long".equals(options.intger_mapping)) {
            typeName = "Long";
        } else if ("BigInteger".equals(options.intger_mapping)) {
            typeName = "BigInteger";
        }
        int i = 0;
        while (i < type.namedNumbers.length) {
            NamedNumber namedBit = type.namedNumbers[i];
            String name = NamingConventions.toJavaName(namedBit.name);
            buf.append(indent).append("\tpublic static final ").append(typeName).append(" ").append(name).append(" = ").append("BigInteger".equals(typeName) ? "new BigInteger(\"" + namedBit.number + "\")" : namedBit.number).append("Long".equals(typeName) ? "L" : "").append(";\n");
            ++i;
        }
        buf.append(indent).append("\n");
        CodeGeneration.generateEncoder1(indent, buf, CodeGeneration.getTypeName((Type)type, constraint, options), options);
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic final static AsnType TYPE = ").append(javaModuleName).append(".type(").append(id).append(");\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic final static AsnConverter CONV = ").append(CodeGeneration.getConverterName((Type)type, constraint, options)).append(";\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\n");
        CodeGeneration.printValues(indent, buf, javaModuleName, typeName, (Type)type, idGenerator, options);
        buf.append(indent).append("\n");
        buf.append(indent).append("}\n");
    }

    private static void printGenericClass(String indent, StringBuffer buf, String javaModuleName, String javaTypeName, Integer id, Type type, Constraint constraint, IdGenerator idGenerator, JavaCompilerOptions options) {
        buf.append(indent).append("public class ").append(javaTypeName).append(" {\n");
        buf.append(indent).append("\n");
        CodeGeneration.generateEncoder1(indent, buf, CodeGeneration.getTypeName(type, constraint, options), options);
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic final static AsnType TYPE = ").append(javaModuleName).append(".type(").append(id).append(");\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\tpublic final static AsnConverter CONV = ").append(CodeGeneration.getConverterName(type, constraint, options)).append(";\n");
        buf.append(indent).append("\n");
        buf.append(indent).append("\n");
        javaTypeName = CodeGeneration.getTypeName(type, constraint, options);
        CodeGeneration.printValues(indent, buf, javaModuleName, javaTypeName, type, idGenerator, options);
        buf.append(indent).append("\n");
        buf.append(indent).append("}\n");
    }

    private static String getTypeName(FieldSpec field, JavaCompilerOptions options) {
        if (field instanceof ObjectFieldSpec) {
            ObjectFieldSpec objectFieldSpec = (ObjectFieldSpec)field;
            ObjectClass objectClass = objectFieldSpec.objectClass;
            String typeName = NamingConventions.toJavaTypeName(objectClass.name);
            return typeName;
        }
        if (field instanceof ObjectSetFieldSpec) {
            ObjectSetFieldSpec objectSetFieldSpec = (ObjectSetFieldSpec)field;
            ObjectClass objectClass = objectSetFieldSpec.objectClass;
            String componentTypeName = NamingConventions.toJavaTypeName(objectClass.name);
            boolean jdk14orUnder = "J2SE-1.4".equals(options.execution_environment);
            if (jdk14orUnder) {
                if (componentTypeName.startsWith("Vector/*") && componentTypeName.endsWith(">*/")) {
                    componentTypeName = "Vector" + componentTypeName.substring(8, componentTypeName.length() - 2);
                }
                return "Vector/*<" + componentTypeName + ">*/";
            }
            return "Vector<" + componentTypeName + ">";
        }
        if (field instanceof TypeFieldSpec) {
            return "AsnType";
        }
        if (field instanceof FixedTypeValueFieldSpec) {
            FixedTypeValueFieldSpec fixedTypeValueFieldSpec = (FixedTypeValueFieldSpec)field;
            Type type = fixedTypeValueFieldSpec.type;
            return CodeGeneration.getTypeName(type, null, options);
        }
        if (field instanceof FixedTypeValueSetFieldSpec) {
            FixedTypeValueSetFieldSpec fixedTypeValueSetFieldSpec = (FixedTypeValueSetFieldSpec)field;
            Type type = fixedTypeValueSetFieldSpec.type;
            String componentTypeName = CodeGeneration.getTypeName(type, null, options);
            boolean jdk14orUnder = "J2SE-1.4".equals(options.execution_environment);
            if (jdk14orUnder) {
                if (componentTypeName.startsWith("Vector/*") && componentTypeName.endsWith(">*/")) {
                    componentTypeName = "Vector" + componentTypeName.substring(8, componentTypeName.length() - 2);
                }
                return "Vector/*<" + componentTypeName + ">*/";
            }
            return "Vector<" + componentTypeName + ">";
        }
        return "byte[]";
    }

    private static String getConverterName(String javaModuleName, FieldSpec field, JavaCompilerOptions options) {
        if (field instanceof ObjectFieldSpec) {
            ObjectFieldSpec objectFieldSpec = (ObjectFieldSpec)field;
            ObjectClass objectClass = objectFieldSpec.objectClass;
            String typeName = NamingConventions.toJavaTypeName(objectClass.name);
            return String.valueOf(typeName) + ".CONV";
        }
        if (field instanceof ObjectSetFieldSpec) {
            ObjectSetFieldSpec objectSetFieldSpec = (ObjectSetFieldSpec)field;
            ObjectClass objectClass = objectSetFieldSpec.objectClass;
            String componentTypeName = NamingConventions.toJavaTypeName(objectClass.name);
            return "new VectorConverter(" + componentTypeName + ".CONV)";
        }
        if (field instanceof TypeFieldSpec) {
            return "AsnType.CONV";
        }
        if (field instanceof FixedTypeValueFieldSpec) {
            FixedTypeValueFieldSpec fixedTypeValueFieldSpec = (FixedTypeValueFieldSpec)field;
            Type type = fixedTypeValueFieldSpec.type;
            return CodeGeneration.getConverterName(type, null, options);
        }
        if (field instanceof FixedTypeValueSetFieldSpec) {
            FixedTypeValueSetFieldSpec fixedTypeValueSetFieldSpec = (FixedTypeValueSetFieldSpec)field;
            Type type = fixedTypeValueSetFieldSpec.type;
            String componentConverterName = CodeGeneration.getConverterName(type, null, options);
            return "new VectorConverter(" + componentConverterName + ")";
        }
        return "OctetStringConverter.INSTANCE";
    }

    private static String getTypeName(Type type, Constraint constraint, JavaCompilerOptions options) {
        if (type instanceof ConstraintType) {
            ConstraintType constraintType = (ConstraintType)type;
            constraint = Constraint.safeSerial((Constraint)constraintType.constraint, (Constraint)constraint);
            return CodeGeneration.getTypeName(constraintType.underlyingType, constraint, options);
        }
        if (type instanceof TypeReference) {
            TypeReference typeReference = (TypeReference)type;
            Type underlyingType = typeReference.underlyingType;
            if (underlyingType.isAtomicType()) {
                return CodeGeneration.getTypeName(underlyingType, constraint, options);
            }
            if (underlyingType.isCustomizedType()) {
                String typeName = NamingConventions.toJavaTypeName(typeReference.name);
                return typeName;
            }
            return CodeGeneration.getTypeName(underlyingType, constraint, options);
        }
        if (type instanceof TaggedType) {
            return CodeGeneration.getTypeName(((TaggedType)type).underlyingType, constraint, options);
        }
        if (type instanceof ClassFieldFixType) {
            constraint = constraint instanceof TableConstraint ? null : constraint;
            return CodeGeneration.getTypeName(((ClassFieldFixType)type).acutalType, constraint, options);
        }
        if (type instanceof BooleanType) {
            return "Boolean";
        }
        if (type instanceof NullType) {
            return "Object";
        }
        if (type instanceof IntegerType) {
            if ("automatic".equals(options.intger_mapping)) {
                if (constraint != null) {
                    BigInteger upperBound;
                    IntegerRange effectiveRange = constraint.reduceEffectiveIntegerRange();
                    BigInteger lowerBound = effectiveRange == null || effectiveRange.lowerBound == null ? IntegerType.MIN : effectiveRange.lowerBound;
                    BigInteger bigInteger = upperBound = effectiveRange == null || effectiveRange.upperBound == null ? IntegerType.MAX : effectiveRange.upperBound;
                    if (lowerBound.compareTo(INTEGER_MIN) >= 0 && upperBound.compareTo(INTEGER_MAX) <= 0) {
                        return "Integer";
                    }
                    if (lowerBound.compareTo(LONG_MIN) >= 0 && upperBound.compareTo(LONG_MAX) <= 0) {
                        return "Long";
                    }
                    return "BigInteger";
                }
                return "Long";
            }
            if ("integer".equals(options.intger_mapping)) {
                return "Integer";
            }
            if ("long".equals(options.intger_mapping)) {
                return "Long";
            }
            if ("BigInteger".equals(options.intger_mapping)) {
                return "BigInteger";
            }
        } else {
            if (type instanceof RealType) {
                if ("float".equals(options.real_mapping)) {
                    return "Float";
                }
                if ("double".equals(options.real_mapping)) {
                    return "Double";
                }
                return "Double";
            }
            if (type instanceof BitStringType) {
                return "BitString";
            }
            if (type instanceof OctetStringType) {
                return "byte[]";
            }
            if (type instanceof ObjectIdentifierType) {
                return "ObjectIdentifier";
            }
            if (type instanceof RelativeOidType) {
                return "ObjectIdentifier";
            }
            if (type instanceof CharacterStringType) {
                return "String";
            }
            if (type instanceof ObjectDescriptorType) {
                return "String";
            }
            if (type instanceof GeneralizedTimeType) {
                return "Date";
            }
            if (type instanceof UTCTimeType) {
                return "Date";
            }
            if (type instanceof ListType) {
                ListType listType = (ListType)type;
                Type componentType = listType.componentType;
                String componentTypeName = CodeGeneration.getTypeName(componentType, null, options);
                boolean jdk14orUnder = "J2SE-1.4".equals(options.execution_environment);
                if (jdk14orUnder) {
                    if ("Array".equals(options.list_mapping)) {
                        return String.valueOf(componentTypeName) + "[]";
                    }
                    if (componentTypeName.startsWith("Vector/*") && componentTypeName.endsWith(">*/")) {
                        componentTypeName = "Vector" + componentTypeName.substring(8, componentTypeName.length() - 2);
                    }
                    return "Vector/*<" + componentTypeName + ">*/";
                }
                if ("Array".equals(options.list_mapping)) {
                    return String.valueOf(componentTypeName) + "[]";
                }
                if ("ArrayList".equals(options.list_mapping)) {
                    return "List<" + componentTypeName + ">";
                }
                if ("LinkedList".equals(options.list_mapping)) {
                    return "List<" + componentTypeName + ">";
                }
                return "Vector<" + componentTypeName + ">";
            }
            if (type instanceof ClassFieldOpenType && constraint instanceof ValueSet) {
                ValueSet valueSet = (ValueSet)constraint;
                ElementSet rootElementSet = valueSet.rootElementSet;
                if (rootElementSet instanceof SingleType) {
                    SingleType singleType = (SingleType)rootElementSet;
                    return CodeGeneration.getTypeName(singleType.type, null, options);
                }
            }
        }
        return "Object";
    }

    private static String getConverterName(Type type, Constraint constraint, JavaCompilerOptions options) {
        if (type instanceof TaggedType) {
            return CodeGeneration.getConverterName(((TaggedType)type).underlyingType, constraint, options);
        }
        if (type instanceof ClassFieldFixType) {
            constraint = constraint instanceof TableConstraint ? null : constraint;
            return CodeGeneration.getConverterName(((ClassFieldFixType)type).acutalType, constraint, options);
        }
        if (type instanceof ConstraintType) {
            ConstraintType constraintType = (ConstraintType)type;
            constraint = Constraint.safeSerial((Constraint)constraintType.constraint, (Constraint)constraint);
            return CodeGeneration.getConverterName(constraintType.underlyingType, constraint, options);
        }
        if (type instanceof TypeReference) {
            TypeReference typeReference = (TypeReference)type;
            Type underlyingType = typeReference.underlyingType;
            if (underlyingType.isCustomizedType()) {
                String typeName = NamingConventions.toJavaTypeName(typeReference.name);
                return String.valueOf(typeName) + ".CONV";
            }
            if (constraint != null && (constraint.reduceEffectiveIntegerRange() != null || constraint.reduceEffectivePermittedAlphabet() != null || constraint.reduceEffectiveSizeConstraint() != null)) {
                return CodeGeneration.getConverterName(underlyingType, constraint, options);
            }
            String typeName = NamingConventions.toJavaTypeName(typeReference.name);
            return String.valueOf(typeName) + ".CONV";
        }
        if (type instanceof BooleanType) {
            return "BooleanConverter.INSTANCE";
        }
        if (type instanceof NullType) {
            return "NullConverter.INSTANCE";
        }
        if (type instanceof IntegerType) {
            if ("automatic".equals(options.intger_mapping)) {
                if (constraint != null) {
                    BigInteger upperBound;
                    IntegerRange effectiveRange = constraint.reduceEffectiveIntegerRange();
                    BigInteger lowerBound = effectiveRange == null || effectiveRange.lowerBound == null ? IntegerType.MIN : effectiveRange.lowerBound;
                    BigInteger bigInteger = upperBound = effectiveRange == null || effectiveRange.upperBound == null ? IntegerType.MAX : effectiveRange.upperBound;
                    if (lowerBound.compareTo(INTEGER_MIN) >= 0 && upperBound.compareTo(INTEGER_MAX) <= 0) {
                        return "IntegerConverter.INSTANCE";
                    }
                    if (lowerBound.compareTo(LONG_MIN) >= 0 && upperBound.compareTo(LONG_MAX) <= 0) {
                        return "LongConverter.INSTANCE";
                    }
                    return "BigIntegerConverter.INSTANCE";
                }
                return "LongConverter.INSTANCE";
            }
            if ("integer".equals(options.intger_mapping)) {
                return "IntegerConverter.INSTANCE";
            }
            if ("long".equals(options.intger_mapping)) {
                return "LongConverter.INSTANCE";
            }
            if ("BigInteger".equals(options.intger_mapping)) {
                return "BigIntegerConverter.INSTANCE";
            }
        } else {
            if (type instanceof RealType) {
                if ("float".equals(options.real_mapping)) {
                    return "FloatConverter.INSTANCE";
                }
                if ("double".equals(options.real_mapping)) {
                    return "DoubleConverter.INSTANCE";
                }
                return "DoubleConverter.INSTANCE";
            }
            if (type instanceof BitStringType) {
                return "BitStringConverter.INSTANCE";
            }
            if (type instanceof OctetStringType) {
                return "OctetStringConverter.INSTANCE";
            }
            if (type instanceof ObjectIdentifierType || type instanceof RelativeOidType) {
                return "OIDConverter.INSTANCE";
            }
            if (type instanceof CharacterStringType || type instanceof ObjectDescriptorType) {
                return "StringConverter.INSTANCE";
            }
            if (type instanceof GeneralizedTimeType || type instanceof UTCTimeType) {
                return "DateConverter.INSTANCE";
            }
            if (type instanceof ListType) {
                ListType listType = (ListType)type;
                Type componentType = listType.componentType;
                if ("Array".equals(options.list_mapping)) {
                    return "new ArrayConverter(" + CodeGeneration.getConverterName(componentType, null, options) + ")";
                }
                if ("ArrayList".equals(options.list_mapping)) {
                    return "new ArrayListConverter(" + CodeGeneration.getConverterName(componentType, null, options) + ")";
                }
                if ("LinkedList".equals(options.list_mapping)) {
                    return "new LinkedListConverter(" + CodeGeneration.getConverterName(componentType, null, options) + ")";
                }
                return "new VectorConverter(" + CodeGeneration.getConverterName(componentType, null, options) + ")";
            }
            if (type instanceof ClassFieldOpenType) {
                ClassFieldOpenType classFieldOpenType = (ClassFieldOpenType)type;
                ObjectClass objectClass = classFieldOpenType.objectClass;
                if (constraint instanceof TableConstraint) {
                    TableConstraint tableConstraint = (TableConstraint)constraint;
                    String javaClassName = NamingConventions.toJavaName(objectClass.name);
                    String objectSetName = NamingConventions.toJavaName(tableConstraint.objectSetName);
                    ObjectSet objectSet = tableConstraint.objectSet;
                    ObjectSetDefn objectSetDefn = objectSet.resolve();
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("new OpenValueConverter(").append(javaClassName).append(".").append(objectSetName).append(", ").append(javaClassName).append(".CONV, ");
                    LinkedList<String> names = new LinkedList<String>();
                    String[] stringArray = classFieldOpenType.compoundFieldNames;
                    int n = classFieldOpenType.compoundFieldNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        names.add(name);
                        ++n2;
                    }
                    CodeGeneration.printObjectSetConverters(buffer, objectSetDefn, names, options);
                    buffer.append(")");
                    return buffer.toString();
                }
                if (constraint instanceof ValueSet) {
                    ValueSet valueSet = (ValueSet)constraint;
                    ElementSet rootElementSet = valueSet.rootElementSet;
                    if (rootElementSet instanceof SingleType) {
                        SingleType singleType = (SingleType)rootElementSet;
                        StringBuffer buffer = new StringBuffer();
                        buffer.append("new OpenValueConverter(new AsnConverter[] { null, null, ");
                        buffer.append(CodeGeneration.getConverterName(singleType.type, null, options));
                        buffer.append("} )");
                        return buffer.toString();
                    }
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getAnnotation(Type type, Constraint constraint, JavaCompilerOptions options) {
        if (type instanceof TaggedType) {
            return CodeGeneration.getAnnotation(((TaggedType)type).underlyingType, constraint, options);
        }
        if (type instanceof ClassFieldFixType) {
            constraint = constraint instanceof TableConstraint ? null : constraint;
            return CodeGeneration.getAnnotation(((ClassFieldFixType)type).acutalType, constraint, options);
        }
        if (type instanceof ConstraintType) {
            ConstraintType constraintType = (ConstraintType)type;
            constraint = Constraint.safeSerial((Constraint)constraintType.constraint, (Constraint)constraint);
            return CodeGeneration.getAnnotation(constraintType.underlyingType, constraint, options);
        }
        if (type instanceof TypeReference) {
            TypeReference typeReference = (TypeReference)type;
            if (constraint == null) return null;
            return CodeGeneration.getAnnotation(typeReference.underlyingType, constraint, options);
        }
        if (type instanceof BooleanType) {
            return null;
        }
        if (type instanceof NullType) {
            return null;
        }
        if (type instanceof IntegerType) {
            BigInteger upperBound;
            if (constraint == null) return null;
            IntegerRange effectiveRange = constraint.reduceEffectiveIntegerRange();
            BigInteger lowerBound = effectiveRange == null || effectiveRange.lowerBound == null ? IntegerType.MIN : effectiveRange.lowerBound;
            BigInteger bigInteger = upperBound = effectiveRange == null || effectiveRange.upperBound == null ? IntegerType.MAX : effectiveRange.upperBound;
            if (lowerBound.compareTo(LONG_MIN) >= 0 && upperBound.compareTo(LONG_MAX) <= 0) {
                if (effectiveRange.lowerBound != null) {
                    if (effectiveRange.upperBound == null) return "@Min(" + effectiveRange.lowerBound + "L)";
                    return "@Min(" + effectiveRange.lowerBound + "L) @Max(" + effectiveRange.upperBound + "L)";
                }
                if (effectiveRange.upperBound == null) return null;
                return "@Max(" + effectiveRange.upperBound + "L)";
            }
            if (effectiveRange.lowerBound != null) {
                if (effectiveRange.upperBound == null) return "@DecimalMin(\"" + effectiveRange.lowerBound + "\")";
                return "@DecimalMin(\"" + effectiveRange.lowerBound + "\") @DecimalMax(\"" + effectiveRange.upperBound + "\")";
            }
            if (effectiveRange.upperBound == null) return null;
            return "@DecimalMax(\"" + effectiveRange.upperBound + "\")";
        }
        if (type instanceof RealType) {
            return null;
        }
        if (!(type instanceof BitStringType) && !(type instanceof OctetStringType) && !(type instanceof ListType)) return null;
        if (constraint == null) return null;
        SizeConstraint size = constraint.reduceEffectiveSizeConstraint();
        if (size == null) {
            return null;
        }
        if (size.lowerBound != null) {
            if (size.upperBound == null) return null;
            return "@Size(min=" + size.lowerBound + ", max=" + size.upperBound + ")";
        }
        if (size.upperBound == null) return null;
        return "@Size(max=" + size.upperBound + ")";
    }

    private static void printObjectSetConverters(StringBuffer buffer, ObjectSetDefn objectSet, LinkedList<String> names, JavaCompilerOptions options) {
        ObjectClassDefn objectClass = objectSet.objectClass;
        String fieldName = names.removeFirst();
        int fieldIndex = objectClass.getFieldIndex(fieldName);
        buffer.append("new Object[]{");
        for (InformationObject object : objectSet.objects) {
            Object field = object.fields[fieldIndex];
            CodeGeneration.printFieldConverters(buffer, field, names, options);
            buffer.append(",");
        }
        buffer.append("}");
        names.addFirst(fieldName);
    }

    private static void printObjectConverters(StringBuffer buffer, InformationObject object, LinkedList<String> names, JavaCompilerOptions options) {
        ObjectClassDefn objectClass = object.objectClass;
        String fieldName = names.removeFirst();
        int fieldIndex = objectClass.getFieldIndex(fieldName);
        Object field = object.fields[fieldIndex];
        CodeGeneration.printFieldConverters(buffer, field, names, options);
        names.addFirst(fieldName);
    }

    private static void printFieldConverters(StringBuffer buffer, Object field, LinkedList<String> names, JavaCompilerOptions options) {
        if (field instanceof InformationObject) {
            CodeGeneration.printObjectConverters(buffer, (InformationObject)field, names, options);
        } else if (field instanceof ObjectSetReference) {
            CodeGeneration.printFieldConverters(buffer, ((ObjectSetReference)field).underlyingObjectSet, names, options);
        } else if (field instanceof ObjectSetDefn) {
            CodeGeneration.printObjectSetConverters(buffer, (ObjectSetDefn)field, names, options);
        }
        if (field instanceof Type) {
            buffer.append(CodeGeneration.getConverterName((Type)field, null, options));
        } else if (field == null) {
            buffer.append("null");
        }
    }

    private static void generateMethods(String indent, StringBuffer buf, String typeName, JavaCompilerOptions options) {
        if (options.generate_clones) {
            buf.append(indent).append("\tpublic Object clone() {\n");
            buf.append(indent).append("\t\treturn TYPE.clone(this, CONV);\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
        }
        if (options.generate_equals) {
            buf.append(indent).append("\tpublic boolean equals(Object obj) {\n");
            buf.append(indent).append("\t\tif(!(obj instanceof ").append(typeName).append(")){\n");
            buf.append(indent).append("\t\t\treturn false;\n");
            buf.append(indent).append("\t\t}\n");
            buf.append(indent).append("\t\treturn TYPE.equals(this, obj, CONV);\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
        }
        if (options.generate_prints) {
            buf.append(indent).append("\tpublic void print(PrintStream out) {\n");
            buf.append(indent).append("\t\tTYPE.print(this, CONV, out);\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
        }
    }

    private static void generateEncoder(String indent, StringBuffer buf, String typeName, JavaCompilerOptions options) {
        if (options.generate_ber_encoder) {
            buf.append(indent).append("\tpublic void ber_encode(OutputStream out) throws IOException {\n");
            buf.append(indent).append("\t\tTYPE").append(".encode(this, EncodingRules.BASIC_ENCODING_RULES, CONV, out);\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\tpublic static ").append(typeName).append(" ber_decode(InputStream in) throws IOException {\n");
            buf.append(indent).append("\t\treturn (").append(typeName).append(")TYPE.decode(in, EncodingRules.BASIC_ENCODING_RULES, CONV);\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
        }
        if (options.generate_cer_encoder) {
            buf.append(indent).append("\tpublic void cer_encode(OutputStream out) throws IOException {\n");
            buf.append(indent).append("\t\tTYPE.encode(this, EncodingRules.CANONICAL_ENCODING_RULES, CONV, out);\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\tpublic static ").append(typeName).append(" cer_decode(InputStream in) throws IOException {\n");
            buf.append(indent).append("\t\treturn (").append(typeName).append(")TYPE.decode(in, EncodingRules.CANONICAL_ENCODING_RULES, CONV);\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
        }
        if (options.generate_der_encoder) {
            buf.append(indent).append("\tpublic void der_encode(OutputStream out) throws IOException {\n");
            buf.append(indent).append("\t\tTYPE.encode(this, EncodingRules.DISTINGUISHED_ENCODING_RULES, CONV, out);\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\tpublic static ").append(typeName).append(" der_decode(InputStream in) throws IOException {\n");
            buf.append(indent).append("\t\treturn (").append(typeName).append(")TYPE.decode(in, EncodingRules.DISTINGUISHED_ENCODING_RULES, CONV);\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
        }
        if (options.generate_per_encoder) {
            buf.append(indent).append("\tpublic void per_encode(boolean align, OutputStream out) throws IOException {\n");
            buf.append(indent).append("\t\tTYPE.encode(this, align? EncodingRules.ALIGNED_PACKED_ENCODING_RULES:EncodingRules.UNALIGNED_PACKED_ENCODING_RULES, CONV, out);\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\tpublic static ").append(typeName).append(" per_decode(boolean align, InputStream in) throws IOException {\n");
            buf.append(indent).append("\t\treturn (").append(typeName).append(")TYPE.decode(in, align? EncodingRules.ALIGNED_PACKED_ENCODING_RULES:EncodingRules.UNALIGNED_PACKED_ENCODING_RULES, CONV);\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
        }
    }

    private static void generateEncoder1(String indent, StringBuffer buf, String typeName, JavaCompilerOptions options) {
        if (options.generate_ber_encoder) {
            buf.append(indent).append("\tpublic static void ber_encode(").append(typeName).append(" object, OutputStream out) throws IOException {\n");
            buf.append(indent).append("\t\tTYPE").append(".encode(object, EncodingRules.BASIC_ENCODING_RULES, CONV, out);\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\tpublic static ").append(typeName).append(" ber_decode(InputStream in) throws IOException {\n");
            buf.append(indent).append("\t\treturn (").append(typeName).append(")TYPE.decode(in, EncodingRules.BASIC_ENCODING_RULES, CONV);\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
        }
        if (options.generate_cer_encoder) {
            buf.append(indent).append("\tpublic static void cer_encode(").append(typeName).append(" object, OutputStream out) throws IOException {\n");
            buf.append(indent).append("\t\tTYPE.encode(object, EncodingRules.CANONICAL_ENCODING_RULES, CONV, out);\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\tpublic static ").append(typeName).append(" cer_decode(InputStream in) throws IOException {\n");
            buf.append(indent).append("\t\treturn (").append(typeName).append(")TYPE.decode(in, EncodingRules.CANONICAL_ENCODING_RULES, CONV);\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
        }
        if (options.generate_der_encoder) {
            buf.append(indent).append("\tpublic static void der_encode(").append(typeName).append(" object, OutputStream out) throws IOException {\n");
            buf.append(indent).append("\t\tTYPE.encode(object, EncodingRules.DISTINGUISHED_ENCODING_RULES, CONV, out);\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\tpublic static ").append(typeName).append(" der_decode(InputStream in) throws IOException {\n");
            buf.append(indent).append("\t\treturn (").append(typeName).append(")TYPE.decode(in, EncodingRules.DISTINGUISHED_ENCODING_RULES, CONV);\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
        }
        if (options.generate_per_encoder) {
            buf.append(indent).append("\tpublic static void per_encode(").append(typeName).append(" object, boolean align, OutputStream out) throws IOException {\n");
            buf.append(indent).append("\t\tTYPE.encode(object, align? EncodingRules.ALIGNED_PACKED_ENCODING_RULES:EncodingRules.UNALIGNED_PACKED_ENCODING_RULES, CONV, out);\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
            buf.append(indent).append("\tpublic static ").append(typeName).append(" per_decode(boolean align, InputStream in) throws IOException {\n");
            buf.append(indent).append("\t\treturn (").append(typeName).append(")TYPE.decode(in, align? EncodingRules.ALIGNED_PACKED_ENCODING_RULES:EncodingRules.UNALIGNED_PACKED_ENCODING_RULES, CONV);\n");
            buf.append(indent).append("\t}\n");
            buf.append(indent).append("\n");
        }
    }

    private static void printValues(String indent, StringBuffer buf, String javaModuleName, String javaTypeName, Type type, IdGenerator idGenerator, JavaCompilerOptions options) {
        for (Map.Entry entry : type.values.entrySet()) {
            String javaValueName = NamingConventions.toJavaName((String)entry.getKey());
            Integer valueId = idGenerator.getId(type.module.name, (String)entry.getKey());
            buf.append(indent).append("\tpublic final static ").append(javaTypeName).append(" ").append(javaValueName).append(" = (").append(javaTypeName).append(")").append(javaModuleName).append(".value(").append(valueId).append(",CONV);\n\n");
        }
    }

    private static void printObjectAndObjectSets(String indent, StringBuffer buf, String javaModuleName, String javaTypeName, ObjectClassDefn clazz, IdGenerator idGenerator, JavaCompilerOptions options) {
        boolean jdk14orUnder = "J2SE-1.4".equals(options.execution_environment);
        String objectSetType = jdk14orUnder ? "Vector" : "Vector<" + javaTypeName + ">";
        for (Map.Entry entry : clazz.objects.entrySet()) {
            String javaObjectName = NamingConventions.toJavaName((String)entry.getKey());
            Integer objectId = idGenerator.getId(clazz.module.name, (String)entry.getKey());
            buf.append(indent).append("\tpublic final static ").append(javaTypeName).append(" ").append(javaObjectName).append(" = (").append(javaTypeName).append(")").append(javaModuleName).append(".object(").append(objectId).append(",CONV);\n\n");
        }
        for (Map.Entry entry : clazz.objectSets.entrySet()) {
            String javaObjectSetName = NamingConventions.toJavaName((String)entry.getKey());
            Integer objectSetId = idGenerator.getId(clazz.module.name, (String)entry.getKey());
            buf.append(indent).append("\tpublic final static ").append(objectSetType).append(" ").append(javaObjectSetName).append(" = (").append(objectSetType).append(") ").append(javaModuleName).append(".objectSet(").append(objectSetId).append(",CONV);\n\n");
        }
    }
}

