/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.asnjc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.asnlab.asndt.asnjc.CodeGeneration;
import org.asnlab.asndt.asnjc.IdGenerator;
import org.asnlab.asndt.asnjc.JavaCompilerOptions;
import org.asnlab.asndt.asnjc.NamingConventions;
import org.asnlab.asndt.core.asn.AsnType;
import org.asnlab.asndt.core.asn.BitStringType;
import org.asnlab.asndt.core.asn.BitStringValue;
import org.asnlab.asndt.core.asn.CharacterString;
import org.asnlab.asndt.core.asn.ChoiceType;
import org.asnlab.asndt.core.asn.ClassFieldFixType;
import org.asnlab.asndt.core.asn.ClassFieldOpenType;
import org.asnlab.asndt.core.asn.Component;
import org.asnlab.asndt.core.asn.Constraint;
import org.asnlab.asndt.core.asn.ConstraintType;
import org.asnlab.asndt.core.asn.DerivedType;
import org.asnlab.asndt.core.asn.ExtensionAddition;
import org.asnlab.asndt.core.asn.ExtensionAdditionType;
import org.asnlab.asndt.core.asn.FieldSpec;
import org.asnlab.asndt.core.asn.FixedTypeValueFieldSpec;
import org.asnlab.asndt.core.asn.FixedTypeValueSetFieldSpec;
import org.asnlab.asndt.core.asn.GeneralizedTimeType;
import org.asnlab.asndt.core.asn.GraphicString;
import org.asnlab.asndt.core.asn.ImplicitType;
import org.asnlab.asndt.core.asn.InformationObject;
import org.asnlab.asndt.core.asn.IntegerRange;
import org.asnlab.asndt.core.asn.Module;
import org.asnlab.asndt.core.asn.NamedBitsValue;
import org.asnlab.asndt.core.asn.NamedNumber;
import org.asnlab.asndt.core.asn.NumericString;
import org.asnlab.asndt.core.asn.ObjectClassDefn;
import org.asnlab.asndt.core.asn.ObjectFieldSpec;
import org.asnlab.asndt.core.asn.ObjectIdentifierType;
import org.asnlab.asndt.core.asn.ObjectSet;
import org.asnlab.asndt.core.asn.ObjectSetDefn;
import org.asnlab.asndt.core.asn.ObjectSetFieldSpec;
import org.asnlab.asndt.core.asn.OctetStringType;
import org.asnlab.asndt.core.asn.PermittedAlphabet;
import org.asnlab.asndt.core.asn.PrintableString;
import org.asnlab.asndt.core.asn.RealType;
import org.asnlab.asndt.core.asn.Relationship;
import org.asnlab.asndt.core.asn.SetOfType;
import org.asnlab.asndt.core.asn.SingleType;
import org.asnlab.asndt.core.asn.SizeConstraint;
import org.asnlab.asndt.core.asn.TableConstraint;
import org.asnlab.asndt.core.asn.Type;
import org.asnlab.asndt.core.asn.TypeFieldSpec;
import org.asnlab.asndt.core.asn.TypeReference;
import org.asnlab.asndt.core.asn.UniversalString;
import org.asnlab.asndt.core.asn.ValueSet;
import org.asnlab.asndt.core.compiler.AsnCompiler;
import org.asnlab.asndt.runtime.conv.AsnConverter;
import org.asnlab.asndt.runtime.conv.CompositeConverter;
import org.asnlab.asndt.runtime.conv.LongConverter;
import org.asnlab.asndt.runtime.conv.OctetStringConverter;
import org.asnlab.asndt.runtime.crypto.BlockCipher;
import org.asnlab.asndt.runtime.crypto.BufferedBlockCipher;
import org.asnlab.asndt.runtime.crypto.CipherParameters;
import org.asnlab.asndt.runtime.crypto.engines.AESLightEngine;
import org.asnlab.asndt.runtime.crypto.params.KeyParameter;
import org.asnlab.asndt.runtime.error.AsnLicenseException;
import org.asnlab.asndt.runtime.type.Alternative;
import org.asnlab.asndt.runtime.type.AsnModule;
import org.asnlab.asndt.runtime.type.BMPString;
import org.asnlab.asndt.runtime.type.BooleanType;
import org.asnlab.asndt.runtime.type.EnumeratedType;
import org.asnlab.asndt.runtime.type.ExplicitType;
import org.asnlab.asndt.runtime.type.ExtensionAdditionGroup;
import org.asnlab.asndt.runtime.type.FieldIndexer;
import org.asnlab.asndt.runtime.type.FieldMatcher;
import org.asnlab.asndt.runtime.type.GeneralString;
import org.asnlab.asndt.runtime.type.IA5String;
import org.asnlab.asndt.runtime.type.IntegerType;
import org.asnlab.asndt.runtime.type.NullType;
import org.asnlab.asndt.runtime.type.ObjectDescriptorType;
import org.asnlab.asndt.runtime.type.ReferencedType;
import org.asnlab.asndt.runtime.type.RelativeOidType;
import org.asnlab.asndt.runtime.type.SequenceOfType;
import org.asnlab.asndt.runtime.type.SequenceType;
import org.asnlab.asndt.runtime.type.SetType;
import org.asnlab.asndt.runtime.type.TableConstraintOpenType;
import org.asnlab.asndt.runtime.type.TeletexString;
import org.asnlab.asndt.runtime.type.TypeConstraintOpenType;
import org.asnlab.asndt.runtime.type.UTCTimeType;
import org.asnlab.asndt.runtime.type.UTF8String;
import org.asnlab.asndt.runtime.type.VideotexString;
import org.asnlab.asndt.runtime.type.VisibleString;
import org.asnlab.asndt.runtime.value.BitString;
import org.asnlab.asndt.runtime.value.ChoiceValue;
import org.asnlab.asndt.runtime.value.CompositeValue;
import org.asnlab.asndt.runtime.value.NamedBits;
import org.asnlab.asndt.runtime.value.ObjectIdentifier;

public class JavaCompiler
extends AsnCompiler {
    private JavaCompilerOptions options;
    private File javaOutputFolder;
    private IdGenerator idGenerator;
    public static boolean DEBUG = false;

    public void init(Map options, File outputFolder) {
        this.options = JavaCompilerOptions.getCompilerOptions(options);
        this.javaOutputFolder = this.createFolder(outputFolder, this.options.output_folder);
        this.idGenerator = new IdGenerator();
    }

    public void clean() throws IOException {
        this.cleanFolder(this.javaOutputFolder);
    }

    public void compile(Module mainModule) throws IOException {
        this.idGenerator.reset();
        this.generateMeta(mainModule, true);
        this.generateClass(mainModule, false);
    }

    private void generateMeta(Module mainModule, boolean clean) throws IOException {
        byte[] metadata;
        String moduleName = NamingConventions.toJavaModuleName(mainModule.name);
        String packageName = NamingConventions.toPackageName(mainModule.name, this.options);
        String packagePath = packageName.replace('.', File.separatorChar);
        if (clean) {
            this.cleanFolder(this.javaOutputFolder, packagePath);
        }
        File packageFolder = this.createFolder(this.javaOutputFolder, packagePath);
        if (this.options.serial_number == null || this.options.serial_number.isEmpty()) {
            throw new AsnLicenseException("No License");
        }
        final byte[] sn = JavaCompiler.parseHexString(this.options.serial_number);
        AsnModule module = new AsnModule();
        this.compileModule(mainModule, module);
        byte[] meta = module.encode();
        byte[] prekey = new byte[]{49, 50, 52, 53, 54, 55, 57, 97, 98, 99, 33, 64, 35, 36, 37, 94};
        byte[] prepass = new byte[]{33, 64, 35, 36, 37, 94, 38};
        prekey = JavaCompiler.escape(prekey, prepass);
        BufferedBlockCipher engine = new BufferedBlockCipher((BlockCipher)new AESLightEngine());
        engine.init(false, (CipherParameters)new KeyParameter(prekey));
        byte[] dec = new byte[engine.getOutputSize(sn.length)];
        int size1 = engine.processBytes(sn, 0, sn.length, dec, 0);
        int size2 = 0;
        try {
            size2 = engine.doFinal(dec, size1);
        }
        catch (Throwable throwable) {
            throw new AsnLicenseException("Invalid license");
        }
        byte[] decryptedContent = new byte[size1 + size2];
        System.arraycopy(dec, 0, decryptedContent, 0, decryptedContent.length);
        byte[] license = decryptedContent;
        final byte[][] key = new byte[1][];
        final long[] exprire = new long[1];
        org.asnlab.asndt.runtime.type.OctetStringType octetstringType = new org.asnlab.asndt.runtime.type.OctetStringType();
        IntegerType integerType = new IntegerType();
        SequenceType licenseType = new SequenceType(new org.asnlab.asndt.runtime.type.Component[]{new org.asnlab.asndt.runtime.type.Component(null, (org.asnlab.asndt.runtime.type.AsnType)new org.asnlab.asndt.runtime.type.ImplicitType(128, (org.asnlab.asndt.runtime.type.AsnType)octetstringType)), new org.asnlab.asndt.runtime.type.Component(null, (org.asnlab.asndt.runtime.type.AsnType)new org.asnlab.asndt.runtime.type.ImplicitType(129, (org.asnlab.asndt.runtime.type.AsnType)integerType))});
        CompositeConverter licenseConverter = new CompositeConverter(new AsnConverter[]{OctetStringConverter.INSTANCE, LongConverter.INSTANCE}){

            public Object createObject() {
                return null;
            }

            public Object getComponentObject(Object object, int index) {
                if (index == 0) {
                    return key[0];
                }
                if (index == 1) {
                    return exprire[0];
                }
                return null;
            }

            public void setComponentObject(Object object, int index, Object componentObject) {
                if (index == 0) {
                    key[0] = (byte[])componentObject;
                } else if (index == 1) {
                    long time;
                    exprire[0] = time = ((Long)componentObject).longValue();
                    if (time < System.currentTimeMillis()) {
                        throw new AsnLicenseException("License expired");
                    }
                }
            }
        };
        try {
            licenseType.decode(license, (byte)0, (AsnConverter)licenseConverter);
        }
        catch (Throwable throwable) {
            throw new AsnLicenseException("Invalid license");
        }
        final byte[] encryptMeta = JavaCompiler.encrypt(key[0], meta);
        SequenceType metadataType = new SequenceType(new org.asnlab.asndt.runtime.type.Component[]{new org.asnlab.asndt.runtime.type.Component(null, (org.asnlab.asndt.runtime.type.AsnType)new org.asnlab.asndt.runtime.type.ImplicitType(128, (org.asnlab.asndt.runtime.type.AsnType)integerType)), new org.asnlab.asndt.runtime.type.Component(null, (org.asnlab.asndt.runtime.type.AsnType)new org.asnlab.asndt.runtime.type.ImplicitType(129, (org.asnlab.asndt.runtime.type.AsnType)octetstringType)), new org.asnlab.asndt.runtime.type.Component(null, (org.asnlab.asndt.runtime.type.AsnType)new org.asnlab.asndt.runtime.type.ImplicitType(130, (org.asnlab.asndt.runtime.type.AsnType)octetstringType))});
        CompositeConverter metadataConverter = new CompositeConverter(new AsnConverter[]{LongConverter.INSTANCE, OctetStringConverter.INSTANCE, OctetStringConverter.INSTANCE}){

            public Object createObject() {
                return null;
            }

            public Object getComponentObject(Object object, int index) {
                if (index == 0) {
                    return System.currentTimeMillis();
                }
                if (index == 1) {
                    return sn;
                }
                if (index == 2) {
                    return encryptMeta;
                }
                return null;
            }

            public void setComponentObject(Object object, int index, Object componentObject) {
            }
        };
        try {
            metadata = metadataType.encode(null, (byte)0, (AsnConverter)metadataConverter);
        }
        catch (Throwable throwable) {
            throw new AsnLicenseException("Invalid license");
        }
        byte[] postkey = new byte[]{35, 62, 33, 36, 33, 37, 40, 64, 94, 37, 35, 37, 42, 40, 38, 40};
        byte[] postpass = new byte[]{49, 50, 51, 52, 53, 54, 55};
        postkey = JavaCompiler.escape(postkey, postpass);
        byte[] mcontent = JavaCompiler.encrypt(postkey, metadata);
        File file = new File(packageFolder, String.valueOf(moduleName) + ".meta");
        this.writeFile(mcontent, file);
        String content = CodeGeneration.generateModule(packageName, mainModule, this.options);
        file = new File(packageFolder, String.valueOf(moduleName) + ".java");
        this.writeFile(content.getBytes(), file);
    }

    private void generateClass(Module module, boolean clean) throws IOException {
        String packageName = NamingConventions.toPackageName(module.name, this.options);
        String packagePath = packageName.replace('.', File.separatorChar);
        if (clean) {
            this.cleanFolder(this.javaOutputFolder, packagePath);
        }
        File packageFolder = this.createFolder(this.javaOutputFolder, packagePath);
        String moduleName = NamingConventions.toJavaModuleName(module.name);
        this.generatedClass(packageName, packageFolder, moduleName, module);
    }

    private void generatedClass(String packageName, File packageFolder, String moduleName, Module mainModule) throws IOException {
        this.generatedClass0(packageName, packageFolder, moduleName, mainModule);
        for (Module module : mainModule.imports.values()) {
            this.generatedClass0(packageName, packageFolder, moduleName, module);
        }
    }

    private void generatedClass0(String packageName, File packageFolder, String moduleName, Module module) throws IOException {
        for (Map.Entry entry : module.types.entrySet()) {
            String key;
            Type type = (Type)entry.getValue();
            if (type instanceof AsnType || module.classes.containsKey(key = (String)entry.getKey())) continue;
            String typeName = key;
            Integer id = this.idGenerator.getId(module.name, key);
            String content = CodeGeneration.generateClass(packageName, moduleName, typeName, id, type, this.idGenerator, this.options);
            String javaTypeName = NamingConventions.toJavaTypeName(typeName);
            File file = new File(packageFolder, String.valueOf(javaTypeName) + ".java");
            this.writeFile(content.getBytes(), file);
        }
        for (Map.Entry entry : module.classes.entrySet()) {
            String className = (String)entry.getKey();
            ObjectClassDefn objectClass = (ObjectClassDefn)entry.getValue();
            Integer id = this.idGenerator.getId(module.name, (String)entry.getKey());
            String content = CodeGeneration.generateClass(packageName, moduleName, className, id, objectClass, this.idGenerator, this.options);
            String javaTypeName = NamingConventions.toJavaTypeName(className);
            File file = new File(packageFolder, String.valueOf(javaTypeName) + ".java");
            this.writeFile(content.getBytes(), file);
        }
    }

    private void compileModule(Module mainModule, AsnModule asnModule) {
        Hashtable dejavu = new Hashtable();
        this.compileModule0(mainModule, asnModule, dejavu);
        for (Module module : mainModule.imports.values()) {
            this.compileModule0(module, asnModule, dejavu);
        }
    }

    private void compileModule0(Module module, AsnModule asnModule, Hashtable dejavu) {
        for (Map.Entry entry : module.types.entrySet()) {
            String typeName = (String)entry.getKey();
            Type type = (Type)entry.getValue();
            org.asnlab.asndt.runtime.type.AsnType compileType = this.compileType(type, null, dejavu);
            Integer typeId = this.idGenerator.getId(type.module.name, typeName);
            asnModule.addType(typeId, typeName, compileType);
            for (Map.Entry e : type.values.entrySet()) {
                String valueName = (String)e.getKey();
                Object value = e.getValue();
                Object compileValue = this.compileValue(value);
                Integer valueId = this.idGenerator.getId(type.module.name, valueName);
                asnModule.addValue(typeId, valueId, compileType, compileValue);
            }
            if (!(type instanceof DerivedType)) continue;
            Type underlyingType = ((DerivedType)type).underlyingType;
            for (Map.Entry entry2 : underlyingType.values.entrySet()) {
                String valueName = (String)entry2.getKey();
                Object value = entry2.getValue();
                Object compileValue = this.compileValue(value);
                Integer valueId = this.idGenerator.getId(underlyingType.module.name, valueName);
                asnModule.addValue(typeId, valueId, compileType, compileValue);
            }
        }
        for (Map.Entry entry : module.classes.entrySet()) {
            String className = (String)entry.getKey();
            ObjectClassDefn objectClass = (ObjectClassDefn)entry.getValue();
            Integer typeId = this.idGenerator.getId(objectClass.module.name, objectClass.name);
            Type type = objectClass.getTypeOfClass();
            org.asnlab.asndt.runtime.type.AsnType compileType = this.compileType(type, null, dejavu);
            Integer n = this.idGenerator.getId(objectClass.module.name, className);
            asnModule.addType(n, className, compileType);
            for (Map.Entry e : objectClass.objects.entrySet()) {
                String objectName = (String)e.getKey();
                InformationObject object = (InformationObject)e.getValue();
                Object compileObject = this.compileObject(object, dejavu);
                Integer objectId = this.idGenerator.getId(objectClass.module.name, objectName);
                asnModule.addObject(typeId, objectId, compileType, compileObject);
            }
            for (Map.Entry e : objectClass.objectSets.entrySet()) {
                String objectSetName = (String)e.getKey();
                ObjectSetDefn objectSet = (ObjectSetDefn)e.getValue();
                Vector compileObjectSet = this.compileObjectSet((ObjectSet)objectSet, dejavu);
                Integer objectSetId = this.idGenerator.getId(objectClass.module.name, objectSetName);
                asnModule.addObjectSet(typeId, objectSetId, compileType, compileObjectSet);
            }
        }
    }

    private org.asnlab.asndt.runtime.type.AsnType compileType(Type type, Constraint constraint, Hashtable dejavu) {
        if (type instanceof AsnType) {
            return new ReferencedType(Integer.valueOf(0), "AsnType", org.asnlab.asndt.runtime.type.AsnType.TYPE);
        }
        if (type instanceof ClassFieldFixType) {
            return this.compileType((ClassFieldFixType)type, constraint, dejavu);
        }
        if (type instanceof TypeReference) {
            return this.compileType((TypeReference)type, constraint, dejavu);
        }
        if (type instanceof ImplicitType) {
            return this.compileType((ImplicitType)type, constraint, dejavu);
        }
        if (type instanceof org.asnlab.asndt.core.asn.ExplicitType) {
            return this.compileType((org.asnlab.asndt.core.asn.ExplicitType)type, constraint, dejavu);
        }
        if (type instanceof ConstraintType) {
            return this.compileType((ConstraintType)type, constraint, dejavu);
        }
        if (type instanceof org.asnlab.asndt.core.asn.IntegerType) {
            return this.compileType((org.asnlab.asndt.core.asn.IntegerType)type, constraint, dejavu);
        }
        if (type instanceof org.asnlab.asndt.core.asn.EnumeratedType) {
            return this.compileType((org.asnlab.asndt.core.asn.EnumeratedType)type, constraint, dejavu);
        }
        if (type instanceof BitStringType) {
            return this.compileType((BitStringType)type, constraint, dejavu);
        }
        if (type instanceof OctetStringType) {
            return this.compileType((OctetStringType)type, constraint, dejavu);
        }
        if (type instanceof ChoiceType) {
            return this.compileType((ChoiceType)type, constraint, dejavu);
        }
        if (type instanceof org.asnlab.asndt.core.asn.SequenceType) {
            return this.compileType((org.asnlab.asndt.core.asn.SequenceType)type, constraint, dejavu);
        }
        if (type instanceof org.asnlab.asndt.core.asn.SetType) {
            return this.compileType((org.asnlab.asndt.core.asn.SetType)type, constraint, dejavu);
        }
        if (type instanceof org.asnlab.asndt.core.asn.SequenceOfType) {
            return this.compileType((org.asnlab.asndt.core.asn.SequenceOfType)type, constraint, dejavu);
        }
        if (type instanceof SetOfType) {
            return this.compileType((SetOfType)type, constraint, dejavu);
        }
        if (type instanceof ClassFieldOpenType) {
            return this.compileType((ClassFieldOpenType)type, constraint, dejavu);
        }
        return this.compilePrimitiveType(type, constraint);
    }

    private org.asnlab.asndt.runtime.type.AsnType compileType(ClassFieldFixType type, Constraint constraint, Hashtable dejavu) {
        constraint = constraint instanceof TableConstraint ? null : constraint;
        return this.compileType(type.acutalType, constraint, dejavu);
    }

    private org.asnlab.asndt.runtime.type.AsnType compileType(TypeReference type, Constraint constraint, Hashtable dejavu) {
        if (constraint != null) {
            return this.compileType(type.underlyingType, constraint, dejavu);
        }
        org.asnlab.asndt.runtime.type.AsnType deja = (org.asnlab.asndt.runtime.type.AsnType)dejavu.get(type);
        if (deja != null) {
            return deja;
        }
        ReferencedType referencedType = new ReferencedType(Integer.valueOf(this.idGenerator.getId(type.underlyingType.module.name, type.name)), type.name);
        dejavu.put(type, referencedType);
        referencedType.underlyingType = this.compileType(type.underlyingType, null, dejavu);
        return referencedType;
    }

    private org.asnlab.asndt.runtime.type.AsnType compileType(ImplicitType type, Constraint constraint, Hashtable dejavu) {
        org.asnlab.asndt.runtime.type.AsnType underlyingType = this.compileType(type.underlyingType, constraint, dejavu);
        int tag = org.asnlab.asndt.runtime.type.AsnType.encodeTag((short)type.tag.tagClass, (short)type.tag.tagForm, (int)type.tag.tagNumber);
        org.asnlab.asndt.runtime.type.ImplicitType implicitType = new org.asnlab.asndt.runtime.type.ImplicitType(tag, underlyingType);
        return implicitType;
    }

    private org.asnlab.asndt.runtime.type.AsnType compileType(org.asnlab.asndt.core.asn.ExplicitType type, Constraint constraint, Hashtable dejavu) {
        org.asnlab.asndt.runtime.type.AsnType underlyingType = this.compileType(type.underlyingType, constraint, dejavu);
        int tag = org.asnlab.asndt.runtime.type.AsnType.encodeTag((short)type.tag.tagClass, (short)type.tag.tagForm, (int)type.tag.tagNumber);
        ExplicitType explicitType = new ExplicitType(tag, underlyingType);
        return explicitType;
    }

    private org.asnlab.asndt.runtime.type.AsnType compileType(ConstraintType type, Constraint constraint, Hashtable dejavu) {
        constraint = Constraint.safeSerial((Constraint)type.constraint, (Constraint)constraint);
        return this.compileType(type.underlyingType, constraint, dejavu);
    }

    private org.asnlab.asndt.runtime.type.AsnType compileType(org.asnlab.asndt.core.asn.IntegerType type, Constraint constraint, Hashtable dejavu) {
        ValueSet valueSet = constraint instanceof ValueSet ? (ValueSet)constraint : null;
        IntegerRange integerRange = valueSet == null ? null : valueSet.reduceEffectiveIntegerRange();
        IntegerType integerType = new IntegerType();
        if (integerRange != null) {
            if (integerRange.lowerBound != null) {
                integerType.setBmin(integerRange.lowerBound);
            }
            if (integerRange.upperBound != null) {
                integerType.setBmax(integerRange.upperBound);
            }
            integerType.setExtensible(valueSet.extensible);
        }
        return integerType;
    }

    private org.asnlab.asndt.runtime.type.AsnType compileType(org.asnlab.asndt.core.asn.EnumeratedType type, Constraint constraint, Hashtable dejavu) {
        EnumeratedType enumeratedType = new EnumeratedType();
        enumeratedType.setRootEnumeration(this.compileNamedNumbrs(type.rootEnumeration));
        enumeratedType.setExtensible(type.extensible);
        enumeratedType.setExtensionEnumeration(this.compileNamedNumbrs(type.additionalEnumeration));
        return enumeratedType;
    }

    private org.asnlab.asndt.runtime.type.NamedNumber[] compileNamedNumbrs(NamedNumber[] namedNumbers) {
        org.asnlab.asndt.runtime.type.NamedNumber[] enumeration = new org.asnlab.asndt.runtime.type.NamedNumber[namedNumbers.length];
        int i = 0;
        while (i < enumeration.length) {
            enumeration[i] = new org.asnlab.asndt.runtime.type.NamedNumber(namedNumbers[i].name, Integer.valueOf(namedNumbers[i].number.intValue()));
            ++i;
        }
        return enumeration;
    }

    private org.asnlab.asndt.runtime.type.AsnType compileType(BitStringType type, Constraint constraint, Hashtable dejavu) {
        ValueSet valueSet = constraint instanceof ValueSet ? (ValueSet)constraint : null;
        SizeConstraint sizeConstraint = valueSet == null ? null : valueSet.reduceEffectiveSizeConstraint();
        org.asnlab.asndt.runtime.type.BitStringType bitStringType = new org.asnlab.asndt.runtime.type.BitStringType();
        if (sizeConstraint != null) {
            if (sizeConstraint.lowerBound != null) {
                bitStringType.setLmin(new Integer(sizeConstraint.lowerBound.intValue()));
            }
            if (sizeConstraint.upperBound != null) {
                bitStringType.setLmax(new Integer(sizeConstraint.upperBound.intValue()));
            }
            bitStringType.setExtensible(sizeConstraint.extensible);
        }
        bitStringType.setNamedBits(this.compileNamedNumbrs(type.namedBits));
        return bitStringType;
    }

    private org.asnlab.asndt.runtime.type.AsnType compileType(OctetStringType type, Constraint constraint, Hashtable dejavu) {
        ValueSet valueSet = constraint instanceof ValueSet ? (ValueSet)constraint : null;
        SizeConstraint sizeConstraint = valueSet == null ? null : valueSet.reduceEffectiveSizeConstraint();
        org.asnlab.asndt.runtime.type.OctetStringType octetStringType = new org.asnlab.asndt.runtime.type.OctetStringType();
        if (sizeConstraint != null) {
            if (sizeConstraint.lowerBound != null) {
                octetStringType.setLmin(new Integer(sizeConstraint.lowerBound.intValue()));
            }
            if (sizeConstraint.upperBound != null) {
                octetStringType.setLmax(new Integer(sizeConstraint.upperBound.intValue()));
            }
            octetStringType.setExtensible(sizeConstraint.extensible);
        }
        return octetStringType;
    }

    private org.asnlab.asndt.runtime.type.AsnType compileType(ChoiceType type, Constraint constraint, Hashtable dejavu) {
        org.asnlab.asndt.runtime.type.AsnType deja = (org.asnlab.asndt.runtime.type.AsnType)dejavu.get(type);
        if (deja != null) {
            return deja;
        }
        org.asnlab.asndt.runtime.type.ChoiceType choiceType = new org.asnlab.asndt.runtime.type.ChoiceType();
        dejavu.put(type, choiceType);
        choiceType.setRootAlternatives(this.compileAlternatives(type.rootAlternatives, dejavu));
        choiceType.setExtensible(type.extensible);
        choiceType.setExtensionAlternatives(this.compileAlternatives(type.extensionAlternatives, dejavu));
        return choiceType;
    }

    private Alternative[] compileAlternatives(org.asnlab.asndt.core.asn.Alternative[] alternatives, Hashtable dejavu) {
        Alternative[] alternativeMetas = new Alternative[alternatives.length];
        int i = 0;
        while (i < alternativeMetas.length) {
            alternativeMetas[i] = this.compileAlternative(alternatives[i], dejavu);
            ++i;
        }
        return alternativeMetas;
    }

    private Alternative compileAlternative(org.asnlab.asndt.core.asn.Alternative alternative, Hashtable dejavu) {
        Alternative alternativeMeta = new Alternative();
        alternativeMeta.name = alternative.name;
        alternativeMeta.type = this.compileType(alternative.type, null, dejavu);
        return alternativeMeta;
    }

    private org.asnlab.asndt.runtime.type.AsnType compileType(org.asnlab.asndt.core.asn.SequenceType type, Constraint constraint, Hashtable dejavu) {
        org.asnlab.asndt.runtime.type.AsnType deja = (org.asnlab.asndt.runtime.type.AsnType)dejavu.get(type);
        if (deja != null) {
            return deja;
        }
        SequenceType sequenceType = new SequenceType();
        dejavu.put(type, sequenceType);
        org.asnlab.asndt.runtime.type.Component[] rootComponents = new org.asnlab.asndt.runtime.type.Component[type.rootComponents.length];
        int i = 0;
        while (i < rootComponents.length) {
            rootComponents[i] = this.compileComponent(type.rootComponents[i], dejavu);
            ++i;
        }
        sequenceType.setRootComponents(rootComponents);
        sequenceType.setExtensible(type.extensible);
        org.asnlab.asndt.runtime.type.ExtensionAddition[] extensionAdditions = new org.asnlab.asndt.runtime.type.ExtensionAddition[type.extensionAdditions.length];
        int i2 = 0;
        while (i2 < extensionAdditions.length) {
            extensionAdditions[i2] = this.compileExtensionAdditions(type.extensionAdditions[i2], dejavu);
            ++i2;
        }
        sequenceType.setExtensionAdditions(extensionAdditions);
        return sequenceType;
    }

    private org.asnlab.asndt.runtime.type.Component compileComponent(Component component, Hashtable dejavu) {
        org.asnlab.asndt.runtime.type.Component componentMeta = new org.asnlab.asndt.runtime.type.Component();
        componentMeta.setName(component.name);
        org.asnlab.asndt.runtime.type.AsnType type = this.compileType(component.type, null, dejavu);
        componentMeta.setType(type);
        componentMeta.setOptional(component.optional);
        componentMeta.setDefval(this.compileValue(component.defaultValue));
        return componentMeta;
    }

    private org.asnlab.asndt.runtime.type.ExtensionAddition compileExtensionAdditions(ExtensionAddition addition, Hashtable dejavu) {
        if (addition instanceof ExtensionAdditionType) {
            return this.compileExtensionAdditionType((ExtensionAdditionType)addition, dejavu);
        }
        if (addition instanceof org.asnlab.asndt.core.asn.ExtensionAdditionGroup) {
            return this.compileExtensionAdditionGroup((org.asnlab.asndt.core.asn.ExtensionAdditionGroup)addition, dejavu);
        }
        return null;
    }

    private org.asnlab.asndt.runtime.type.ExtensionAdditionType compileExtensionAdditionType(ExtensionAdditionType additionType, Hashtable dejavu) {
        org.asnlab.asndt.runtime.type.ExtensionAdditionType extensionAdditionType = new org.asnlab.asndt.runtime.type.ExtensionAdditionType();
        extensionAdditionType.setIndex(additionType.index);
        extensionAdditionType.setName(additionType.name);
        extensionAdditionType.setType(this.compileType(additionType.type, null, dejavu));
        extensionAdditionType.setOptional(additionType.optional);
        extensionAdditionType.setDefval(this.compileValue(additionType.defaultValue));
        return extensionAdditionType;
    }

    private ExtensionAdditionGroup compileExtensionAdditionGroup(org.asnlab.asndt.core.asn.ExtensionAdditionGroup group, Hashtable dejavu) {
        ExtensionAdditionGroup extensionAdditionGroup = new ExtensionAdditionGroup();
        org.asnlab.asndt.runtime.type.ExtensionAdditionType[] extensionAdditionTypes = new org.asnlab.asndt.runtime.type.ExtensionAdditionType[group.extensionAdditionTypes.length];
        int i = 0;
        while (i < extensionAdditionTypes.length) {
            extensionAdditionTypes[i] = this.compileExtensionAdditionType(group.extensionAdditionTypes[i], dejavu);
            ++i;
        }
        extensionAdditionGroup.setExtensionAdditionTypes(extensionAdditionTypes);
        return extensionAdditionGroup;
    }

    private org.asnlab.asndt.runtime.type.AsnType compileType(org.asnlab.asndt.core.asn.SetType type, Constraint constraint, Hashtable dejavu) {
        org.asnlab.asndt.runtime.type.AsnType deja = (org.asnlab.asndt.runtime.type.AsnType)dejavu.get(type);
        if (deja != null) {
            return deja;
        }
        SetType setType = new SetType();
        dejavu.put(type, setType);
        org.asnlab.asndt.runtime.type.Component[] rootComponents = new org.asnlab.asndt.runtime.type.Component[type.rootComponents.length];
        int i = 0;
        while (i < rootComponents.length) {
            rootComponents[i] = this.compileComponent(type.rootComponents[i], dejavu);
            ++i;
        }
        setType.setRootComponents(rootComponents);
        setType.setExtensible(type.extensible);
        org.asnlab.asndt.runtime.type.ExtensionAddition[] extensionAdditions = new org.asnlab.asndt.runtime.type.ExtensionAddition[type.extensionAdditions.length];
        int i2 = 0;
        while (i2 < extensionAdditions.length) {
            extensionAdditions[i2] = this.compileExtensionAdditions(type.extensionAdditions[i2], dejavu);
            ++i2;
        }
        setType.setExtensionAdditions(extensionAdditions);
        return setType;
    }

    private org.asnlab.asndt.runtime.type.AsnType compileType(org.asnlab.asndt.core.asn.SequenceOfType type, Constraint constraint, Hashtable dejavu) {
        ValueSet valueSet = constraint instanceof ValueSet ? (ValueSet)constraint : null;
        SizeConstraint sizeConstraint = valueSet == null ? null : valueSet.reduceEffectiveSizeConstraint();
        org.asnlab.asndt.runtime.type.AsnType componentType = this.compileType(type.componentType, null, dejavu);
        SequenceOfType sequenceOfType = new SequenceOfType(componentType);
        sequenceOfType.setComponentName(type.componentName);
        if (sizeConstraint != null) {
            if (sizeConstraint.lowerBound != null) {
                sequenceOfType.setLmin(new Integer(sizeConstraint.lowerBound.intValue()));
            }
            if (sizeConstraint.upperBound != null) {
                sequenceOfType.setLmax(new Integer(sizeConstraint.upperBound.intValue()));
            }
            sequenceOfType.setExtensible(sizeConstraint.extensible);
        }
        return sequenceOfType;
    }

    private org.asnlab.asndt.runtime.type.AsnType compileType(SetOfType type, Constraint constraint, Hashtable dejavu) {
        ValueSet valueSet = constraint instanceof ValueSet ? (ValueSet)constraint : null;
        SizeConstraint sizeConstraint = valueSet == null ? null : valueSet.reduceEffectiveSizeConstraint();
        org.asnlab.asndt.runtime.type.AsnType componentType = this.compileType(type.componentType, null, dejavu);
        org.asnlab.asndt.runtime.type.SetOfType setOfType = new org.asnlab.asndt.runtime.type.SetOfType(componentType);
        setOfType.setComponentName(type.componentName);
        if (sizeConstraint != null) {
            if (sizeConstraint.lowerBound != null) {
                setOfType.setLmin(new Integer(sizeConstraint.lowerBound.intValue()));
            }
            if (sizeConstraint.upperBound != null) {
                setOfType.setLmax(new Integer(sizeConstraint.upperBound.intValue()));
            }
            setOfType.setExtensible(sizeConstraint.extensible);
        }
        return setOfType;
    }

    private org.asnlab.asndt.runtime.type.AsnType compileType(ClassFieldOpenType type, Constraint constraint, Hashtable dejavu) {
        if (constraint instanceof TableConstraint) {
            TableConstraint tableConstraint = (TableConstraint)constraint;
            TableConstraintOpenType openType = new TableConstraintOpenType();
            Type typeOfClass = type.objectClass.getTypeOfClass();
            org.asnlab.asndt.runtime.type.AsnType compileType = this.compileType(typeOfClass, null, dejavu);
            openType.setObjectType(compileType);
            openType.setIndexers(this.compileIndexers(type, tableConstraint.relationships));
            return openType;
        }
        if (constraint instanceof ValueSet) {
            ValueSet valueSet = (ValueSet)constraint;
            if (valueSet.rootElementSet instanceof SingleType) {
                SingleType sinleType = (SingleType)valueSet.rootElementSet;
                org.asnlab.asndt.runtime.type.AsnType asnType = this.compileType(sinleType.type, null, dejavu);
                TypeConstraintOpenType openType = new TypeConstraintOpenType();
                openType.setActualType(asnType);
                return openType;
            }
        } else if (constraint == null) {
            TableConstraintOpenType openType = new TableConstraintOpenType();
            Type typeOfClass = type.objectClass.getTypeOfClass();
            org.asnlab.asndt.runtime.type.AsnType compileType = this.compileType(typeOfClass, null, dejavu);
            openType.setObjectType(compileType);
            openType.setIndexers(this.compileIndexers(type, new Relationship[0]));
            return openType;
        }
        System.out.println("[JavaCompiler] Unknown constraint: " + constraint);
        return null;
    }

    private FieldIndexer[] compileIndexers(ClassFieldOpenType type, Relationship[] relationships) {
        FieldIndexer[] indexers = new FieldIndexer[type.compoundFieldNames.length];
        ObjectClassDefn objectClass = type.objectClass.resolve();
        int i = 0;
        while (i < indexers.length) {
            FieldIndexer indexer = new FieldIndexer();
            String compoundFieldName = type.compoundFieldNames[i];
            int fieldIndex = objectClass.getFieldIndex(compoundFieldName);
            indexer.setFieldIndex(fieldIndex);
            indexer.setFieldMatchers(this.compileFieldMatchers(i + 1, objectClass, relationships));
            indexers[i] = indexer;
            FieldSpec fieldSpec = objectClass.getFieldSpec(fieldIndex);
            if (fieldSpec instanceof ObjectFieldSpec) {
                ObjectFieldSpec objectFieldSpec = (ObjectFieldSpec)fieldSpec;
                objectClass = objectFieldSpec.objectClass.resolve();
            } else if (fieldSpec instanceof ObjectSetFieldSpec) {
                ObjectSetFieldSpec objectSetFieldSpec = (ObjectSetFieldSpec)fieldSpec;
                objectClass = objectSetFieldSpec.objectClass.resolve();
            } else if (i != indexers.length - 1 && DEBUG) {
                System.err.println("[JavaCompiler.compileIndexers] unknown fieldSpec: " + fieldSpec.getClass().getSimpleName());
            }
            ++i;
        }
        return indexers;
    }

    private FieldMatcher[] compileFieldMatchers(int level, ObjectClassDefn objectClass, Relationship[] relationships) {
        ArrayList<FieldMatcher> list = new ArrayList<FieldMatcher>(relationships.length);
        int i = 0;
        while (i < relationships.length) {
            Relationship relationship = relationships[i];
            if (relationship.compoundFieldNames.length == level) {
                FieldMatcher matcher = new FieldMatcher();
                matcher.setCompomentIndex(relationship.componentIndex);
                matcher.setCompomentLevel(relationship.relativedCompomentLevel);
                String compoundFieldName = relationship.compoundFieldNames[level - 1];
                matcher.setFieldIndex(objectClass.getFieldIndex(compoundFieldName));
                list.add(matcher);
            }
            ++i;
        }
        return list.toArray(new FieldMatcher[list.size()]);
    }

    private Vector compileObjectSet(ObjectSet objectSet, Hashtable dejavu) {
        ObjectSetDefn objectSetDefn = objectSet.resolve();
        Vector<Object> objects = new Vector<Object>(objectSetDefn.objects.size());
        int i = 0;
        while (i < objectSetDefn.objects.size()) {
            Object object = this.compileObject((InformationObject)objectSetDefn.objects.get(i), dejavu);
            objects.add(object);
            ++i;
        }
        return objects;
    }

    private Object compileObject(InformationObject object, Hashtable dejavu) {
        CompositeValue compositeValue = new CompositeValue(object.fields.length);
        ObjectClassDefn objectClassDefn = object.objectClass;
        FieldSpec[] fieldSpecs = objectClassDefn.fields;
        int i = 0;
        while (i < fieldSpecs.length) {
            Object field = this.compileField(fieldSpecs[i], object.fields[i], dejavu);
            compositeValue.set(i, field);
            ++i;
        }
        return compositeValue;
    }

    private Object compileField(FieldSpec fieldSpec, Object field, Hashtable dejavu) {
        if (field == null) {
            return null;
        }
        if (fieldSpec instanceof ObjectFieldSpec) {
            InformationObject fieldObject = (InformationObject)field;
            return this.compileObject(fieldObject, dejavu);
        }
        if (fieldSpec instanceof ObjectSetFieldSpec) {
            ObjectSet fieldObjectSet = (ObjectSet)field;
            return this.compileObjectSet(fieldObjectSet, dejavu);
        }
        if (fieldSpec instanceof TypeFieldSpec) {
            Type type = (Type)field;
            return this.compileType(type, null, dejavu);
        }
        if (fieldSpec instanceof FixedTypeValueFieldSpec) {
            return this.compileValue(field);
        }
        if (fieldSpec instanceof FixedTypeValueSetFieldSpec) {
            FixedTypeValueSetFieldSpec cfr_ignored_0 = (FixedTypeValueSetFieldSpec)fieldSpec;
            ValueSet cfr_ignored_1 = (ValueSet)field;
            return null;
        }
        return null;
    }

    private Object compileValue(Object value) {
        if (value instanceof BitStringValue) {
            BitStringValue bitStringValue = (BitStringValue)value;
            return new BitString(bitStringValue.bytes, bitStringValue.unusedBits);
        }
        if (value instanceof NamedBitsValue) {
            NamedBitsValue namedBitsvalue = (NamedBitsValue)value;
            return new NamedBits(namedBitsvalue.namedBits);
        }
        if (value instanceof org.asnlab.asndt.core.asn.ChoiceValue) {
            org.asnlab.asndt.core.asn.ChoiceValue choiceValue = (org.asnlab.asndt.core.asn.ChoiceValue)value;
            return new ChoiceValue(choiceValue.index, this.compileValue(choiceValue.value));
        }
        if (value instanceof org.asnlab.asndt.core.asn.CompositeValue) {
            org.asnlab.asndt.core.asn.CompositeValue compositeValue = (org.asnlab.asndt.core.asn.CompositeValue)value;
            CompositeValue compositeValue2 = new CompositeValue(compositeValue.values.length);
            int i = 0;
            while (i < compositeValue.values.length) {
                compositeValue2.set(i, this.compileValue(compositeValue.get(i)));
                ++i;
            }
            return compositeValue2;
        }
        if (value instanceof Vector) {
            Vector vector = (Vector)value;
            Vector<Object> list = new Vector<Object>(vector.size());
            int i = 0;
            while (i < vector.size()) {
                list.add(this.compileValue(vector.elementAt(i)));
                ++i;
            }
            return list;
        }
        if (value instanceof int[]) {
            return new ObjectIdentifier((int[])value);
        }
        return value;
    }

    private org.asnlab.asndt.runtime.type.AsnType compilePrimitiveType(Type type, Constraint constraint) {
        PermittedAlphabet permittedAlphabet;
        org.asnlab.asndt.runtime.type.NumericString knownMultiplierString;
        if (type instanceof org.asnlab.asndt.core.asn.BooleanType) {
            return new BooleanType();
        }
        if (type instanceof org.asnlab.asndt.core.asn.NullType) {
            return new NullType();
        }
        if (type instanceof RealType) {
            return new org.asnlab.asndt.runtime.type.RealType();
        }
        if (type instanceof ObjectIdentifierType) {
            return new org.asnlab.asndt.runtime.type.ObjectIdentifierType();
        }
        if (type instanceof org.asnlab.asndt.core.asn.RelativeOidType) {
            return new RelativeOidType();
        }
        if (type instanceof org.asnlab.asndt.core.asn.TeletexString) {
            return new TeletexString();
        }
        if (type instanceof org.asnlab.asndt.core.asn.VideotexString) {
            return new VideotexString();
        }
        if (type instanceof GraphicString) {
            return new org.asnlab.asndt.runtime.type.GraphicString();
        }
        if (type instanceof org.asnlab.asndt.core.asn.GeneralString) {
            return new GeneralString();
        }
        if (type instanceof org.asnlab.asndt.core.asn.UTF8String) {
            return new UTF8String();
        }
        if (type instanceof CharacterString) {
            return new org.asnlab.asndt.runtime.type.CharacterString();
        }
        if (type instanceof org.asnlab.asndt.core.asn.ObjectDescriptorType) {
            return new ObjectDescriptorType();
        }
        if (type instanceof GeneralizedTimeType) {
            return new org.asnlab.asndt.runtime.type.GeneralizedTimeType();
        }
        if (type instanceof org.asnlab.asndt.core.asn.UTCTimeType) {
            return new UTCTimeType();
        }
        if (type instanceof NumericString) {
            knownMultiplierString = new org.asnlab.asndt.runtime.type.NumericString();
        } else if (type instanceof PrintableString) {
            knownMultiplierString = new org.asnlab.asndt.runtime.type.PrintableString();
        } else if (type instanceof org.asnlab.asndt.core.asn.IA5String) {
            knownMultiplierString = new IA5String();
        } else if (type instanceof org.asnlab.asndt.core.asn.VisibleString) {
            knownMultiplierString = new VisibleString();
        } else if (type instanceof UniversalString) {
            knownMultiplierString = new org.asnlab.asndt.runtime.type.UniversalString();
        } else if (type instanceof org.asnlab.asndt.core.asn.BMPString) {
            knownMultiplierString = new BMPString();
        } else {
            System.err.println("[JavaCompiler] unkown primitive type: " + type);
            return null;
        }
        ValueSet valueSet = constraint instanceof ValueSet ? (ValueSet)constraint : null;
        SizeConstraint sizeConstraint = valueSet == null ? null : valueSet.reduceEffectiveSizeConstraint();
        PermittedAlphabet permittedAlphabet2 = permittedAlphabet = valueSet == null ? null : valueSet.reduceEffectivePermittedAlphabet();
        if (sizeConstraint != null) {
            if (sizeConstraint.lowerBound != null) {
                knownMultiplierString.setLmin(new Integer(sizeConstraint.lowerBound.intValue()));
            }
            if (sizeConstraint.upperBound != null) {
                knownMultiplierString.setLmax(new Integer(sizeConstraint.upperBound.intValue()));
            }
            knownMultiplierString.setExtensible(sizeConstraint.extensible);
        }
        if (permittedAlphabet != null) {
            List list = permittedAlphabet.permittedCharacters;
            int[] permittedAlphabets = new int[list.size()];
            int i = 0;
            while (i < list.size()) {
                permittedAlphabets[i] = (Integer)list.get(i);
                ++i;
            }
            Arrays.sort(permittedAlphabets);
            knownMultiplierString.setPermittedAlphabets(permittedAlphabets);
        }
        return knownMultiplierString;
    }

    private static byte[] encrypt(byte[] key, byte[] b) {
        try {
            int length = b.length;
            int remain = length % 16;
            if (remain != 0) {
                byte[] byArray = b;
                b = new byte[length + 16 - remain];
                System.arraycopy(byArray, 0, b, 0, length);
            }
            BufferedBlockCipher engine = new BufferedBlockCipher((BlockCipher)new AESLightEngine());
            engine.init(true, (CipherParameters)new KeyParameter(key));
            byte[] enc = new byte[engine.getOutputSize(b.length)];
            int size1 = engine.processBytes(b, 0, b.length, enc, 0);
            int size2 = engine.doFinal(enc, size1);
            byte[] encryptedContent = new byte[size1 + size2];
            System.arraycopy(enc, 0, encryptedContent, 0, encryptedContent.length);
            return encryptedContent;
        }
        catch (Throwable throwable) {
            throw new AsnLicenseException("Invalid license");
        }
    }

    private static byte[] escape(byte[] in, byte[] password) {
        return JavaCompiler.escape(in, 0, in.length, password);
    }

    private static byte[] escape(byte[] in, int offset, int length, byte[] password) {
        byte[] out = new byte[length];
        int i = 0;
        while (i < length) {
            out[i] = (byte)(password[i % password.length] ^ in[offset + i]);
            int n = i % password.length;
            password[n] = (byte)(password[n] ^ password[(i + 1) % password.length]);
            ++i;
        }
        return out;
    }

    private static byte[] parseHexString(String hex) {
        if (hex.length() % 2 != 0) {
            throw new AsnLicenseException();
        }
        byte[] octets = new byte[hex.length() / 2];
        int i = 0;
        while (i < octets.length) {
            octets[i] = (byte)Integer.parseInt(hex.substring(i * 2, i * 2 + 2), 16);
            ++i;
        }
        return octets;
    }
}

