/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.asnjc;

import java.util.HashSet;
import org.asnlab.asndt.asnjc.JavaCompilerOptions;

class NamingConventions {
    private static HashSet<String> javakeywords;
    private static HashSet<String> javatypes;

    static {
        String[] types;
        String[] keywords;
        javakeywords = new HashSet();
        javatypes = new HashSet();
        String[] stringArray = keywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while", "const", "goto"};
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            javakeywords.add(keyword);
            ++n2;
        }
        String[] stringArray2 = types = new String[]{"Boolean", "Byte", "Short", "Integer", "Long", "Float", "Double", "String", "Object", "Date", "Vector", "InputStream", "OutputStream", "IOException", "AsnConverter", "BitStringConverter", "BooleanConverter", "ByteConverter", "CharStringConverter", "ChoiceConverter", "DoubleConverter", "EnumeratedConverter", "FloatConverter", "GeneralizedTimeConverter", "IntegerConverter", "LongConverter", "NullConverter", "ObjectDescriptorConverter", "ObjectIdentifierConverter", "OctetStringConverter", "RelativeOidConverter", "SequenceConverter", "SequenceOfConverter", "SetConverter", "SetOfConverter", "ShortConverter", "UTCTimeConverter", "EncodingRules", "ObjectUtils"};
        int n3 = types.length;
        n = 0;
        while (n < n3) {
            String type = stringArray2[n];
            javatypes.add(type);
            ++n;
        }
    }

    NamingConventions() {
    }

    static String toPackageName(String module, JavaCompilerOptions options) {
        String packageName = NamingConventions.toJavaModuleName(module);
        if (options.using_package_prefix_to_be_prepended_to_each_package_name && options.package_prefix_to_be_prepended_to_each_package_name != null) {
            if (options.package_prefix_to_be_prepended_to_each_package_name.endsWith(".")) {
                packageName = String.valueOf(options.package_prefix_to_be_prepended_to_each_package_name) + packageName;
            } else if (options.package_prefix_to_be_prepended_to_each_package_name.length() > 0) {
                packageName = String.valueOf(options.package_prefix_to_be_prepended_to_each_package_name) + "." + packageName;
            }
        }
        if (options.using_lower_case_package_name) {
            packageName = packageName.toLowerCase();
        }
        return packageName;
    }

    static String toJavaModuleName(String moduleName) {
        String packageName = moduleName.replaceAll("-", "_");
        return NamingConventions.escapeJavaType(packageName);
    }

    static String classFieldName2JavaFieldName(String classFieldName) {
        classFieldName = classFieldName.replaceAll("&", "");
        classFieldName = classFieldName.replaceAll("-", "_");
        return NamingConventions.escapeJavakeyword(NamingConventions.escapeJavakeyword(classFieldName));
    }

    static String toJavaTypeName(String typeName) {
        typeName = typeName.replaceAll("-", "_");
        typeName = typeName.replaceAll("&", "");
        return NamingConventions.escapeJavaType(typeName);
    }

    static String toJavaFieldName(String componentName) {
        String javaFieldName = componentName.replaceAll("-", "_");
        javaFieldName = javaFieldName.replaceAll("&", "");
        return NamingConventions.escapeJavakeyword(javaFieldName);
    }

    static String toJavaName(String name) {
        name = name.replaceAll("-", "_");
        return NamingConventions.escapeJavaType(NamingConventions.escapeJavakeyword(name));
    }

    static String toJavaFieldNameForType(String typeName) {
        typeName = typeName.replaceAll("-", "_");
        typeName = String.valueOf(typeName.substring(0, 1).toLowerCase()) + typeName.substring(1);
        return NamingConventions.escapeJavakeyword(typeName);
    }

    static String toSetterGetterName(String fieldName) {
        fieldName = fieldName.replaceAll("-", "_");
        return NamingConventions.capitalizeInitial(fieldName);
    }

    private static String capitalizeInitial(String name) {
        String camelCase = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        return camelCase;
    }

    private static String escapeJavaType(String typeName) {
        if (javatypes.contains(typeName)) {
            return String.valueOf(typeName) + "_";
        }
        return typeName;
    }

    private static String escapeJavakeyword(String fieldName) {
        if (javakeywords.contains(fieldName)) {
            return String.valueOf(fieldName) + "_";
        }
        return fieldName;
    }
}

