/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.core;

import java.util.Enumeration;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.BufferChangedEvent;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IBuffer;
import org.asnlab.asndt.core.IBufferChangedListener;
import org.asnlab.asndt.core.IOpenable;
import org.asnlab.asndt.internal.core.AsnElement;
import org.asnlab.asndt.internal.core.AsnModel;
import org.asnlab.asndt.internal.core.AsnModelManager;
import org.asnlab.asndt.internal.core.AsnModelStatus;
import org.asnlab.asndt.internal.core.BufferManager;
import org.asnlab.asndt.internal.core.util.Util;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class Openable
extends AsnElement
implements IOpenable,
IBufferChangedListener {
    @Override
    public String findRecommendedLineSeparator() throws AsnModelException {
        Openable a;
        IBuffer iBuffer = a.getBuffer();
        String string = iBuffer == null ? null : iBuffer.getContents();
        return Util.getLineSeparator(string, a.getAsnProject());
    }

    @Override
    public IBuffer getBuffer() throws AsnModelException {
        Openable a;
        if (a.hasBuffer()) {
            Openable openable = a;
            openable.open(null);
            IBuffer iBuffer = openable.getBufferManager().getBuffer(a);
            if (iBuffer == null) {
                iBuffer = a.openBuffer(null);
            }
            return iBuffer;
        }
        return null;
    }

    @Override
    public void save(IProgressMonitor a, boolean a2) throws AsnModelException {
        Openable a3;
        if (a3.isReadOnly()) {
            throw new AsnModelException(new AsnModelStatus(976, a3));
        }
        IBuffer iBuffer = a3.getBuffer();
        if (iBuffer != null) {
            IProgressMonitor iProgressMonitor = a;
            iBuffer.save(iProgressMonitor, a2);
            a3.makeConsistent(iProgressMonitor);
        }
    }

    protected void closeBuffer() {
        Openable a;
        if (!a.hasBuffer()) {
            return;
        }
        IBuffer iBuffer = a.getBufferManager().getBuffer(a);
        if (iBuffer != null) {
            IBuffer iBuffer2 = iBuffer;
            iBuffer2.close();
            iBuffer2.removeBufferChangedListener(a);
        }
    }

    @Override
    public IResource getCorrespondingResource() throws AsnModelException {
        Openable a;
        return a.getUnderlyingResource();
    }

    protected BufferManager getBufferManager() {
        return BufferManager.getDefaultBufferManager();
    }

    @Override
    public IResource getUnderlyingResource() throws AsnModelException {
        Openable a;
        IResource iResource = a.f.getUnderlyingResource();
        if (iResource == null) {
            return null;
        }
        int n = iResource.getType();
        if (n == 2 || n == 4) {
            IResource iResource2 = ((IContainer)iResource).findMember(a.getElementName());
            if (iResource2 == null) {
                throw a.newNotPresentException();
            }
            return iResource2;
        }
        return iResource;
    }

    protected Openable(IAsnElement a) {
        super(a);
        Openable a2;
    }

    protected IBuffer openBuffer(IProgressMonitor a) throws AsnModelException {
        return null;
    }

    protected boolean hasBuffer() {
        return false;
    }

    @Override
    public boolean isOpen() {
        Openable a;
        return a.A;
    }

    @Override
    public void makeConsistent(IProgressMonitor a) throws AsnModelException {
    }

    protected boolean resourceExists() {
        Openable a;
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        if (iWorkspace == null) {
            return false;
        }
        return AsnModel.getTarget((IContainer)iWorkspace.getRoot(), a.getPath().makeRelative(), true) != null;
    }

    @Override
    public boolean hasUnsavedChanges() throws AsnModelException {
        Openable a;
        if (a.isReadOnly() || !a.isOpen()) {
            return false;
        }
        IBuffer iBuffer = a.getBuffer();
        if (iBuffer != null && iBuffer.hasUnsavedChanges()) {
            return true;
        }
        int n = a.getElementType();
        if (n == 4 || n == 2 || n == 1) {
            Enumeration enumeration;
            Enumeration enumeration2 = enumeration = a.getBufferManager().getOpenBuffers();
            while (enumeration2.hasMoreElements()) {
                Object object = (IBuffer)enumeration.nextElement();
                if (object.hasUnsavedChanges() && a.isAncestorOf((IAsnElement)(object = (IAsnElement)((Object)object.getOwner())))) {
                    return true;
                }
                enumeration2 = enumeration;
            }
        }
        return false;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    @Override
    public boolean exists() {
        Openable a;
        if (a.isOpen()) {
            return true;
        }
        if (!a.parentExists()) {
            return false;
        }
        return super.exists();
    }

    @Override
    public void open(IProgressMonitor a) throws AsnModelException {
        Openable a2;
        if (a2.isOpen()) {
            return;
        }
        a2.openWhenClosed(a);
    }

    @Override
    protected void closing() {
        Openable a;
        a.closeBuffer();
    }

    @Override
    public void bufferChanged(BufferChangedEvent a) {
        Openable a2;
        if (a.getBuffer().isClosed()) {
            AsnModelManager.getAsnModelManager().getElementsOutOfSynchWithBuffers().remove(a2);
            a2.getBufferManager().removeBuffer(a.getBuffer());
            return;
        }
        AsnModelManager.getAsnModelManager().getElementsOutOfSynchWithBuffers().add(a2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canBeRemovedFromCache() {
        try {
            Openable a;
            return !a.hasUnsavedChanges();
        }
        catch (AsnModelException asnModelException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void buildStructure(IProgressMonitor a3) throws AsnModelException {
        Openable a2;
        a2.A = true;
        try {
            a2.computeChildren((IProgressMonitor)a3);
        }
        catch (AsnModelException a3) {
            a2.A = false;
            throw a3;
        }
        Object a3 = AsnModelManager.getAsnModelManager();
        a3.getElementsOutOfSynchWithBuffers().remove(a2);
    }

    public boolean canBufferBeRemovedFromCache(IBuffer a) {
        return !a.hasUnsavedChanges();
    }

    @Override
    public IOpenable getOpenable() {
        Openable a;
        return a;
    }

    protected boolean parentExists() {
        Openable a;
        IAsnElement iAsnElement = a.getParent();
        if (iAsnElement == null) {
            return true;
        }
        return iAsnElement.exists();
    }

    protected abstract boolean computeChildren(IProgressMonitor var1) throws AsnModelException;
}

