/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.corext.dom;

import org.asnlab.asndt.core.dom.ASTNode;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;

public class Selection {
    public static final int INTERSECTS = 0;
    public static final int BEFORE = 1;
    public static final int SELECTED = 2;
    public static final int AFTER = 3;
    private int fStart;
    private int fLength;
    private int fExclusiveEnd;

    protected Selection() {
    }

    public static Selection createFromStartLength(int s, int l) {
        Assert.isTrue((s >= 0 && l >= 0 ? 1 : 0) != 0);
        Selection result = new Selection();
        result.fStart = s;
        result.fLength = l;
        result.fExclusiveEnd = s + l;
        return result;
    }

    public static Selection createFromStartEnd(int s, int e) {
        Assert.isTrue((s >= 0 && e >= s ? 1 : 0) != 0);
        Selection result = new Selection();
        result.fStart = s;
        result.fLength = e - s + 1;
        result.fExclusiveEnd = result.fStart + result.fLength;
        return result;
    }

    public int getOffset() {
        return this.fStart;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getInclusiveEnd() {
        return this.fExclusiveEnd - 1;
    }

    public int getExclusiveEnd() {
        return this.fExclusiveEnd;
    }

    public int getVisitSelectionMode(ASTNode node) {
        int nodeStart = node.getSourceStart();
        int nodeEnd = node.getSourceEnd() + 1;
        if (nodeEnd <= this.fStart) {
            return 1;
        }
        if (this.covers(node)) {
            return 2;
        }
        if (this.fExclusiveEnd <= nodeStart) {
            return 3;
        }
        return 0;
    }

    public int getEndVisitSelectionMode(ASTNode node) {
        node.getSourceStart();
        int nodeEnd = node.getSourceEnd() + 1;
        if (nodeEnd <= this.fStart) {
            return 1;
        }
        if (this.covers(node)) {
            return 2;
        }
        if (nodeEnd >= this.fExclusiveEnd) {
            return 3;
        }
        return 0;
    }

    public boolean covers(int position) {
        return this.fStart <= position && position < this.fStart + this.fLength;
    }

    public boolean covers(ASTNode node) {
        int nodeStart = node.getSourceStart();
        return this.fStart <= nodeStart && node.getSourceEnd() + 1 <= this.fExclusiveEnd;
    }

    public boolean coveredBy(ASTNode node) {
        int nodeStart = node.getSourceStart();
        return nodeStart <= this.fStart && this.fExclusiveEnd <= node.getSourceEnd() + 1;
    }

    public boolean coveredBy(IRegion region) {
        int rangeStart = region.getOffset();
        return rangeStart <= this.fStart && this.fExclusiveEnd <= rangeStart + region.getLength();
    }

    public boolean endsIn(ASTNode node) {
        int nodeStart = node.getSourceStart();
        return nodeStart < this.fExclusiveEnd && this.fExclusiveEnd < node.getSourceEnd() + 1;
    }

    public boolean liesOutside(ASTNode node) {
        boolean selectionBeforeNode;
        int nodeStart = node.getSourceStart();
        int nodeEnd = node.getSourceEnd() + 1;
        boolean nodeBeforeSelection = nodeEnd < this.fStart;
        boolean bl = selectionBeforeNode = this.fExclusiveEnd < nodeStart;
        return nodeBeforeSelection || selectionBeforeNode;
    }

    public String toString() {
        return "<start == " + this.fStart + ", length == " + this.fLength + "/>";
    }
}

