/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.corext.refactoring;

import java.util.ArrayList;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IAsnModel;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.IComponentType;
import org.asnlab.asndt.core.ISourceFolder;
import org.asnlab.asndt.core.IType;
import org.asnlab.asndt.core.IValue;
import org.asnlab.asndt.internal.corext.refactoring.Checks;
import org.asnlab.asndt.internal.corext.refactoring.reorg.ReorgUtils;
import org.asnlab.asndt.internal.corext.util.AsnModelUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;

public final class RefactoringAvailabilityTester {
    public static IType getDeclaringType(IAsnElement element) {
        if (element == null) {
            return null;
        }
        if (!(element instanceof IType)) {
            element = element.getAncestor(10);
        }
        return (IType)element;
    }

    public static IAsnElement[] getAsnElements(Object[] elements) {
        ArrayList<Object> result = new ArrayList<Object>();
        int index = 0;
        while (index < elements.length) {
            if (elements[index] instanceof IAsnElement) {
                result.add(elements[index]);
            }
            ++index;
        }
        return result.toArray(new IAsnElement[result.size()]);
    }

    public static IResource[] getResources(Object[] elements) {
        ArrayList<Object> result = new ArrayList<Object>();
        int index = 0;
        while (index < elements.length) {
            if (elements[index] instanceof IResource) {
                result.add(elements[index]);
            }
            ++index;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public static boolean isDeleteAvailable(IAsnElement element) throws AsnModelException {
        if (!element.exists()) {
            return false;
        }
        if (element instanceof IAsnModel || element instanceof IAsnProject) {
            return false;
        }
        if (element.getParent() != null && element.getParent().isReadOnly()) {
            return false;
        }
        if (element.getResource() == null && !RefactoringAvailabilityTester.isWorkingCopyElement(element)) {
            return false;
        }
        return !ReorgUtils.isDeletedFromEditor(element);
    }

    public static boolean isDeleteAvailable(IResource resource) {
        if (!resource.exists() || resource.isPhantom()) {
            return false;
        }
        return resource.getType() != 8 && resource.getType() != 4;
    }

    public static boolean isDeleteAvailable(IStructuredSelection selection) throws AsnModelException {
        if (!selection.isEmpty()) {
            return RefactoringAvailabilityTester.isDeleteAvailable(selection.toArray());
        }
        return false;
    }

    public static boolean isDeleteAvailable(Object[] objects) throws AsnModelException {
        if (objects.length != 0) {
            IAsnElement[] elements;
            IResource[] resources = RefactoringAvailabilityTester.getResources(objects);
            if (objects.length != resources.length + (elements = RefactoringAvailabilityTester.getAsnElements(objects)).length) {
                return false;
            }
            int index = 0;
            while (index < resources.length) {
                if (!RefactoringAvailabilityTester.isDeleteAvailable(resources[index])) {
                    return false;
                }
                ++index;
            }
            index = 0;
            while (index < elements.length) {
                if (!RefactoringAvailabilityTester.isDeleteAvailable(elements[index])) {
                    return false;
                }
                ++index;
            }
            return true;
        }
        return false;
    }

    public static boolean isRenameAvailable(ICompilationUnit unit) {
        if (unit == null) {
            return false;
        }
        if (!unit.exists()) {
            return false;
        }
        if (!AsnModelUtil.isPrimary(unit)) {
            return false;
        }
        return !unit.isReadOnly();
    }

    public static boolean isRenameAvailable(IAsnProject project) throws AsnModelException {
        if (project == null) {
            return false;
        }
        if (!Checks.isAvailable((IAsnElement)project)) {
            return false;
        }
        return project.isConsistent();
    }

    public static boolean isRenameAvailable(IValue value) throws CoreException {
        if (value == null) {
            return false;
        }
        return Checks.isAvailable((IAsnElement)value);
    }

    public static boolean isRenameAvailable(ISourceFolder fragment) throws AsnModelException {
        if (fragment == null) {
            return false;
        }
        return Checks.isAvailable((IAsnElement)fragment);
    }

    public static boolean isRenameAvailable(IResource resource) {
        if (resource == null) {
            return false;
        }
        if (!resource.exists()) {
            return false;
        }
        return resource.isAccessible();
    }

    public static boolean isRenameAvailable(IType type) throws AsnModelException {
        if (type == null) {
            return false;
        }
        return Checks.isAvailable((IAsnElement)type);
    }

    public static boolean isRenameFieldAvailable(IComponentType field) throws AsnModelException {
        return Checks.isAvailable((IAsnElement)field);
    }

    public static boolean isRenameNonVirtualMethodAvailable(IValue value) throws AsnModelException, CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(value);
    }

    public static boolean isWorkingCopyElement(IAsnElement element) {
        if (element instanceof ICompilationUnit) {
            return ((ICompilationUnit)element).isWorkingCopy();
        }
        if (ReorgUtils.isInsideCompilationUnit(element)) {
            return ReorgUtils.getCompilationUnit(element).isWorkingCopy();
        }
        return false;
    }

    private RefactoringAvailabilityTester() {
    }
}

