/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.corext.refactoring.changes;

import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.internal.corext.refactoring.changes.UndoCompilationUnitChange;
import org.asnlab.asndt.internal.corext.util.AsnModelUtil;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.UndoEdit;

public class CompilationUnitChange
extends TextFileChange {
    private ICompilationUnit fCUnit;

    public CompilationUnitChange(String name, ICompilationUnit cunit) {
        super(name, CompilationUnitChange.getFile(cunit));
        Assert.isNotNull((Object)cunit);
        this.fCUnit = cunit;
        this.setTextType("asn");
    }

    private static IFile getFile(ICompilationUnit cunit) {
        return (IFile)cunit.getResource();
    }

    public Object getModifiedElement() {
        return this.fCUnit;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCUnit;
    }

    protected IDocument acquireDocument(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        this.fCUnit.becomeWorkingCopy(null, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        return super.acquireDocument((IProgressMonitor)new SubProgressMonitor(pm, 1));
    }

    protected void releaseDocument(IDocument document, IProgressMonitor pm) throws CoreException {
        super.releaseDocument(document, pm);
        try {
            this.fCUnit.discardWorkingCopy();
        }
        finally {
            if (!this.isDocumentAcquired()) {
                if (this.fCUnit.isWorkingCopy()) {
                    AsnModelUtil.reconcile(this.fCUnit);
                } else {
                    this.fCUnit.makeConsistent(pm);
                }
            }
        }
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) {
        try {
            return new UndoCompilationUnitChange(this.getName(), this.fCUnit, edit, stampToRestore, this.getSaveMode());
        }
        catch (CoreException e) {
            AsnPlugin.log(e);
            return null;
        }
    }

    public Object getAdapter(Class adapter) {
        if (ICompilationUnit.class.equals((Object)adapter)) {
            return this.fCUnit;
        }
        return super.getAdapter(adapter);
    }
}

