/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.corext.refactoring.reorg;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.asnlab.asndt.core.AsnCore;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.internal.corext.refactoring.RefactoringCoreMessages;
import org.asnlab.asndt.internal.corext.util.AsnModelUtil;
import org.asnlab.asndt.internal.corext.util.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ui.IWorkingSet;

public class ReorgUtils {
    private ReorgUtils() {
    }

    public static boolean containsOnlyProjects(List elements) {
        if (elements.isEmpty()) {
            return false;
        }
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            if (ReorgUtils.isProject(iter.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean isProject(Object element) {
        return element instanceof IAsnProject || element instanceof IProject;
    }

    public static boolean isInsideCompilationUnit(IAsnElement element) {
        return !(element instanceof ICompilationUnit) && ReorgUtils.hasAncestorOfType(element, 5);
    }

    public static boolean hasAncestorOfType(IAsnElement element, int type) {
        return element.getAncestor(type) != null;
    }

    public static ICompilationUnit getCompilationUnit(IAsnElement asnElement) {
        if (asnElement instanceof ICompilationUnit) {
            return (ICompilationUnit)asnElement;
        }
        return (ICompilationUnit)asnElement.getAncestor(5);
    }

    public static ICompilationUnit[] getCompilationUnits(IAsnElement[] asnElements) {
        ICompilationUnit[] result = new ICompilationUnit[asnElements.length];
        int i = 0;
        while (i < asnElements.length) {
            result[i] = ReorgUtils.getCompilationUnit(asnElements[i]);
            ++i;
        }
        return result;
    }

    public static IResource getResource(IAsnElement element) {
        if (element instanceof ICompilationUnit) {
            return ((ICompilationUnit)element).getPrimary().getResource();
        }
        return element.getResource();
    }

    public static IResource[] getResources(IAsnElement[] elements) {
        IResource[] result = new IResource[elements.length];
        int i = 0;
        while (i < elements.length) {
            result[i] = ReorgUtils.getResource(elements[i]);
            ++i;
        }
        return result;
    }

    public static String getName(IResource resource) {
        String pattern = ReorgUtils.createNamePattern(resource);
        Object[] args = ReorgUtils.createNameArguments(resource);
        return Messages.format(pattern, args);
    }

    private static String createNamePattern(IResource resource) {
        switch (resource.getType()) {
            case 1: {
                return RefactoringCoreMessages.ReorgUtils_0;
            }
            case 2: {
                return RefactoringCoreMessages.ReorgUtils_1;
            }
            case 4: {
                return RefactoringCoreMessages.ReorgUtils_2;
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private static String[] createNameArguments(IResource resource) {
        return new String[]{resource.getName()};
    }

    public static IResource[] getResources(List elements) {
        ArrayList resources = new ArrayList(elements.size());
        for (Object element : elements) {
            if (!(element instanceof IResource)) continue;
            resources.add(element);
        }
        return resources.toArray(new IResource[resources.size()]);
    }

    public static IAsnElement[] getAsnElements(List elements) {
        ArrayList resources = new ArrayList(elements.size());
        for (Object element : elements) {
            if (!(element instanceof IAsnElement)) continue;
            resources.add(element);
        }
        return resources.toArray(new IAsnElement[resources.size()]);
    }

    public static IWorkingSet[] getWorkingSets(List elements) {
        ArrayList result = new ArrayList(1);
        for (Object element : elements) {
            if (!(element instanceof IWorkingSet)) continue;
            result.add(element);
        }
        return result.toArray(new IWorkingSet[result.size()]);
    }

    public static boolean isDeletedFromEditor(IAsnElement elem) {
        if (!ReorgUtils.isInsideCompilationUnit(elem)) {
            return false;
        }
        ICompilationUnit cu = ReorgUtils.getCompilationUnit(elem);
        if (cu == null) {
            return false;
        }
        ICompilationUnit wc = cu;
        if (cu.equals(wc)) {
            return false;
        }
        IAsnElement wcElement = AsnModelUtil.findInCompilationUnit(wc, elem);
        return wcElement == null || !wcElement.exists();
    }

    public static IResource[] setMinus(IResource[] setToRemoveFrom, IResource[] elementsToRemove) {
        HashSet<IResource> setMinus = new HashSet<IResource>(setToRemoveFrom.length - setToRemoveFrom.length);
        setMinus.addAll(Arrays.asList(setToRemoveFrom));
        setMinus.removeAll(Arrays.asList(elementsToRemove));
        return setMinus.toArray(new IResource[setMinus.size()]);
    }

    public static IAsnElement[] setMinus(IAsnElement[] setToRemoveFrom, IAsnElement[] elementsToRemove) {
        HashSet<IAsnElement> setMinus = new HashSet<IAsnElement>(setToRemoveFrom.length - setToRemoveFrom.length);
        setMinus.addAll(Arrays.asList(setToRemoveFrom));
        setMinus.removeAll(Arrays.asList(elementsToRemove));
        return setMinus.toArray(new IAsnElement[setMinus.size()]);
    }

    public static IAsnElement[] union(IAsnElement[] set1, IAsnElement[] set2) {
        ArrayList union = new ArrayList(set1.length + set2.length);
        ReorgUtils.addAll(set1, union);
        ReorgUtils.addAll(set2, union);
        return union.toArray(new IAsnElement[union.size()]);
    }

    public static IResource[] union(IResource[] set1, IResource[] set2) {
        ArrayList union = new ArrayList(set1.length + set2.length);
        ReorgUtils.addAll(ReorgUtils.getNotNulls(set1), union);
        ReorgUtils.addAll(ReorgUtils.getNotNulls(set2), union);
        return union.toArray(new IResource[union.size()]);
    }

    private static void addAll(Object[] array, List list) {
        int i = 0;
        while (i < array.length) {
            if (!list.contains(array[i])) {
                list.add(array[i]);
            }
            ++i;
        }
    }

    public static Set union(Set set1, Set set2) {
        HashSet union = new HashSet(set1.size() + set2.size());
        union.addAll(set1);
        union.addAll(set2);
        return union;
    }

    public static IFolder[] getFolders(IResource[] resources) {
        Set result = ReorgUtils.getResourcesOfType(resources, 2);
        return result.toArray(new IFolder[result.size()]);
    }

    public static IFile[] getFiles(IResource[] resources) {
        Set result = ReorgUtils.getResourcesOfType(resources, 1);
        return result.toArray(new IFile[result.size()]);
    }

    public static Set getResourcesOfType(IResource[] resources, int typeMask) {
        HashSet<IResource> result = new HashSet<IResource>(resources.length);
        int i = 0;
        while (i < resources.length) {
            if (ReorgUtils.isOfType(resources[i], typeMask)) {
                result.add(resources[i]);
            }
            ++i;
        }
        return result;
    }

    public static List getElementsOfType(IAsnElement[] asnElements, int type) {
        ArrayList<IAsnElement> result = new ArrayList<IAsnElement>(asnElements.length);
        int i = 0;
        while (i < asnElements.length) {
            if (ReorgUtils.isOfType(asnElements[i], type)) {
                result.add(asnElements[i]);
            }
            ++i;
        }
        return result;
    }

    public static boolean hasElementsNotOfType(IResource[] resources, int typeMask) {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource != null && !ReorgUtils.isOfType(resource, typeMask)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasElementsNotOfType(IAsnElement[] asnElements, int type) {
        int i = 0;
        while (i < asnElements.length) {
            IAsnElement element = asnElements[i];
            if (element != null && !ReorgUtils.isOfType(element, type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasElementsOfType(IAsnElement[] asnElements, int type) {
        int i = 0;
        while (i < asnElements.length) {
            IAsnElement element = asnElements[i];
            if (element != null && ReorgUtils.isOfType(element, type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasElementsOfType(IAsnElement[] asnElements, int[] types) {
        int i = 0;
        while (i < types.length) {
            if (ReorgUtils.hasElementsOfType(asnElements, types[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasElementsOfType(IResource[] resources, int typeMask) {
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource != null && ReorgUtils.isOfType(resource, typeMask)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isOfType(IAsnElement element, int type) {
        return element.getElementType() == type;
    }

    private static boolean isOfType(IResource resource, int type) {
        return resource != null && ReorgUtils.isFlagSet(resource.getType(), type);
    }

    private static boolean isFlagSet(int flags, int flag) {
        return (flags & flag) != 0;
    }

    public static boolean containsLinkedResources(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i] != null && resources[i].isLinked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean containsLinkedResources(IAsnElement[] asnElements) {
        int i = 0;
        while (i < asnElements.length) {
            IResource res = ReorgUtils.getResource(asnElements[i]);
            if (res != null && res.isLinked()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean canBeDestinationForLinkedResources(IResource resource) {
        return resource.isAccessible() && resource instanceof IProject;
    }

    public static boolean isParentInWorkspaceOrOnDisk(IResource res, IResource maybeParent) {
        if (res == null) {
            return false;
        }
        return ReorgUtils.areEqualInWorkspaceOrOnDisk((IResource)res.getParent(), maybeParent);
    }

    public static boolean areEqualInWorkspaceOrOnDisk(IResource r1, IResource r2) {
        if (r1 == null || r2 == null) {
            return false;
        }
        if (r1.equals((Object)r2)) {
            return true;
        }
        URI r1Location = r1.getLocationURI();
        URI r2Location = r2.getLocationURI();
        if (r1Location == null || r2Location == null) {
            return false;
        }
        return r1Location.equals(r2Location);
    }

    public static IResource[] getNotNulls(IResource[] resources) {
        ArrayList<IResource> result = new ArrayList<IResource>(resources.length);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource != null && !result.contains(resource)) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public static IResource[] getNotLinked(IResource[] resources) {
        ArrayList<IResource> result = new ArrayList<IResource>(resources.length);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource != null && !result.contains(resource) && !resource.isLinked()) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public static Map groupByCompilationUnit(List asnElements) {
        HashMap result = new HashMap();
        for (IAsnElement element : asnElements) {
            ICompilationUnit cu = ReorgUtils.getCompilationUnit(element);
            if (cu == null) continue;
            if (!result.containsKey(cu)) {
                result.put(cu, new ArrayList(1));
            }
            ((List)result.get(cu)).add(element);
        }
        return result;
    }

    public static void splitIntoAsnElementsAndResources(Object[] elements, List asnElementResult, List resourceResult) {
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element instanceof IAsnElement) {
                asnElementResult.add(element);
            } else if (element instanceof IResource) {
                IResource resource = (IResource)element;
                IAsnElement jElement = AsnCore.create((IResource)resource);
                if (jElement != null && jElement.exists()) {
                    asnElementResult.add(jElement);
                } else {
                    resourceResult.add(resource);
                }
            }
            ++i;
        }
    }

    public static boolean containsElementOrParent(Set elements, IAsnElement element) {
        if (elements.contains(element)) {
            return true;
        }
        IAsnElement parent = element.getParent();
        while (parent != null) {
            if (elements.contains(parent)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean containsElementOrParent(Set elements, IResource element) {
        if (elements.contains(element)) {
            return true;
        }
        IContainer parent = element.getParent();
        while (parent != null) {
            if (elements.contains(parent)) {
                return true;
            }
            IAsnElement parentAsAsnElement = AsnCore.create((IResource)parent);
            if (parentAsAsnElement != null && parentAsAsnElement.exists() && elements.contains(parentAsAsnElement)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }
}

