/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.corext.util;

import java.util.ArrayList;
import java.util.HashSet;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IAsnModel;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.ISourceFolder;
import org.asnlab.asndt.core.IType;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.mapping.RemoteResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class AsnElementResourceMapping
extends ResourceMapping {
    protected AsnElementResourceMapping() {
    }

    public IAsnElement getAsnElement() {
        Object o = this.getModelObject();
        if (o instanceof IAsnElement) {
            return (IAsnElement)o;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AsnElementResourceMapping)) {
            return false;
        }
        return this.getAsnElement().equals(((AsnElementResourceMapping)((Object)obj)).getAsnElement());
    }

    public int hashCode() {
        IAsnElement asnElement = this.getAsnElement();
        if (asnElement == null) {
            return super.hashCode();
        }
        return asnElement.hashCode();
    }

    public String getModelProviderId() {
        return "org.asnlab.asndt.ui.modelProvider";
    }

    public boolean contains(ResourceMapping mapping) {
        if (mapping instanceof AsnElementResourceMapping) {
            AsnElementResourceMapping asnMapping = (AsnElementResourceMapping)mapping;
            IAsnElement element = this.getAsnElement();
            IAsnElement other = asnMapping.getAsnElement();
            if (other != null && element != null) {
                return element.getPath().isPrefixOf(other.getPath());
            }
        }
        return false;
    }

    private static IFile[] getPackageContent(ISourceFolder pack) throws CoreException {
        ArrayList<IResource> result = new ArrayList<IResource>();
        IContainer container = (IContainer)pack.getResource();
        if (container != null) {
            IResource[] members = container.members();
            int m = 0;
            while (m < members.length) {
                IFile file;
                IResource member = members[m];
                if (!(!(member instanceof IFile) || "class".equals((file = (IFile)member).getFileExtension()) && file.isDerived())) {
                    result.add(member);
                }
                ++m;
            }
        }
        return result.toArray(new IFile[result.size()]);
    }

    public static ResourceMapping create(IAsnElement element) {
        switch (element.getElementType()) {
            case 10: {
                return AsnElementResourceMapping.create((IType)element);
            }
            case 5: {
                return AsnElementResourceMapping.create((ICompilationUnit)element);
            }
            case 4: {
                return AsnElementResourceMapping.create((IAsnElement)((ISourceFolder)element));
            }
            case 2: {
                return AsnElementResourceMapping.create((IAsnProject)element);
            }
            case 1: {
                return AsnElementResourceMapping.create((IAsnModel)element);
            }
        }
        return null;
    }

    public static ResourceMapping create(IAsnModel model) {
        return new AsnModelResourceMapping(model);
    }

    public static ResourceMapping create(IAsnProject project) {
        return new AsnProjectResourceMapping(project);
    }

    public static ResourceMapping create(ICompilationUnit unit) {
        if (unit == null) {
            return null;
        }
        return new CompilationUnitResourceMapping(unit.getPrimary());
    }

    public static ResourceMapping create(IType type) {
        IAsnElement parent = type.getParent();
        if (parent instanceof ICompilationUnit) {
            return AsnElementResourceMapping.create((ICompilationUnit)parent);
        }
        return null;
    }

    private static final class AsnModelResourceMapping
    extends AsnElementResourceMapping {
        private final IAsnModel fAsnModel;

        private AsnModelResourceMapping(IAsnModel model) {
            Assert.isNotNull((Object)model);
            this.fAsnModel = model;
        }

        public Object getModelObject() {
            return this.fAsnModel;
        }

        public IProject[] getProjects() {
            IAsnProject[] projects = null;
            try {
                projects = this.fAsnModel.getAsnProjects();
            }
            catch (AsnModelException e) {
                AsnPlugin.log(e);
                return new IProject[0];
            }
            IProject[] result = new IProject[projects.length];
            int i = 0;
            while (i < projects.length) {
                result[i] = projects[i].getProject();
                ++i;
            }
            return result;
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            IAsnProject[] projects = this.fAsnModel.getAsnProjects();
            ResourceTraversal[] result = new ResourceTraversal[projects.length];
            int i = 0;
            while (i < projects.length) {
                result[i] = new ResourceTraversal(new IResource[]{projects[i].getProject()}, 2, 0);
                ++i;
            }
            return result;
        }
    }

    private static final class AsnProjectResourceMapping
    extends AsnElementResourceMapping {
        private final IAsnProject fProject;

        private AsnProjectResourceMapping(IAsnProject project) {
            Assert.isNotNull((Object)project);
            this.fProject = project;
        }

        public Object getModelObject() {
            return this.fProject;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fProject.getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fProject.getProject()}, 2, 0)};
        }
    }

    private static final class CompilationUnitResourceMapping
    extends AsnElementResourceMapping {
        private final ICompilationUnit fUnit;

        private CompilationUnitResourceMapping(ICompilationUnit unit) {
            Assert.isNotNull((Object)unit);
            this.fUnit = unit;
        }

        public Object getModelObject() {
            return this.fUnit;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fUnit.getAsnProject().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fUnit.getResource()}, 1, 0)};
        }
    }

    private static final class LocalPackageFragementTraversal
    extends ResourceTraversal {
        private final ISourceFolder fPack;

        public LocalPackageFragementTraversal(ISourceFolder pack) throws CoreException {
            super(new IResource[]{pack.getResource()}, 1, 0);
            this.fPack = pack;
        }

        public void accept(IResourceVisitor visitor) throws CoreException {
            IFile[] files = AsnElementResourceMapping.getPackageContent(this.fPack);
            IResource resource = this.fPack.getResource();
            if (resource != null) {
                visitor.visit(resource);
            }
            int i = 0;
            while (i < files.length) {
                visitor.visit((IResource)files[i]);
                ++i;
            }
        }
    }

    private static final class LogicalPackageResourceMapping
    extends ResourceMapping {
        private final ISourceFolder[] fFragments;

        private LogicalPackageResourceMapping(ISourceFolder[] fragments) {
            this.fFragments = fragments;
        }

        public Object getModelObject() {
            return this.fFragments;
        }

        public IProject[] getProjects() {
            HashSet<IProject> result = new HashSet<IProject>();
            int i = 0;
            while (i < this.fFragments.length) {
                result.add(this.fFragments[i].getAsnProject().getProject());
                ++i;
            }
            return result.toArray(new IProject[result.size()]);
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            ArrayList<ResourceTraversal> result = new ArrayList<ResourceTraversal>();
            if (context instanceof RemoteResourceMappingContext) {
                int i = 0;
                while (i < this.fFragments.length) {
                    result.add(new ResourceTraversal(new IResource[]{this.fFragments[i].getResource()}, 1, 0));
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.fFragments.length) {
                    result.add(new LocalPackageFragementTraversal(this.fFragments[i]));
                    ++i;
                }
            }
            return result.toArray(new ResourceTraversal[result.size()]);
        }

        public String getModelProviderId() {
            return "org.asnlab.asndt.ui.modelProvider";
        }
    }

    private static final class PackageFragmentResourceMapping
    extends AsnElementResourceMapping {
        private final ISourceFolder fPack;

        private PackageFragmentResourceMapping(ISourceFolder pack) {
            Assert.isNotNull((Object)pack);
            this.fPack = pack;
        }

        public Object getModelObject() {
            return this.fPack;
        }

        public IProject[] getProjects() {
            return new IProject[]{this.fPack.getAsnProject().getProject()};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            if (context instanceof RemoteResourceMappingContext) {
                return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.fPack.getResource()}, 1, 0)};
            }
            return new ResourceTraversal[]{new LocalPackageFragementTraversal(this.fPack)};
        }

        public void accept(ResourceMappingContext context, IResourceVisitor visitor, IProgressMonitor monitor) throws CoreException {
            if (context instanceof RemoteResourceMappingContext) {
                super.accept(context, visitor, monitor);
            } else {
                IFile[] files = AsnElementResourceMapping.getPackageContent(this.fPack);
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask("", files.length + 1);
                IResource resource = this.fPack.getResource();
                if (resource != null) {
                    visitor.visit(resource);
                }
                monitor.worked(1);
                int i = 0;
                while (i < files.length) {
                    visitor.visit((IResource)files[i]);
                    monitor.worked(1);
                    ++i;
                }
            }
        }
    }
}

