/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.corext.util;

import org.asnlab.asndt.core.AsnCore;
import org.asnlab.asndt.core.IAsnProject;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class CodeFormatterUtil {
    public static TextEdit shifEdit(TextEdit oldEdit, int diff) {
        MultiTextEdit newEdit;
        ReplaceEdit edit;
        if (oldEdit instanceof ReplaceEdit) {
            edit = (ReplaceEdit)oldEdit;
            newEdit = new ReplaceEdit(edit.getOffset() - diff, edit.getLength(), edit.getText());
        } else if (oldEdit instanceof InsertEdit) {
            edit = (InsertEdit)oldEdit;
            newEdit = new InsertEdit(edit.getOffset() - diff, edit.getText());
        } else if (oldEdit instanceof DeleteEdit) {
            edit = (DeleteEdit)oldEdit;
            newEdit = new DeleteEdit(edit.getOffset() - diff, edit.getLength());
        } else if (oldEdit instanceof MultiTextEdit) {
            newEdit = new MultiTextEdit();
        } else {
            return null;
        }
        TextEdit[] children = oldEdit.getChildren();
        int i = 0;
        while (i < children.length) {
            TextEdit shifted = CodeFormatterUtil.shifEdit(children[i], diff);
            if (shifted != null) {
                newEdit.addChild(shifted);
            }
            ++i;
        }
        return newEdit;
    }

    public static int getTabWidth(IAsnProject project) {
        String key = "space".equals(CodeFormatterUtil.getCoreOption(project, "org.asnlab.asndt.core.formatter.tabulation.char")) ? "org.asnlab.asndt.core.formatter.indentation.size" : "org.asnlab.asndt.core.formatter.tabulation.size";
        return CodeFormatterUtil.getCoreOption(project, key, 4);
    }

    public static int getIndentWidth(IAsnProject project) {
        String key = "mixed".equals(CodeFormatterUtil.getCoreOption(project, "org.asnlab.asndt.core.formatter.tabulation.char")) ? "org.asnlab.asndt.core.formatter.indentation.size" : "org.asnlab.asndt.core.formatter.tabulation.size";
        return CodeFormatterUtil.getCoreOption(project, key, 4);
    }

    private static int getCoreOption(IAsnProject project, String key, int def) {
        try {
            return Integer.parseInt(CodeFormatterUtil.getCoreOption(project, key));
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    private static String getCoreOption(IAsnProject project, String key) {
        if (project == null) {
            return AsnCore.getOption((String)key);
        }
        return project.getOption(key, true);
    }
}

