/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.ISourceReference;
import org.asnlab.asndt.internal.ui.asneditor.EditorUtility;
import org.asnlab.asndt.ui.AsnElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class OpenActionUtil {
    private OpenActionUtil() {
    }

    public static void open(Object element) throws AsnModelException, PartInitException {
        OpenActionUtil.open(element, true);
    }

    public static void open(Object element, boolean activate) throws AsnModelException, PartInitException {
        IEditorPart part = EditorUtility.openInEditor(element, activate);
        if (element instanceof IAsnElement) {
            EditorUtility.revealInEditor(part, (IAsnElement)element);
        }
    }

    public static List filterResolveResults(IAsnElement[] codeResolveResults) {
        int nResults = codeResolveResults.length;
        ArrayList<IAsnElement> refs = new ArrayList<IAsnElement>(nResults);
        int i = 0;
        while (i < nResults) {
            if (codeResolveResults[i] instanceof ISourceReference) {
                refs.add(codeResolveResults[i]);
            }
            ++i;
        }
        return refs;
    }

    public static IAsnElement selectAsnElement(IAsnElement[] elements, Shell shell, String title, String message) {
        Object[] selection;
        int nResults = elements.length;
        if (nResults == 0) {
            return null;
        }
        if (nResults == 1) {
            return elements[0];
        }
        int flags = AsnElementLabelProvider.SHOW_DEFAULT | 0x400 | 0x40;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new AsnElementLabelProvider(flags));
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements((Object[])elements);
        if (dialog.open() == 0 && (selection = dialog.getResult()) != null && selection.length > 0) {
            nResults = selection.length;
            int i = 0;
            while (i < nResults) {
                Object current = selection[i];
                if (current instanceof IAsnElement) {
                    return (IAsnElement)current;
                }
                ++i;
            }
        }
        return null;
    }
}

