/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.asneditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.asnlab.asndt.core.AsnCore;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.IImportContainer;
import org.asnlab.asndt.core.IMember;
import org.asnlab.asndt.core.ISourceRange;
import org.asnlab.asndt.core.ISourceReference;
import org.asnlab.asndt.core.ISymbolsFromModule;
import org.asnlab.asndt.core.dom.ASTNode;
import org.asnlab.asndt.core.dom.CompilationUnitDeclaration;
import org.asnlab.asndt.internal.corext.dom.NodeFinder;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.actions.CompositeActionGroup;
import org.asnlab.asndt.internal.ui.actions.FoldingActionGroup;
import org.asnlab.asndt.internal.ui.actions.SelectionConverter;
import org.asnlab.asndt.internal.ui.asneditor.ASTProvider;
import org.asnlab.asndt.internal.ui.asneditor.AsnAnnotationIterator;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditorMessages;
import org.asnlab.asndt.internal.ui.asneditor.AsnOutlinePage;
import org.asnlab.asndt.internal.ui.asneditor.AsnSourceViewer;
import org.asnlab.asndt.internal.ui.asneditor.EditorUtility;
import org.asnlab.asndt.internal.ui.asneditor.GotoMatchingBracketAction;
import org.asnlab.asndt.internal.ui.asneditor.IAsnAnnotation;
import org.asnlab.asndt.internal.ui.asneditor.RemoveOccurrenceAnnotations;
import org.asnlab.asndt.internal.ui.asneditor.SemanticHighlightingManager;
import org.asnlab.asndt.internal.ui.asneditor.SemanticHighlightings;
import org.asnlab.asndt.internal.ui.asneditor.selectionactions.GoToNextPreviousMemberAction;
import org.asnlab.asndt.internal.ui.asneditor.selectionactions.SelectionHistory;
import org.asnlab.asndt.internal.ui.asneditor.selectionactions.StructureSelectEnclosingAction;
import org.asnlab.asndt.internal.ui.asneditor.selectionactions.StructureSelectHistoryAction;
import org.asnlab.asndt.internal.ui.asneditor.selectionactions.StructureSelectNextAction;
import org.asnlab.asndt.internal.ui.asneditor.selectionactions.StructureSelectPreviousAction;
import org.asnlab.asndt.internal.ui.search.OccurrencesFinder;
import org.asnlab.asndt.internal.ui.text.AsnChangeHover;
import org.asnlab.asndt.internal.ui.text.AsnPairMatcher;
import org.asnlab.asndt.internal.ui.text.AsnWordFinder;
import org.asnlab.asndt.internal.ui.text.AsnWordIterator;
import org.asnlab.asndt.internal.ui.text.DocumentCharacterIterator;
import org.asnlab.asndt.internal.ui.text.HTMLTextPresenter;
import org.asnlab.asndt.internal.ui.text.PreferencesAdapter;
import org.asnlab.asndt.internal.ui.text.asn.hover.AsnExpandHover;
import org.asnlab.asndt.internal.ui.text.asn.hover.SourceViewerInformationControl;
import org.asnlab.asndt.internal.ui.viewsupport.ISelectionListenerWithAST;
import org.asnlab.asndt.internal.ui.viewsupport.IViewPartInputProvider;
import org.asnlab.asndt.internal.ui.viewsupport.SelectionListenerWithASTManager;
import org.asnlab.asndt.ui.actions.AsnSearchActionGroup;
import org.asnlab.asndt.ui.actions.OpenEditorActionGroup;
import org.asnlab.asndt.ui.actions.OpenViewActionGroup;
import org.asnlab.asndt.ui.text.AsnSourceViewerConfiguration;
import org.asnlab.asndt.ui.text.AsnTextTools;
import org.asnlab.asndt.ui.text.folding.IAsnFoldingStructureProvider;
import org.asnlab.asndt.ui.text.folding.IAsnFoldingStructureProviderExtension;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISelectionValidator;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.ISourceViewerExtension3;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineChangeHover;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.editors.text.DefaultEncodingSupport;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.operations.NonLocalUndoUserApprover;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.StatusTextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.TextNavigationAction;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.osgi.service.prefs.BackingStoreException;

public abstract class AsnEditor
extends AbstractDecoratedTextEditor
implements IViewPartInputProvider {
    protected static final String MATCHING_BRACKETS = "matchingBrackets";
    protected static final String MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']', '<', '>'};
    protected AsnOutlinePage fOutlinePage;
    protected String fOutlinerContextMenuId;
    private EditorSelectionChangedListener fEditorSelectionChangedListener;
    protected AbstractSelectionChangedListener fOutlineSelectionChangedListener = new OutlineSelectionChangedListener();
    protected AsnPairMatcher fBracketMatcher = new AsnPairMatcher(BRACKETS);
    private DefaultEncodingSupport fEncodingSupport;
    private InformationPresenter fInformationPresenter;
    private SelectionHistory fSelectionHistory;
    protected CompositeActionGroup fActionGroups;
    private FoldingActionGroup fFoldingGroup;
    private CompositeActionGroup fContextMenuGroup;
    private Annotation[] fOccurrenceAnnotations = null;
    private boolean fMarkOccurrenceAnnotations;
    private boolean fStickyOccurrenceAnnotations;
    private boolean fMarkTypeOccurrences;
    private boolean fMarkValueOccurrences;
    private boolean fMarkComponentOccurrences;
    private ISelection fForcedMarkOccurrencesSelection;
    private long fMarkOccurrenceModificationStamp = -1L;
    private IRegion fMarkOccurrenceTargetRegion;
    private ActivationListener fActivationListener = new ActivationListener();
    private ISelectionListenerWithAST fPostSelectionListenerWithAST;
    private OccurrencesFinderJob fOccurrencesFinderJob;
    private OccurrencesFinderJobCanceler fOccurrencesFinderJobCanceler;
    private ProjectionSupport fProjectionSupport;
    private IAsnFoldingStructureProvider fProjectionModelUpdater;
    private SemanticHighlightingManager fSemanticManager;
    private ToggleFoldingRunner fFoldingRunner;
    private boolean fSelectionChangedViaGotoAnnotation;

    protected abstract IAsnElement getElementAt(int var1);

    protected abstract IAsnElement getCorrespondingElement(IAsnElement var1);

    protected void setOutlinePageInput(AsnOutlinePage page, IEditorInput input) {
        if (page == null) {
            return;
        }
        IAsnElement je = this.getInputAsnElement();
        if (je != null && je.exists()) {
            page.setInput(je);
        } else {
            page.setInput(null);
        }
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.asnlab.asndt.ui.asnEditorScope"});
    }

    protected void initializeEditor() {
        IPreferenceStore store = this.createCombinedPreferenceStore(null);
        this.setPreferenceStore(store);
        AsnTextTools textTools = AsnPlugin.getDefault().getAsnTextTools();
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new AsnSourceViewerConfiguration(textTools.getColorManager(), store, (ITextEditor)this, "___asn_partitioning"));
        this.fMarkOccurrenceAnnotations = store.getBoolean("markOccurrences");
        this.fStickyOccurrenceAnnotations = store.getBoolean("stickyOccurrences");
        this.fMarkTypeOccurrences = store.getBoolean("markTypeOccurrences");
        this.fMarkValueOccurrences = store.getBoolean("markValueOccurrences");
        this.fMarkComponentOccurrences = store.getBoolean("markComponentOccurrences");
    }

    protected final ISourceViewer createSourceViewer(Composite parent, IVerticalRuler verticalRuler, int styles) {
        IPreferenceStore store = this.getPreferenceStore();
        ISourceViewer viewer = this.createAsnSourceViewer(parent, verticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles, store);
        AsnSourceViewer asnSourceViewer = null;
        if (viewer instanceof AsnSourceViewer) {
            asnSourceViewer = (AsnSourceViewer)viewer;
        }
        if (asnSourceViewer != null && this.isFoldingEnabled() && (store == null || !store.getBoolean("org.asnlab.asndt.ui.editor.showSegments"))) {
            asnSourceViewer.prepareDelayedProjection();
        }
        ProjectionViewer projectionViewer = (ProjectionViewer)viewer;
        this.fProjectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        this.fProjectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        this.fProjectionSupport.setHoverControlCreator(new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                return new SourceViewerInformationControl(shell, 0xC | AsnEditor.this.getOrientation(), 0);
            }
        });
        this.fProjectionSupport.install();
        this.fProjectionModelUpdater = AsnPlugin.getDefault().getFoldingStructureProviderRegistry().getCurrentFoldingProvider();
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.install((ITextEditor)this, projectionViewer);
        }
        this.getSourceViewerDecorationSupport(viewer);
        return viewer;
    }

    public final ISourceViewer getViewer() {
        return this.getSourceViewer();
    }

    protected ISourceViewer createAsnSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean isOverviewRulerVisible, int styles, IPreferenceStore store) {
        return new AsnSourceViewer(parent, verticalRuler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles, store);
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return ((AsnSourceViewerConfiguration)this.getSourceViewerConfiguration()).affectsTextPresentation(event) || super.affectsTextPresentation(event);
    }

    private IPreferenceStore createCombinedPreferenceStore(IEditorInput input) {
        ArrayList<IPreferenceStore> stores = new ArrayList<IPreferenceStore>(3);
        IAsnProject project = EditorUtility.getAsnProject(input);
        if (project != null) {
            stores.add(new EclipsePreferencesAdapter((IScopeContext)new ProjectScope(project.getProject()), "org.asnlab.asndt.core"));
        }
        stores.add(AsnPlugin.getDefault().getPreferenceStore());
        stores.add(new PreferencesAdapter(AsnCore.getPlugin().getPluginPreferences()));
        stores.add(EditorsUI.getPreferenceStore());
        return new ChainedPreferenceStore(stores.toArray(new IPreferenceStore[stores.size()]));
    }

    protected void setOutlinerContextMenuId(String menuId) {
        this.fOutlinerContextMenuId = menuId;
    }

    protected ActionGroup getActionGroup() {
        return this.fActionGroups;
    }

    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        menu.insertAfter("group.open", (IContributionItem)new GroupMarker("group.show"));
        ActionContext context = new ActionContext(this.getSelectionProvider().getSelection());
        this.fContextMenuGroup.setContext(context);
        this.fContextMenuGroup.fillContextMenu(menu);
        this.fContextMenuGroup.setContext(null);
        IAction action = this.getAction("org.asnlab.asndt.ui.edit.text.asn.show.outline");
        menu.appendToGroup("group.open", action);
    }

    protected AsnOutlinePage createOutlinePage() {
        AsnOutlinePage page = new AsnOutlinePage(this.fOutlinerContextMenuId, this);
        this.fOutlineSelectionChangedListener.install((ISelectionProvider)page);
        this.setOutlinePageInput(page, this.getEditorInput());
        return page;
    }

    public void outlinePageClosed() {
        if (this.fOutlinePage != null) {
            this.fOutlineSelectionChangedListener.uninstall((ISelectionProvider)this.fOutlinePage);
            this.fOutlinePage = null;
            this.resetHighlightRange();
        }
    }

    protected void synchronizeOutlinePage(ISourceReference element) {
        this.synchronizeOutlinePage(element, true);
    }

    protected void synchronizeOutlinePage(ISourceReference element, boolean checkIfOutlinePageActive) {
        if (!(this.fOutlinePage == null || element == null || checkIfOutlinePageActive && this.isAsnOutlinePageActive())) {
            this.fOutlineSelectionChangedListener.uninstall((ISelectionProvider)this.fOutlinePage);
            this.fOutlinePage.select(element);
            this.fOutlineSelectionChangedListener.install((ISelectionProvider)this.fOutlinePage);
        }
    }

    public void synchronizeOutlinePageSelection() {
        this.synchronizeOutlinePage(this.computeHighlightRangeSourceReference());
    }

    protected IStatusLineManager getStatusLineManager() {
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return null;
    }

    public Object getAdapter(Class required) {
        Object adapter;
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = this.createOutlinePage();
            }
            return this.fOutlinePage;
        }
        if (IEncodingSupport.class.equals((Object)required)) {
            return this.fEncodingSupport;
        }
        if (required == IShowInTargetList.class) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.asnlab.asndt.ui.PackageExplorer", "org.eclipse.ui.views.ContentOutline", "org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        if (required == IShowInSource.class) {
            IAsnElement je = null;
            try {
                je = SelectionConverter.getElementAtOffset(this);
            }
            catch (AsnModelException asnModelException) {
                je = null;
            }
            if (je != null) {
                StructuredSelection selection = new StructuredSelection((Object)je);
                return new IShowInSource((ISelection)selection){
                    private final /* synthetic */ ISelection val$selection;
                    {
                        this.val$selection = iSelection;
                    }

                    public ShowInContext getShowInContext() {
                        return new ShowInContext((Object)AsnEditor.this.getEditorInput(), this.val$selection);
                    }
                };
            }
        }
        if (required == IAsnFoldingStructureProvider.class) {
            return this.fProjectionModelUpdater;
        }
        if (this.fProjectionSupport != null && (adapter = this.fProjectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
            return adapter;
        }
        return super.getAdapter(required);
    }

    protected void selectionChanged() {
        if (this.getSelectionProvider() == null) {
            return;
        }
        ISourceReference element = this.computeHighlightRangeSourceReference();
        if (this.getPreferenceStore().getBoolean("AsnEditor.SyncOutlineOnCursorMove")) {
            this.synchronizeOutlinePage(element);
        }
        this.setSelection(element, false);
        if (!this.fSelectionChangedViaGotoAnnotation) {
            this.updateStatusLine();
        }
        this.fSelectionChangedViaGotoAnnotation = false;
    }

    protected void setSelection(ISourceReference reference, boolean moveCursor) {
        block18: {
            if (this.getSelectionProvider() == null) {
                return;
            }
            ISelection selection = this.getSelectionProvider().getSelection();
            if (selection instanceof TextSelection) {
                TextSelection textSelection = (TextSelection)selection;
                if (moveCursor && (textSelection.getOffset() != 0 || textSelection.getLength() != 0)) {
                    this.markInNavigationHistory();
                }
            }
            if (reference != null) {
                StyledText textWidget = null;
                ISourceViewer sourceViewer = this.getSourceViewer();
                if (sourceViewer != null) {
                    textWidget = sourceViewer.getTextWidget();
                }
                if (textWidget == null) {
                    return;
                }
                try {
                    ISourceRange range = reference.getSourceRange();
                    if (range == null) {
                        return;
                    }
                    int offset = range.getOffset();
                    int length = range.getLength();
                    if (offset < 0 || length < 0) {
                        return;
                    }
                    this.setHighlightRange(offset, length, moveCursor);
                    if (!moveCursor) {
                        return;
                    }
                    offset = -1;
                    length = -1;
                    if (reference instanceof IMember && (range = ((IMember)reference).getNameRange()) != null) {
                        offset = range.getOffset();
                        length = range.getLength();
                    }
                    if (offset <= -1 || length <= 0) break block18;
                    try {
                        textWidget.setRedraw(false);
                        sourceViewer.revealRange(offset, length);
                        sourceViewer.setSelectedRange(offset, length);
                    }
                    finally {
                        textWidget.setRedraw(true);
                    }
                    this.markInNavigationHistory();
                }
                catch (AsnModelException asnModelException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else if (moveCursor) {
                this.resetHighlightRange();
                this.markInNavigationHistory();
            }
        }
    }

    public void setSelection(IAsnElement element) {
        if (element == null || element instanceof ICompilationUnit) {
            return;
        }
        IAsnElement corresponding = this.getCorrespondingElement(element);
        if (corresponding instanceof ISourceReference) {
            ISourceReference reference = (ISourceReference)corresponding;
            this.setSelection(reference, true);
            if (this.fOutlinePage != null) {
                this.fOutlineSelectionChangedListener.uninstall((ISelectionProvider)this.fOutlinePage);
                this.fOutlinePage.select(reference);
                this.fOutlineSelectionChangedListener.install((ISelectionProvider)this.fOutlinePage);
            }
        }
    }

    protected void doSelectionChanged(SelectionChangedEvent event) {
        ISourceReference reference = null;
        ISelection selection = event.getSelection();
        for (Object o : (IStructuredSelection)selection) {
            if (!(o instanceof ISourceReference)) continue;
            reference = (ISourceReference)o;
            break;
        }
        if (!this.isActivePart() && AsnPlugin.getActivePage() != null) {
            AsnPlugin.getActivePage().bringToTop((IWorkbenchPart)this);
        }
        this.setSelection(reference, !this.isActivePart());
        ISelectionProvider selectionProvider = this.getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        ISelection textSelection = selectionProvider.getSelection();
        if (!(textSelection instanceof ITextSelection)) {
            return;
        }
        CompilationUnitDeclaration ast = AsnPlugin.getDefault().getASTProvider().getAST(this.getInputAsnElement(), ASTProvider.WAIT_ACTIVE_ONLY, this.getProgressMonitor());
        if (ast != null) {
            this.fForcedMarkOccurrencesSelection = textSelection;
            this.updateOccurrenceAnnotations((ITextSelection)textSelection, ast);
        }
    }

    protected void adjustHighlightRange(int offset, int length) {
        try {
            IAsnElement element = this.getElementAt(offset);
            while (element instanceof ISourceReference) {
                ISourceRange range = ((ISourceReference)element).getSourceRange();
                if (offset < range.getOffset() + range.getLength() && range.getOffset() < offset + length) {
                    ISourceViewer viewer = this.getSourceViewer();
                    if (viewer instanceof ITextViewerExtension5) {
                        ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                        extension.exposeModelRange((IRegion)new Region(range.getOffset(), range.getLength()));
                    }
                    this.setHighlightRange(range.getOffset(), range.getLength(), true);
                    if (this.fOutlinePage != null) {
                        this.fOutlineSelectionChangedListener.uninstall((ISelectionProvider)this.fOutlinePage);
                        this.fOutlinePage.select((ISourceReference)element);
                        this.fOutlineSelectionChangedListener.install((ISelectionProvider)this.fOutlinePage);
                    }
                    return;
                }
                element = element.getParent();
            }
        }
        catch (AsnModelException x) {
            AsnPlugin.log(x.getStatus());
        }
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            extension.exposeModelRange((IRegion)new Region(offset, length));
        } else {
            this.resetHighlightRange();
        }
    }

    protected boolean isActivePart() {
        IWorkbenchPart part = this.getActivePart();
        return part != null && part.equals(this);
    }

    private boolean isAsnOutlinePageActive() {
        IWorkbenchPart part = this.getActivePart();
        return part instanceof ContentOutline && ((ContentOutline)part).getCurrentPage() == this.fOutlinePage;
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IPartService service = window.getPartService();
        IWorkbenchPart part = service.getActivePart();
        return part;
    }

    protected String getStatusHeader(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusHeader(status)) != null) {
            return message;
        }
        return super.getStatusHeader(status);
    }

    protected String getStatusBanner(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusBanner(status)) != null) {
            return message;
        }
        return super.getStatusBanner(status);
    }

    protected String getStatusMessage(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusMessage(status)) != null) {
            return message;
        }
        return super.getStatusMessage(status);
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (!(sourceViewer instanceof ISourceViewerExtension2)) {
            this.setPreferenceStore(this.createCombinedPreferenceStore(input));
            this.internalDoSetInput(input);
            return;
        }
        this.getSourceViewerDecorationSupport(sourceViewer).uninstall();
        ((ISourceViewerExtension2)sourceViewer).unconfigure();
        this.setPreferenceStore(this.createCombinedPreferenceStore(input));
        sourceViewer.configure(this.getSourceViewerConfiguration());
        this.getSourceViewerDecorationSupport(sourceViewer).install(this.getPreferenceStore());
        this.internalDoSetInput(input);
    }

    private void internalDoSetInput(IEditorInput input) throws CoreException {
        IReconciler reconciler;
        ISourceViewer sourceViewer = this.getSourceViewer();
        AsnSourceViewer asnSourceViewer = null;
        if (sourceViewer instanceof AsnSourceViewer) {
            asnSourceViewer = (AsnSourceViewer)sourceViewer;
        }
        IPreferenceStore store = this.getPreferenceStore();
        if (asnSourceViewer != null && this.isFoldingEnabled() && (store == null || !store.getBoolean("org.asnlab.asndt.ui.editor.showSegments"))) {
            asnSourceViewer.prepareDelayedProjection();
        }
        super.doSetInput(input);
        if (asnSourceViewer != null && asnSourceViewer.getReconciler() == null && (reconciler = this.getSourceViewerConfiguration().getReconciler((ISourceViewer)asnSourceViewer)) != null) {
            reconciler.install((ITextViewer)asnSourceViewer);
            asnSourceViewer.setReconciler(reconciler);
        }
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.reset();
        }
        this.setOutlinePageInput(this.fOutlinePage, input);
    }

    protected void setPreferenceStore(IPreferenceStore store) {
        super.setPreferenceStore(store);
        if (this.getSourceViewerConfiguration() instanceof AsnSourceViewerConfiguration) {
            AsnTextTools textTools = AsnPlugin.getDefault().getAsnTextTools();
            this.setSourceViewerConfiguration((SourceViewerConfiguration)new AsnSourceViewerConfiguration(textTools.getColorManager(), store, (ITextEditor)this, "___asn_partitioning"));
        }
        if (this.getSourceViewer() instanceof AsnSourceViewer) {
            ((AsnSourceViewer)this.getSourceViewer()).setPreferenceStore(store);
        }
    }

    public void dispose() {
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.uninstall();
            this.fProjectionModelUpdater = null;
        }
        if (this.fProjectionSupport != null) {
            this.fProjectionSupport.dispose();
            this.fProjectionSupport = null;
        }
        this.fMarkOccurrenceAnnotations = false;
        this.uninstallOccurrencesFinder();
        this.uninstallSemanticHighlighting();
        if (this.fActivationListener != null) {
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this.fActivationListener);
            this.fActivationListener = null;
        }
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.dispose();
            this.fEncodingSupport = null;
        }
        if (this.fBracketMatcher != null) {
            this.fBracketMatcher.dispose();
            this.fBracketMatcher = null;
        }
        if (this.fSelectionHistory != null) {
            this.fSelectionHistory.dispose();
            this.fSelectionHistory = null;
        }
        if (this.fEditorSelectionChangedListener != null) {
            this.fEditorSelectionChangedListener.uninstall(this.getSelectionProvider());
            this.fEditorSelectionChangedListener = null;
        }
        super.dispose();
    }

    protected void createActions() {
        this.installEncodingSupport();
        super.createActions();
        ActionGroup[] actionGroupArray = new ActionGroup[3];
        OpenEditorActionGroup oeg = new OpenEditorActionGroup(this);
        actionGroupArray[0] = oeg;
        OpenViewActionGroup ovg = new OpenViewActionGroup(this);
        actionGroupArray[1] = ovg;
        AsnSearchActionGroup jsg = new AsnSearchActionGroup(this);
        actionGroupArray[2] = jsg;
        this.fActionGroups = new CompositeActionGroup(actionGroupArray);
        this.fContextMenuGroup = new CompositeActionGroup(new ActionGroup[]{oeg, ovg, jsg});
        this.fFoldingGroup = new FoldingActionGroup((ITextEditor)this, (ITextViewer)this.getViewer());
        Object resAction = new TextOperationAction(AsnEditorMessages.getBundleForConstructedKeys(), "ShowAsnDoc.", (ITextEditor)this, 16, true);
        resAction = new InformationDispatchAction(AsnEditorMessages.getBundleForConstructedKeys(), "ShowAsnDoc.", (TextOperationAction)resAction);
        resAction.setActionDefinitionId("org.asnlab.asndt.ui.edit.text.asn.show.asndoc");
        this.setAction("ShowAsnDoc", (IAction)resAction);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)resAction, "org.asnlab.asndt.ui.show_asndoc_action");
        Action action = new GotoMatchingBracketAction(this);
        action.setActionDefinitionId("org.asnlab.asndt.ui.edit.text.asn.goto.matching.bracket");
        this.setAction("GotoMatchingBracket", (IAction)action);
        action = new TextOperationAction(AsnEditorMessages.getBundleForConstructedKeys(), "ShowOutline.", (ITextEditor)this, 51, true);
        action.setActionDefinitionId("org.asnlab.asndt.ui.edit.text.asn.show.outline");
        this.setAction("org.asnlab.asndt.ui.edit.text.asn.show.outline", (IAction)action);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.asnlab.asndt.ui.show_outline_action");
        action = new TextOperationAction(AsnEditorMessages.getBundleForConstructedKeys(), "OpenStructure.", (ITextEditor)this, 52, true);
        action.setActionDefinitionId("org.asnlab.asndt.ui.navigate.asn.open.structure");
        this.setAction("org.asnlab.asndt.ui.navigate.asn.open.structure", (IAction)action);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.asnlab.asndt.ui.open_structure_action");
        this.fSelectionHistory = new SelectionHistory(this);
        action = new StructureSelectEnclosingAction(this, this.fSelectionHistory);
        action.setActionDefinitionId("org.asnlab.asndt.ui.edit.text.asn.select.enclosing");
        this.setAction("SelectEnclosingElement", (IAction)action);
        action = new StructureSelectNextAction(this, this.fSelectionHistory);
        action.setActionDefinitionId("org.asnlab.asndt.ui.edit.text.asn.select.next");
        this.setAction("SelectNextElement", (IAction)action);
        action = new StructureSelectPreviousAction(this, this.fSelectionHistory);
        action.setActionDefinitionId("org.asnlab.asndt.ui.edit.text.asn.select.previous");
        this.setAction("SelectPreviousElement", (IAction)action);
        StructureSelectHistoryAction historyAction = new StructureSelectHistoryAction(this, this.fSelectionHistory);
        historyAction.setActionDefinitionId("org.asnlab.asndt.ui.edit.text.asn.select.last");
        this.setAction("RestoreLastSelection", (IAction)historyAction);
        this.fSelectionHistory.setHistoryAction(historyAction);
        action = GoToNextPreviousMemberAction.newGoToNextMemberAction(this);
        action.setActionDefinitionId("org.asnlab.asndt.ui.edit.text.asn.goto.next.member");
        this.setAction("GoToNextMember", (IAction)action);
        action = GoToNextPreviousMemberAction.newGoToPreviousMemberAction(this);
        action.setActionDefinitionId("org.asnlab.asndt.ui.edit.text.asn.goto.previous.member");
        this.setAction("GoToPreviousMember", (IAction)action);
        action = new FormatElementAction();
        action.setActionDefinitionId("org.asnlab.asndt.ui.edit.text.asn.quick.format");
        this.setAction("QuickFormat", (IAction)action);
        this.markAsStateDependentAction("QuickFormat", true);
        action = new RemoveOccurrenceAnnotations(this);
        action.setActionDefinitionId("org.asnlab.asndt.ui.edit.text.remove.occurrence.annotations");
        this.setAction("RemoveOccurrenceAnnotations", (IAction)action);
    }

    protected void installEncodingSupport() {
        this.fEncodingSupport = new DefaultEncodingSupport();
        this.fEncodingSupport.initialize((StatusTextEditor)this);
    }

    public void updatedTitleImage(Image image) {
        this.setTitleImage(image);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("tabWidth".equals(property)) {
            return;
        }
        try {
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            if (this.isAsnEditorHoverProperty(property)) {
                this.updateHoverBehavior();
            }
            boolean newBooleanValue = false;
            Object newValue = event.getNewValue();
            if (newValue != null) {
                newBooleanValue = Boolean.valueOf(newValue.toString());
            }
            if ("AsnEditor.SyncOutlineOnCursorMove".equals(property)) {
                if (newBooleanValue) {
                    this.selectionChanged();
                }
                return;
            }
            if ("markOccurrences".equals(property)) {
                if (newBooleanValue != this.fMarkOccurrenceAnnotations) {
                    this.fMarkOccurrenceAnnotations = newBooleanValue;
                    if (!this.fMarkOccurrenceAnnotations) {
                        this.uninstallOccurrencesFinder();
                    } else {
                        this.installOccurrencesFinder(true);
                    }
                }
                return;
            }
            if ("markTypeOccurrences".equals(property)) {
                this.fMarkTypeOccurrences = newBooleanValue;
                return;
            }
            if ("markValueOccurrences".equals(property)) {
                this.fMarkValueOccurrences = newBooleanValue;
                return;
            }
            if ("markComponentOccurrences".equals(property)) {
                this.fMarkComponentOccurrences = newBooleanValue;
                return;
            }
            if ("stickyOccurrences".equals(property)) {
                this.fStickyOccurrenceAnnotations = newBooleanValue;
                return;
            }
            if (SemanticHighlightings.affectsEnablement(this.getPreferenceStore(), event)) {
                if (this.isSemanticHighlightingEnabled()) {
                    this.installSemanticHighlighting();
                } else {
                    this.uninstallSemanticHighlighting();
                }
                return;
            }
            ((AsnSourceViewerConfiguration)this.getSourceViewerConfiguration()).handlePropertyChangeEvent(event);
            if ("editor_folding_provider".equals(property)) {
                if (sourceViewer instanceof ProjectionViewer) {
                    ProjectionViewer projectionViewer = (ProjectionViewer)sourceViewer;
                    if (this.fProjectionModelUpdater != null) {
                        this.fProjectionModelUpdater.uninstall();
                    }
                    this.fProjectionModelUpdater = AsnPlugin.getDefault().getFoldingStructureProviderRegistry().getCurrentFoldingProvider();
                    if (this.fProjectionModelUpdater != null) {
                        this.fProjectionModelUpdater.install((ITextEditor)this, projectionViewer);
                    }
                }
                return;
            }
            if ("editor_folding_enabled".equals(property)) {
                if (sourceViewer instanceof ProjectionViewer) {
                    new ToggleFoldingRunner().runWhenNextVisible();
                }
                return;
            }
            if ("editor_folding_anonymous_members_enabled".equals(property)) {
                this.fProjectionModelUpdater.initialize();
            }
        }
        finally {
            super.handlePreferenceStoreChanged(event);
        }
        if ("show_range_indicator".equals(property)) {
            Object newValue = event.getNewValue();
            ISourceViewer viewer = this.getSourceViewer();
            if (newValue != null && viewer != null && Boolean.valueOf(newValue.toString()).booleanValue()) {
                Point selection = viewer.getSelectedRange();
                this.adjustHighlightRange(selection.x, selection.y);
            }
        }
    }

    protected void initializeViewerColors(ISourceViewer viewer) {
    }

    private boolean isAsnEditorHoverProperty(String property) {
        return "hoverModifiers".equals(property);
    }

    protected void updatePropertyDependentActions() {
        super.updatePropertyDependentActions();
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.reset();
        }
    }

    private void updateHoverBehavior() {
        SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
        String[] types = configuration.getConfiguredContentTypes(this.getSourceViewer());
        int i = 0;
        while (i < types.length) {
            String t = types[i];
            ISourceViewer sourceViewer = this.getSourceViewer();
            if (sourceViewer instanceof ITextViewerExtension2) {
                ((ITextViewerExtension2)sourceViewer).removeTextHovers(t);
                int[] stateMasks = configuration.getConfiguredTextHoverStateMasks(this.getSourceViewer(), t);
                if (stateMasks != null) {
                    int j = 0;
                    while (j < stateMasks.length) {
                        int stateMask = stateMasks[j];
                        ITextHover textHover = configuration.getTextHover(sourceViewer, t, stateMask);
                        ((ITextViewerExtension2)sourceViewer).setTextHover(textHover, t, stateMask);
                        ++j;
                    }
                } else {
                    ITextHover textHover = configuration.getTextHover(sourceViewer, t);
                    ((ITextViewerExtension2)sourceViewer).setTextHover(textHover, t, 255);
                }
            } else {
                sourceViewer.setTextHover(configuration.getTextHover(sourceViewer, t), t);
            }
            ++i;
        }
    }

    public Object getViewPartInput() {
        return this.getEditorInput().getAdapter(IAsnElement.class);
    }

    protected void doSetSelection(ISelection selection) {
        super.doSetSelection(selection);
        this.synchronizeOutlinePageSelection();
    }

    boolean isFoldingEnabled() {
        return AsnPlugin.getDefault().getPreferenceStore().getBoolean("editor_folding_enabled");
    }

    public int getOrientation() {
        return 0x2000000;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IInformationControlCreator informationControlCreator = new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell shell) {
                boolean cutDown = false;
                int style = cutDown ? 0 : 768;
                return new DefaultInformationControl(shell, 20, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(cutDown));
            }
        };
        this.fInformationPresenter = new InformationPresenter(informationControlCreator);
        this.fInformationPresenter.setSizeConstraints(60, 10, true, true);
        this.fInformationPresenter.install((ITextViewer)this.getSourceViewer());
        this.fInformationPresenter.setDocumentPartitioning("___asn_partitioning");
        this.fEditorSelectionChangedListener = new EditorSelectionChangedListener();
        this.fEditorSelectionChangedListener.install(this.getSelectionProvider());
        if (this.fMarkOccurrenceAnnotations) {
            this.installOccurrencesFinder(false);
        }
        if (this.isSemanticHighlightingEnabled()) {
            this.installSemanticHighlighting();
        }
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this.fActivationListener);
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCharacterPairMatcher((ICharacterPairMatcher)this.fBracketMatcher);
        support.setMatchingCharacterPainterPreferenceKeys(MATCHING_BRACKETS, MATCHING_BRACKETS_COLOR);
        super.configureSourceViewerDecorationSupport(support);
    }

    private Object getLockObject(IAnnotationModel annotationModel) {
        Object lock;
        if (annotationModel instanceof ISynchronizable && (lock = ((ISynchronizable)annotationModel).getLockObject()) != null) {
            return lock;
        }
        return annotationModel;
    }

    protected void updateMarkerViews(Annotation annotation) {
        if (annotation instanceof IAsnAnnotation) {
            Iterator e = ((IAsnAnnotation)annotation).getOverlaidIterator();
            if (e != null) {
                while (e.hasNext()) {
                    Object o = e.next();
                    if (!(o instanceof MarkerAnnotation)) continue;
                    super.updateMarkerViews((Annotation)((MarkerAnnotation)o));
                    return;
                }
            }
            return;
        }
        super.updateMarkerViews(annotation);
    }

    protected void updateOccurrenceAnnotations(ITextSelection selection, CompilationUnitDeclaration astRoot) {
        OccurrencesFinder finder;
        String message;
        if (this.fOccurrencesFinderJob != null) {
            this.fOccurrencesFinderJob.cancel();
        }
        if (!this.fMarkOccurrenceAnnotations) {
            return;
        }
        if (astRoot == null || selection == null) {
            return;
        }
        IDocument document = this.getSourceViewer().getDocument();
        if (document == null) {
            return;
        }
        if (document instanceof IDocumentExtension4) {
            int offset = selection.getOffset();
            long currentModificationStamp = ((IDocumentExtension4)document).getModificationStamp();
            if (this.fMarkOccurrenceTargetRegion != null && currentModificationStamp == this.fMarkOccurrenceModificationStamp && this.fMarkOccurrenceTargetRegion.getOffset() <= offset && offset <= this.fMarkOccurrenceTargetRegion.getOffset() + this.fMarkOccurrenceTargetRegion.getLength()) {
                return;
            }
            this.fMarkOccurrenceTargetRegion = AsnWordFinder.findWord(document, offset);
            this.fMarkOccurrenceModificationStamp = currentModificationStamp;
        }
        List matches = null;
        ASTNode selectedNode = NodeFinder.perform((ASTNode)astRoot, selection.getOffset(), selection.getLength());
        if (matches == null && this.markOccurrencesOfType(selectedNode) && (message = (finder = new OccurrencesFinder(selectedNode)).initialize(astRoot, selectedNode)) == null) {
            matches = finder.perform();
        }
        if (matches == null || matches.size() == 0) {
            if (!this.fStickyOccurrenceAnnotations) {
                this.removeOccurrenceAnnotations();
            }
            return;
        }
        Position[] positions = new Position[matches.size()];
        int i = 0;
        for (ASTNode currentNode : matches) {
            positions[i++] = new Position(currentNode.getSourceStart(), currentNode.getSourceEnd() - currentNode.getSourceStart() + 1);
        }
        this.fOccurrencesFinderJob = new OccurrencesFinderJob(document, positions, (ISelection)selection);
        this.fOccurrencesFinderJob.run((IProgressMonitor)new NullProgressMonitor());
    }

    protected void installOccurrencesFinder(boolean forceUpdate) {
        this.fMarkOccurrenceAnnotations = true;
        this.fPostSelectionListenerWithAST = new ISelectionListenerWithAST(){

            public void selectionChanged(IEditorPart part, ITextSelection selection, CompilationUnitDeclaration astRoot) {
                AsnEditor.this.updateOccurrenceAnnotations(selection, astRoot);
            }
        };
        SelectionListenerWithASTManager.getDefault().addListener((ITextEditor)this, this.fPostSelectionListenerWithAST);
        if (forceUpdate && this.getSelectionProvider() != null) {
            this.fForcedMarkOccurrencesSelection = this.getSelectionProvider().getSelection();
            this.updateOccurrenceAnnotations((ITextSelection)this.fForcedMarkOccurrencesSelection, AsnPlugin.getDefault().getASTProvider().getAST(this.getInputAsnElement(), ASTProvider.WAIT_NO, this.getProgressMonitor()));
        }
        if (this.fOccurrencesFinderJobCanceler == null) {
            this.fOccurrencesFinderJobCanceler = new OccurrencesFinderJobCanceler();
            this.fOccurrencesFinderJobCanceler.install();
        }
    }

    protected void uninstallOccurrencesFinder() {
        this.fMarkOccurrenceAnnotations = false;
        if (this.fOccurrencesFinderJob != null) {
            this.fOccurrencesFinderJob.cancel();
            this.fOccurrencesFinderJob = null;
        }
        if (this.fOccurrencesFinderJobCanceler != null) {
            this.fOccurrencesFinderJobCanceler.uninstall();
            this.fOccurrencesFinderJobCanceler = null;
        }
        if (this.fPostSelectionListenerWithAST != null) {
            SelectionListenerWithASTManager.getDefault().removeListener((ITextEditor)this, this.fPostSelectionListenerWithAST);
            this.fPostSelectionListenerWithAST = null;
        }
        this.removeOccurrenceAnnotations();
    }

    protected boolean isMarkingOccurrences() {
        return this.fMarkOccurrenceAnnotations;
    }

    boolean markOccurrencesOfType(ASTNode node) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOccurrenceAnnotations() {
        this.fMarkOccurrenceModificationStamp = -1L;
        this.fMarkOccurrenceTargetRegion = null;
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null || this.fOccurrenceAnnotations == null) {
            return;
        }
        Object object = this.getLockObject(annotationModel);
        synchronized (object) {
            if (annotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.fOccurrenceAnnotations, null);
            } else {
                int i = 0;
                int length = this.fOccurrenceAnnotations.length;
                while (i < length) {
                    annotationModel.removeAnnotation(this.fOccurrenceAnnotations[i]);
                    ++i;
                }
            }
            this.fOccurrenceAnnotations = null;
        }
    }

    private boolean getBoolean(IPreferenceStore store, String key) {
        return key != null && store.getBoolean(key);
    }

    private boolean isSemanticHighlightingEnabled() {
        return SemanticHighlightings.isEnabled(this.getPreferenceStore());
    }

    private void installSemanticHighlighting() {
        if (this.fSemanticManager == null) {
            this.fSemanticManager = new SemanticHighlightingManager();
            this.fSemanticManager.install(this, (AsnSourceViewer)this.getSourceViewer(), AsnPlugin.getDefault().getAsnTextTools().getColorManager(), this.getPreferenceStore());
        }
    }

    private void uninstallSemanticHighlighting() {
        if (this.fSemanticManager != null) {
            this.fSemanticManager.uninstall();
            this.fSemanticManager = null;
        }
    }

    protected IAsnElement getInputAsnElement() {
        return EditorUtility.getEditorInputAsnElement((IEditorPart)this, false);
    }

    protected void updateStatusLine() {
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        Annotation annotation = this.getAnnotation(selection.getOffset(), selection.getLength());
        this.setStatusLineErrorMessage(null);
        this.setStatusLineMessage(null);
        if (annotation != null) {
            this.updateMarkerViews(annotation);
            if (annotation instanceof IAsnAnnotation && ((IAsnAnnotation)annotation).isProblem()) {
                this.setStatusLineMessage(annotation.getText());
            }
        }
    }

    public void gotoMatchingBracket() {
        IRegion region;
        ISourceViewer sourceViewer = this.getSourceViewer();
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        IRegion selection = this.getSignedSelection(sourceViewer);
        int selectionLength = Math.abs(selection.getLength());
        if (selectionLength > 1) {
            this.setStatusLineErrorMessage(AsnEditorMessages.GotoMatchingBracket_error_invalidSelection);
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int sourceCaretOffset = selection.getOffset() + selection.getLength();
        if (AsnEditor.isSurroundedByBrackets(document, sourceCaretOffset)) {
            sourceCaretOffset -= selection.getLength();
        }
        if ((region = this.fBracketMatcher.match(document, sourceCaretOffset)) == null) {
            this.setStatusLineErrorMessage(AsnEditorMessages.GotoMatchingBracket_error_noMatchingBracket);
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int offset = region.getOffset();
        int length = region.getLength();
        if (length < 1) {
            return;
        }
        int anchor = this.fBracketMatcher.getAnchor();
        int targetOffset = anchor == 0 ? offset + 1 : offset + length;
        boolean visible = false;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            visible = extension.modelOffset2WidgetOffset(targetOffset) > -1;
        } else {
            IRegion visibleRegion = sourceViewer.getVisibleRegion();
            boolean bl = visible = targetOffset >= visibleRegion.getOffset() && targetOffset <= visibleRegion.getOffset() + visibleRegion.getLength();
        }
        if (!visible) {
            this.setStatusLineErrorMessage(AsnEditorMessages.GotoMatchingBracket_error_bracketOutsideSelectedElement);
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        if (selection.getLength() < 0) {
            targetOffset -= selection.getLength();
        }
        sourceViewer.setSelectedRange(targetOffset, selection.getLength());
        sourceViewer.revealRange(targetOffset, selection.getLength());
    }

    protected IRegion getSignedSelection(ISourceViewer sourceViewer) {
        StyledText text = sourceViewer.getTextWidget();
        Point selection = text.getSelectionRange();
        if (text.getCaretOffset() == selection.x) {
            selection.x += selection.y;
            selection.y = -selection.y;
        }
        selection.x = AsnEditor.widgetOffset2ModelOffset((ISourceViewer)sourceViewer, (int)selection.x);
        return new Region(selection.x, selection.y);
    }

    private static boolean isBracket(char character) {
        int i = 0;
        while (i != BRACKETS.length) {
            if (character == BRACKETS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isSurroundedByBrackets(IDocument document, int offset) {
        if (offset == 0 || offset == document.getLength()) {
            return false;
        }
        try {
            return AsnEditor.isBracket(document.getChar(offset - 1)) && AsnEditor.isBracket(document.getChar(offset));
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected Annotation findAnnotation(int offset, int length, boolean forward, Position annotationPosition) {
        Annotation nextAnnotation = null;
        Position nextAnnotationPosition = null;
        Annotation containingAnnotation = null;
        Position containingAnnotationPosition = null;
        boolean currentAnnotation = false;
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        int endOfDocument = document.getLength();
        int distance = Integer.MAX_VALUE;
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        AsnAnnotationIterator e = new AsnAnnotationIterator(model, true, true);
        while (e.hasNext()) {
            Position p;
            Annotation a = (Annotation)e.next();
            if (a instanceof IAsnAnnotation && ((IAsnAnnotation)a).hasOverlay() || !this.isNavigationTarget(a) || (p = model.getPosition(a)) == null) continue;
            if (forward && p.offset == offset || !forward && p.offset + p.getLength() == offset + length) {
                if (containingAnnotation != null && (!forward || p.length < containingAnnotationPosition.length) && (forward || p.length < containingAnnotationPosition.length)) continue;
                containingAnnotation = a;
                containingAnnotationPosition = p;
                currentAnnotation = p.length == length;
                continue;
            }
            int currentDistance = 0;
            if (forward) {
                currentDistance = p.getOffset() - offset;
                if (currentDistance < 0) {
                    currentDistance = endOfDocument + currentDistance;
                }
                if (currentDistance >= distance && (currentDistance != distance || p.length >= nextAnnotationPosition.length)) continue;
                distance = currentDistance;
                nextAnnotation = a;
                nextAnnotationPosition = p;
                continue;
            }
            currentDistance = offset + length - (p.getOffset() + p.length);
            if (currentDistance < 0) {
                currentDistance = endOfDocument + currentDistance;
            }
            if (currentDistance >= distance && (currentDistance != distance || p.length >= nextAnnotationPosition.length)) continue;
            distance = currentDistance;
            nextAnnotation = a;
            nextAnnotationPosition = p;
        }
        if (!(containingAnnotationPosition == null || currentAnnotation && nextAnnotation != null)) {
            annotationPosition.setOffset(containingAnnotationPosition.getOffset());
            annotationPosition.setLength(containingAnnotationPosition.getLength());
            return containingAnnotation;
        }
        if (nextAnnotationPosition != null) {
            annotationPosition.setOffset(nextAnnotationPosition.getOffset());
            annotationPosition.setLength(nextAnnotationPosition.getLength());
        }
        return nextAnnotation;
    }

    private Annotation getAnnotation(int offset, int length) {
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        AsnAnnotationIterator e = new AsnAnnotationIterator(model, true, false);
        while (e.hasNext()) {
            Annotation a = (Annotation)e.next();
            Position p = model.getPosition(a);
            if (p == null || !p.overlapsWith(offset, length)) continue;
            return a;
        }
        return null;
    }

    public Annotation gotoAnnotation(boolean forward) {
        this.fSelectionChangedViaGotoAnnotation = true;
        return super.gotoAnnotation(forward);
    }

    protected ISourceReference computeHighlightRangeSourceReference() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return null;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return null;
        }
        int caret = 0;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            caret = extension.widgetOffset2ModelOffset(styledText.getCaretOffset());
        } else {
            int offset = sourceViewer.getVisibleRegion().getOffset();
            caret = offset + styledText.getCaretOffset();
        }
        IAsnElement element = this.getElementAt(caret, false);
        if (!(element instanceof ISourceReference)) {
            return null;
        }
        if (element.getElementType() == 19) {
            ISymbolsFromModule declaration = (ISymbolsFromModule)element;
            IImportContainer container = (IImportContainer)declaration.getParent();
            ISourceRange srcRange = null;
            try {
                srcRange = container.getSourceRange();
            }
            catch (AsnModelException asnModelException) {}
            if (srcRange != null && srcRange.getOffset() == caret) {
                return container;
            }
        }
        return (ISourceReference)element;
    }

    protected IAsnElement getElementAt(int offset, boolean reconcile) {
        return this.getElementAt(offset);
    }

    protected LineChangeHover createChangeHover() {
        return new AsnChangeHover("___asn_partitioning", this.getOrientation());
    }

    protected boolean isPrefQuickDiffAlwaysOn() {
        return false;
    }

    protected void createNavigationActions() {
        super.createNavigationActions();
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        Object action = new SmartLineStartAction(textWidget, false);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.lineStart");
        this.setAction("org.eclipse.ui.edit.text.goto.lineStart", (IAction)action);
        action = new SmartLineStartAction(textWidget, true);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.lineStart");
        this.setAction("org.eclipse.ui.edit.text.select.lineStart", (IAction)action);
        action = new NavigatePreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.goto.wordPrevious", (IAction)action);
        textWidget.setKeyBinding(17039363, 0);
        action = new NavigateNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.wordNext");
        this.setAction("org.eclipse.ui.edit.text.goto.wordNext", (IAction)action);
        textWidget.setKeyBinding(0x1040004, 0);
        action = new SelectPreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordPrevious");
        this.setAction("org.eclipse.ui.edit.text.select.wordPrevious", (IAction)action);
        textWidget.setKeyBinding(17170435, 0);
        action = new SelectNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.select.wordNext");
        this.setAction("org.eclipse.ui.edit.text.select.wordNext", (IAction)action);
        textWidget.setKeyBinding(17170436, 0);
    }

    protected IVerticalRulerColumn createAnnotationRulerColumn(CompositeRuler ruler) {
        if (!this.getPreferenceStore().getBoolean("editor_annotation_roll_over")) {
            return super.createAnnotationRulerColumn(ruler);
        }
        AnnotationRulerColumn column = new AnnotationRulerColumn(12, this.getAnnotationAccess());
        column.setHover((IAnnotationHover)new AsnExpandHover(ruler, this.getAnnotationAccess(), new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                this.triggerAction("RulerDoubleClick");
            }

            private void triggerAction(String actionID) {
                IAction action = AsnEditor.this.getAction(actionID);
                if (action != null) {
                    if (action instanceof IUpdate) {
                        ((IUpdate)action).update();
                    }
                    if (action instanceof ISelectionListener) {
                        ((ISelectionListener)action).selectionChanged(null, null);
                    }
                    if (action.isEnabled()) {
                        action.run();
                    }
                }
            }
        }));
        return column;
    }

    protected FoldingActionGroup getFoldingActionGroup() {
        return this.fFoldingGroup;
    }

    protected void performRevert() {
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        projectionViewer.setRedraw(false);
        try {
            boolean projectionMode = projectionViewer.isProjectionMode();
            if (projectionMode) {
                projectionViewer.disableProjection();
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.uninstall();
                }
            }
            super.performRevert();
            if (projectionMode) {
                if (this.fProjectionModelUpdater != null) {
                    this.fProjectionModelUpdater.install((ITextEditor)this, projectionViewer);
                }
                projectionViewer.enableProjection();
            }
        }
        finally {
            projectionViewer.setRedraw(true);
        }
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        super.rulerContextMenuAboutToShow(menu);
        MenuManager foldingMenu = new MenuManager(AsnEditorMessages.Editor_FoldingMenu_name, "projection");
        menu.appendToGroup("rulers", (IContributionItem)foldingMenu);
        IAction action = this.getAction("FoldingToggle");
        foldingMenu.add(action);
        action = this.getAction("FoldingExpandAll");
        foldingMenu.add(action);
        action = this.getAction("FoldingCollapseAll");
        foldingMenu.add(action);
        action = this.getAction("FoldingRestore");
        foldingMenu.add(action);
        action = this.getAction("FoldingCollapseMembers");
        foldingMenu.add(action);
        action = this.getAction("FoldingCollapseComments");
        foldingMenu.add(action);
    }

    protected String[] collectContextMenuPreferencePages() {
        String[] ids = super.collectContextMenuPreferencePages();
        String[] more = new String[ids.length + 9];
        more[0] = "org.asnlab.asndt.ui.preferences.AsnEditorPreferencePage";
        more[1] = "org.asnlab.asndt.ui.preferences.AsnTemplatePreferencePage";
        more[2] = "org.asnlab.asndt.ui.preferences.CodeAssistPreferencePage";
        more[3] = "org.asnlab.asndt.ui.preferences.AsnEditorHoverPreferencePage";
        more[4] = "org.asnlab.asndt.ui.preferences.AsnEditorColoringPreferencePage";
        more[5] = "org.asnlab.asndt.ui.preferences.FoldingPreferencePage";
        more[6] = "org.asnlab.asndt.ui.preferences.MarkOccurrencesPreferencePage";
        more[7] = "org.asnlab.asndt.ui.preferences.SmartTypingPreferencePage";
        more[8] = "org.asnlab.asndt.ui.preferences.LinkedModePreferencePage";
        System.arraycopy(ids, 0, more, 9, ids.length);
        return more;
    }

    protected IOperationApprover getUndoRedoOperationApprover(IUndoContext undoContext) {
        return new NonLocalUndoUserApprover(undoContext, (IEditorPart)this, new Object[]{this.getInputAsnElement()}, IResource.class);
    }

    public void resetProjection() {
        if (this.fProjectionModelUpdater != null) {
            this.fProjectionModelUpdater.initialize();
        }
    }

    public void collapseMembers() {
        if (this.fProjectionModelUpdater instanceof IAsnFoldingStructureProviderExtension) {
            IAsnFoldingStructureProviderExtension extension = (IAsnFoldingStructureProviderExtension)((Object)this.fProjectionModelUpdater);
            extension.collapseMembers();
        }
    }

    public void collapseComments() {
        if (this.fProjectionModelUpdater instanceof IAsnFoldingStructureProviderExtension) {
            IAsnFoldingStructureProviderExtension extension = (IAsnFoldingStructureProviderExtension)((Object)this.fProjectionModelUpdater);
            extension.collapseComments();
        }
    }

    protected abstract class AbstractSelectionChangedListener
    implements ISelectionChangedListener {
        protected AbstractSelectionChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    }

    private class ActivationListener
    implements IWindowListener {
        private ActivationListener() {
        }

        public void windowActivated(IWorkbenchWindow window) {
            if (window == AsnEditor.this.getEditorSite().getWorkbenchWindow() && AsnEditor.this.fMarkOccurrenceAnnotations && AsnEditor.this.isActivePart()) {
                AsnEditor.this.fForcedMarkOccurrencesSelection = AsnEditor.this.getSelectionProvider().getSelection();
                AsnEditor.this.updateOccurrenceAnnotations((ITextSelection)AsnEditor.this.fForcedMarkOccurrencesSelection, AsnPlugin.getDefault().getASTProvider().getAST(AsnEditor.this.getInputAsnElement(), ASTProvider.WAIT_NO, AsnEditor.this.getProgressMonitor()));
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
            if (window == AsnEditor.this.getEditorSite().getWorkbenchWindow() && AsnEditor.this.fMarkOccurrenceAnnotations && AsnEditor.this.isActivePart()) {
                AsnEditor.this.removeOccurrenceAnnotations();
            }
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }

    protected class DeleteNextSubWordAction
    extends NextSubWordAction
    implements IUpdate {
        public DeleteNextSubWordAction() {
            super(262271);
        }

        protected void setCaretPosition(int position) {
            int length;
            int caret;
            if (!AsnEditor.this.validateEditorInputState()) {
                return;
            }
            ISourceViewer viewer = AsnEditor.this.getSourceViewer();
            Point selection = viewer.getSelectedRange();
            if (selection.y != 0) {
                caret = selection.x;
                length = selection.y;
            } else {
                caret = AsnEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)viewer.getTextWidget().getCaretOffset());
                length = position - caret;
            }
            try {
                viewer.getDocument().replace(caret, length, "");
            }
            catch (BadLocationException badLocationException) {}
        }

        protected int findNextPosition(int position) {
            return this.fIterator.following(position);
        }

        public void update() {
            this.setEnabled(AsnEditor.this.isEditorInputModifiable());
        }
    }

    protected class DeletePreviousSubWordAction
    extends PreviousSubWordAction
    implements IUpdate {
        public DeletePreviousSubWordAction() {
            super(262152);
        }

        protected void setCaretPosition(int position) {
            int length;
            if (!AsnEditor.this.validateEditorInputState()) {
                return;
            }
            ISourceViewer viewer = AsnEditor.this.getSourceViewer();
            Point selection = viewer.getSelectedRange();
            if (selection.y != 0) {
                position = selection.x;
                length = selection.y;
            } else {
                length = AsnEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)viewer.getTextWidget().getCaretOffset()) - position;
            }
            try {
                viewer.getDocument().replace(position, length, "");
            }
            catch (BadLocationException badLocationException) {}
        }

        protected int findPreviousPosition(int position) {
            return this.fIterator.preceding(position);
        }

        public void update() {
            this.setEnabled(AsnEditor.this.isEditorInputModifiable());
        }
    }

    private static class EclipsePreferencesAdapter
    implements IPreferenceStore {
        private ListenerList fListeners = new ListenerList(1);
        private IEclipsePreferences.IPreferenceChangeListener fListener = new PreferenceChangeListener();
        private final IScopeContext fContext;
        private final String fQualifier;

        public EclipsePreferencesAdapter(IScopeContext context, String qualifier) {
            this.fContext = context;
            this.fQualifier = qualifier;
        }

        private IEclipsePreferences getNode() {
            return this.fContext.getNode(this.fQualifier);
        }

        public void addPropertyChangeListener(IPropertyChangeListener listener) {
            if (this.fListeners.size() == 0) {
                this.getNode().addPreferenceChangeListener(this.fListener);
            }
            this.fListeners.add((Object)listener);
        }

        public void removePropertyChangeListener(IPropertyChangeListener listener) {
            this.fListeners.remove((Object)listener);
            if (this.fListeners.size() == 0) {
                this.getNode().removePreferenceChangeListener(this.fListener);
            }
        }

        public boolean contains(String name) {
            return this.getNode().get(name, null) != null;
        }

        public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IPropertyChangeListener)listeners[i]).propertyChange(event);
                ++i;
            }
        }

        public boolean getBoolean(String name) {
            return this.getNode().getBoolean(name, false);
        }

        public boolean getDefaultBoolean(String name) {
            return false;
        }

        public double getDefaultDouble(String name) {
            return 0.0;
        }

        public float getDefaultFloat(String name) {
            return 0.0f;
        }

        public int getDefaultInt(String name) {
            return 0;
        }

        public long getDefaultLong(String name) {
            return 0L;
        }

        public String getDefaultString(String name) {
            return "";
        }

        public double getDouble(String name) {
            return this.getNode().getDouble(name, 0.0);
        }

        public float getFloat(String name) {
            return this.getNode().getFloat(name, 0.0f);
        }

        public int getInt(String name) {
            return this.getNode().getInt(name, 0);
        }

        public long getLong(String name) {
            return this.getNode().getLong(name, 0L);
        }

        public String getString(String name) {
            return this.getNode().get(name, "");
        }

        public boolean isDefault(String name) {
            return false;
        }

        public boolean needsSaving() {
            try {
                return this.getNode().keys().length > 0;
            }
            catch (BackingStoreException backingStoreException) {
                return true;
            }
        }

        public void putValue(String name, String value) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String name, double value) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String name, float value) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String name, int value) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String name, long value) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String name, String defaultObject) {
            throw new UnsupportedOperationException();
        }

        public void setDefault(String name, boolean value) {
            throw new UnsupportedOperationException();
        }

        public void setToDefault(String name) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String name, double value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String name, float value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String name, int value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String name, long value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String name, String value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String name, boolean value) {
            throw new UnsupportedOperationException();
        }

        private class PreferenceChangeListener
        implements IEclipsePreferences.IPreferenceChangeListener {
            private PreferenceChangeListener() {
            }

            public void preferenceChange(final IEclipsePreferences.PreferenceChangeEvent event) {
                if (Display.getCurrent() == null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            EclipsePreferencesAdapter.this.firePropertyChangeEvent(event.getKey(), event.getOldValue(), event.getNewValue());
                        }
                    });
                } else {
                    EclipsePreferencesAdapter.this.firePropertyChangeEvent(event.getKey(), event.getOldValue(), event.getNewValue());
                }
            }
        }
    }

    private class EditorSelectionChangedListener
    extends AbstractSelectionChangedListener {
        private EditorSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            AsnEditor.this.selectionChanged();
        }
    }

    protected class FormatElementAction
    extends Action
    implements IUpdate {
        FormatElementAction() {
            this.setEnabled(AsnEditor.this.isEditorInputModifiable());
        }

        public void run() {
            block10: {
                AsnSourceViewer viewer = (AsnSourceViewer)AsnEditor.this.getSourceViewer();
                if (viewer.isEditable()) {
                    Point selection = viewer.rememberSelection();
                    try {
                        try {
                            viewer.setRedraw(false);
                            String type = TextUtilities.getContentType((IDocument)viewer.getDocument(), (String)"___asn_partitioning", (int)selection.x, (boolean)true);
                            if (type.equals("__dftl_partition_content_type") && selection.y == 0) {
                                try {
                                    ISourceReference reference;
                                    ISourceRange range;
                                    int kind;
                                    IAsnElement element = AsnEditor.this.getElementAt(selection.x, true);
                                    if (element != null && element.exists() && ((kind = element.getElementType()) == 10 || kind == 11) && (range = (reference = (ISourceReference)element).getSourceRange()) != null) {
                                        viewer.setSelectedRange(range.getOffset(), range.getLength());
                                        viewer.doOperation(15);
                                    }
                                    break block10;
                                }
                                catch (AsnModelException asnModelException) {}
                                break block10;
                            }
                            viewer.setSelectedRange(selection.x, 1);
                            viewer.doOperation(15);
                        }
                        catch (BadLocationException badLocationException) {
                            viewer.setRedraw(true);
                            viewer.restoreSelection();
                        }
                    }
                    finally {
                        viewer.setRedraw(true);
                        viewer.restoreSelection();
                    }
                }
            }
        }

        public void update() {
            this.setEnabled(AsnEditor.this.isEditorInputModifiable());
        }
    }

    class InformationDispatchAction
    extends TextEditorAction {
        private final TextOperationAction fTextOperationAction;

        public InformationDispatchAction(ResourceBundle resourceBundle, String prefix, TextOperationAction textOperationAction) {
            super(resourceBundle, prefix, (ITextEditor)AsnEditor.this);
            if (textOperationAction == null) {
                throw new IllegalArgumentException();
            }
            this.fTextOperationAction = textOperationAction;
        }

        public void run() {
            IAnnotationHover annotationHover;
            ITextHover textHover;
            ITextViewerExtension4 extension4;
            ISourceViewer sourceViewer = AsnEditor.this.getSourceViewer();
            if (sourceViewer == null) {
                this.fTextOperationAction.run();
                return;
            }
            if (sourceViewer instanceof ITextViewerExtension4 && (extension4 = (ITextViewerExtension4)sourceViewer).moveFocusToWidgetToken()) {
                return;
            }
            if (sourceViewer instanceof ITextViewerExtension2 && (textHover = ((ITextViewerExtension2)sourceViewer).getCurrentTextHover()) != null && this.makeTextHoverFocusable(sourceViewer, textHover)) {
                return;
            }
            if (sourceViewer instanceof ISourceViewerExtension3 && (annotationHover = ((ISourceViewerExtension3)sourceViewer).getCurrentAnnotationHover()) != null && this.makeAnnotationHoverFocusable(sourceViewer, annotationHover)) {
                return;
            }
            this.fTextOperationAction.run();
        }

        private boolean makeTextHoverFocusable(ISourceViewer sourceViewer, ITextHover textHover) {
            IRegion hoverRegion;
            int offset;
            block5: {
                Point hoverEventLocation = ((ITextViewerExtension2)sourceViewer).getHoverEventLocation();
                offset = this.computeOffsetAtLocation((ITextViewer)sourceViewer, hoverEventLocation.x, hoverEventLocation.y);
                if (offset == -1) {
                    return false;
                }
                try {
                    hoverRegion = textHover.getHoverRegion((ITextViewer)sourceViewer, offset);
                    if (hoverRegion != null) break block5;
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            String hoverInfo = textHover.getHoverInfo((ITextViewer)sourceViewer, hoverRegion);
            IInformationControlCreator controlCreator = null;
            if (textHover instanceof IInformationProviderExtension2) {
                controlCreator = ((IInformationProviderExtension2)textHover).getInformationPresenterControlCreator();
            }
            InformationProvider informationProvider = new InformationProvider(hoverRegion, hoverInfo, controlCreator);
            AsnEditor.this.fInformationPresenter.setOffset(offset);
            AsnEditor.this.fInformationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_BOTTOM);
            AsnEditor.this.fInformationPresenter.setMargins(6, 6);
            String contentType = TextUtilities.getContentType((IDocument)sourceViewer.getDocument(), (String)"___asn_partitioning", (int)offset, (boolean)true);
            AsnEditor.this.fInformationPresenter.setInformationProvider((IInformationProvider)informationProvider, contentType);
            AsnEditor.this.fInformationPresenter.showInformation();
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean makeAnnotationHoverFocusable(ISourceViewer sourceViewer, IAnnotationHover annotationHover) {
            IVerticalRuler info = AsnEditor.this.getVerticalRuler();
            int line = info.getLineOfLastMouseButtonActivity();
            if (line == -1) {
                return false;
            }
            try {
                Object hoverInfo;
                if (annotationHover instanceof IAnnotationHoverExtension) {
                    IAnnotationHoverExtension extension = (IAnnotationHoverExtension)annotationHover;
                    ILineRange hoverLineRange = extension.getHoverLineRange(sourceViewer, line);
                    if (hoverLineRange == null) {
                        return false;
                    }
                    hoverInfo = extension.getHoverInfo(sourceViewer, hoverLineRange, Integer.MAX_VALUE);
                } else {
                    hoverInfo = annotationHover.getHoverInfo(sourceViewer, line);
                }
                IDocument document = sourceViewer.getDocument();
                int offset = document.getLineOffset(line);
                String contentType = TextUtilities.getContentType((IDocument)document, (String)"___asn_partitioning", (int)offset, (boolean)true);
                IInformationControlCreator controlCreator = null;
                if ("org.eclipse.jface.text.source.projection.ProjectionAnnotationHover".equals(annotationHover.getClass().getName())) {
                    controlCreator = new IInformationControlCreator(){

                        public IInformationControl createInformationControl(Shell shell) {
                            int shellStyle = 0x14 | AsnEditor.this.getOrientation();
                            int style = 768;
                            return new SourceViewerInformationControl(shell, shellStyle, style);
                        }
                    };
                } else if (annotationHover instanceof IInformationProviderExtension2) {
                    controlCreator = ((IInformationProviderExtension2)annotationHover).getInformationPresenterControlCreator();
                } else if (annotationHover instanceof IAnnotationHoverExtension) {
                    controlCreator = ((IAnnotationHoverExtension)annotationHover).getHoverControlCreator();
                }
                InformationProvider informationProvider = new InformationProvider((IRegion)new Region(offset, 0), hoverInfo, controlCreator);
                AsnEditor.this.fInformationPresenter.setOffset(offset);
                AsnEditor.this.fInformationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_RIGHT);
                AsnEditor.this.fInformationPresenter.setMargins(4, 0);
                AsnEditor.this.fInformationPresenter.setInformationProvider((IInformationProvider)informationProvider, contentType);
                AsnEditor.this.fInformationPresenter.showInformation();
                return true;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }

        private int computeOffsetAtLocation(ITextViewer textViewer, int x, int y) {
            StyledText styledText = textViewer.getTextWidget();
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return -1;
            }
            try {
                int widgetOffset = styledText.getOffsetAtLocation(new Point(x, y));
                Point p = styledText.getLocationAtOffset(widgetOffset);
                if (p.x > x) {
                    --widgetOffset;
                }
                if (textViewer instanceof ITextViewerExtension5) {
                    ITextViewerExtension5 extension = (ITextViewerExtension5)textViewer;
                    return extension.widgetOffset2ModelOffset(widgetOffset);
                }
                IRegion visibleRegion = textViewer.getVisibleRegion();
                return widgetOffset + visibleRegion.getOffset();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
        }
    }

    private static final class InformationProvider
    implements IInformationProvider,
    IInformationProviderExtension,
    IInformationProviderExtension2 {
        private IRegion fHoverRegion;
        private Object fHoverInfo;
        private IInformationControlCreator fControlCreator;

        InformationProvider(IRegion hoverRegion, Object hoverInfo, IInformationControlCreator controlCreator) {
            this.fHoverRegion = hoverRegion;
            this.fHoverInfo = hoverInfo;
            this.fControlCreator = controlCreator;
        }

        public IRegion getSubject(ITextViewer textViewer, int invocationOffset) {
            return this.fHoverRegion;
        }

        public String getInformation(ITextViewer textViewer, IRegion subject) {
            return this.fHoverInfo.toString();
        }

        public Object getInformation2(ITextViewer textViewer, IRegion subject) {
            return this.fHoverInfo;
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return this.fControlCreator;
        }
    }

    protected class NavigateNextSubWordAction
    extends NextSubWordAction {
        public NavigateNextSubWordAction() {
            super(0x1040004);
        }

        protected void setCaretPosition(int position) {
            this.getTextWidget().setCaretOffset(AsnEditor.modelOffset2WidgetOffset((ISourceViewer)AsnEditor.this.getSourceViewer(), (int)position));
        }
    }

    protected class NavigatePreviousSubWordAction
    extends PreviousSubWordAction {
        public NavigatePreviousSubWordAction() {
            super(17039363);
        }

        protected void setCaretPosition(int position) {
            this.getTextWidget().setCaretOffset(AsnEditor.modelOffset2WidgetOffset((ISourceViewer)AsnEditor.this.getSourceViewer(), (int)position));
        }
    }

    protected abstract class NextSubWordAction
    extends TextNavigationAction {
        protected AsnWordIterator fIterator;

        protected NextSubWordAction(int code) {
            super(AsnEditor.this.getSourceViewer().getTextWidget(), code);
            this.fIterator = new AsnWordIterator();
        }

        public void run() {
            IPreferenceStore store = AsnEditor.this.getPreferenceStore();
            if (!store.getBoolean("subWordNavigation")) {
                super.run();
                return;
            }
            ISourceViewer viewer = AsnEditor.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            this.fIterator.setText(new DocumentCharacterIterator(document));
            int position = AsnEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)viewer.getTextWidget().getCaretOffset());
            if (position == -1) {
                return;
            }
            int next = this.findNextPosition(position);
            if (next != -1) {
                this.setCaretPosition(next);
                this.getTextWidget().showSelection();
                this.fireSelectionChanged();
            }
        }

        protected int findNextPosition(int position) {
            ISourceViewer viewer = AsnEditor.this.getSourceViewer();
            int widget = -1;
            while (position != -1 && widget == -1) {
                if ((position = this.fIterator.following(position)) == -1) continue;
                widget = AsnEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
            }
            return position;
        }

        protected abstract void setCaretPosition(int var1);
    }

    class OccurrencesFinderJob
    extends Job {
        private IDocument fDocument;
        private ISelection fSelection;
        private ISelectionValidator fPostSelectionValidator;
        private boolean fCanceled;
        private IProgressMonitor fProgressMonitor;
        private Position[] fPositions;

        public OccurrencesFinderJob(IDocument document, Position[] positions, ISelection selection) {
            super(AsnEditorMessages.AsnEditor_markOccurrences_job_name);
            this.fCanceled = false;
            this.fDocument = document;
            this.fSelection = selection;
            this.fPositions = positions;
            if (AsnEditor.this.getSelectionProvider() instanceof ISelectionValidator) {
                this.fPostSelectionValidator = (ISelectionValidator)AsnEditor.this.getSelectionProvider();
            }
        }

        void doCancel() {
            this.fCanceled = true;
            this.cancel();
        }

        private boolean isCanceled() {
            return this.fCanceled || this.fProgressMonitor.isCanceled() || this.fPostSelectionValidator != null && !this.fPostSelectionValidator.isValid(this.fSelection) && AsnEditor.this.fForcedMarkOccurrencesSelection != this.fSelection || LinkedModeModel.hasInstalledModel((IDocument)this.fDocument);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor progressMonitor) {
            this.fProgressMonitor = progressMonitor;
            if (this.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ISourceViewer textViewer = AsnEditor.this.getViewer();
            if (textViewer == null) {
                return Status.CANCEL_STATUS;
            }
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return Status.CANCEL_STATUS;
            }
            IDocumentProvider documentProvider = AsnEditor.this.getDocumentProvider();
            if (documentProvider == null) {
                return Status.CANCEL_STATUS;
            }
            IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)AsnEditor.this.getEditorInput());
            if (annotationModel == null) {
                return Status.CANCEL_STATUS;
            }
            int length = this.fPositions.length;
            HashMap<Annotation, Position> annotationMap = new HashMap<Annotation, Position>(length);
            int i = 0;
            while (i < length) {
                block16: {
                    String message;
                    if (this.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    Position position = this.fPositions[i];
                    try {
                        message = document.get(position.offset, position.length);
                    }
                    catch (BadLocationException badLocationException) {
                        break block16;
                    }
                    annotationMap.put(new Annotation("org.asnlab.asndt.ui.occurrences", false, message), position);
                }
                ++i;
            }
            if (this.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Object object = AsnEditor.this.getLockObject(annotationModel);
            synchronized (object) {
                if (annotationModel instanceof IAnnotationModelExtension) {
                    ((IAnnotationModelExtension)annotationModel).replaceAnnotations(AsnEditor.this.fOccurrenceAnnotations, annotationMap);
                } else {
                    AsnEditor.this.removeOccurrenceAnnotations();
                    for (Map.Entry mapEntry : annotationMap.entrySet()) {
                        annotationModel.addAnnotation((Annotation)mapEntry.getKey(), (Position)mapEntry.getValue());
                    }
                }
                AsnEditor.this.fOccurrenceAnnotations = annotationMap.keySet().toArray(new Annotation[annotationMap.keySet().size()]);
            }
            return Status.OK_STATUS;
        }
    }

    class OccurrencesFinderJobCanceler
    implements IDocumentListener,
    ITextInputListener {
        OccurrencesFinderJobCanceler() {
        }

        public void install() {
            ISourceViewer sourceViewer = AsnEditor.this.getSourceViewer();
            if (sourceViewer == null) {
                return;
            }
            StyledText text = sourceViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            sourceViewer.addTextInputListener((ITextInputListener)this);
            IDocument document = sourceViewer.getDocument();
            if (document != null) {
                document.addDocumentListener((IDocumentListener)this);
            }
        }

        public void uninstall() {
            IDocument document;
            IDocumentProvider documentProvider;
            ISourceViewer sourceViewer = AsnEditor.this.getSourceViewer();
            if (sourceViewer != null) {
                sourceViewer.removeTextInputListener((ITextInputListener)this);
            }
            if ((documentProvider = AsnEditor.this.getDocumentProvider()) != null && (document = documentProvider.getDocument((Object)AsnEditor.this.getEditorInput())) != null) {
                document.removeDocumentListener((IDocumentListener)this);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            if (AsnEditor.this.fOccurrencesFinderJob != null) {
                AsnEditor.this.fOccurrencesFinderJob.doCancel();
            }
        }

        public void documentChanged(DocumentEvent event) {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (oldInput == null) {
                return;
            }
            oldInput.removeDocumentListener((IDocumentListener)this);
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (newInput == null) {
                return;
            }
            newInput.addDocumentListener((IDocumentListener)this);
        }
    }

    class OutlineSelectionChangedListener
    extends AbstractSelectionChangedListener {
        OutlineSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            AsnEditor.this.doSelectionChanged(event);
        }
    }

    protected abstract class PreviousSubWordAction
    extends TextNavigationAction {
        protected AsnWordIterator fIterator;

        protected PreviousSubWordAction(int code) {
            super(AsnEditor.this.getSourceViewer().getTextWidget(), code);
            this.fIterator = new AsnWordIterator();
        }

        public void run() {
            IPreferenceStore store = AsnEditor.this.getPreferenceStore();
            if (!store.getBoolean("subWordNavigation")) {
                super.run();
                return;
            }
            ISourceViewer viewer = AsnEditor.this.getSourceViewer();
            IDocument document = viewer.getDocument();
            this.fIterator.setText(new DocumentCharacterIterator(document));
            int position = AsnEditor.widgetOffset2ModelOffset((ISourceViewer)viewer, (int)viewer.getTextWidget().getCaretOffset());
            if (position == -1) {
                return;
            }
            int previous = this.findPreviousPosition(position);
            if (previous != -1) {
                this.setCaretPosition(previous);
                this.getTextWidget().showSelection();
                this.fireSelectionChanged();
            }
        }

        protected int findPreviousPosition(int position) {
            ISourceViewer viewer = AsnEditor.this.getSourceViewer();
            int widget = -1;
            while (position != -1 && widget == -1) {
                if ((position = this.fIterator.preceding(position)) == -1) continue;
                widget = AsnEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
            }
            return position;
        }

        protected abstract void setCaretPosition(int var1);
    }

    protected class SelectNextSubWordAction
    extends NextSubWordAction {
        public SelectNextSubWordAction() {
            super(17170436);
        }

        protected void setCaretPosition(int position) {
            ISourceViewer viewer = AsnEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = AsnEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }

    protected class SelectPreviousSubWordAction
    extends PreviousSubWordAction {
        public SelectPreviousSubWordAction() {
            super(17170435);
        }

        protected void setCaretPosition(int position) {
            ISourceViewer viewer = AsnEditor.this.getSourceViewer();
            StyledText text = viewer.getTextWidget();
            if (text != null && !text.isDisposed()) {
                Point selection = text.getSelection();
                int caret = text.getCaretOffset();
                int offset = AsnEditor.modelOffset2WidgetOffset((ISourceViewer)viewer, (int)position);
                if (caret == selection.x) {
                    text.setSelectionRange(selection.y, offset - selection.y);
                } else {
                    text.setSelectionRange(selection.x, offset - selection.x);
                }
            }
        }
    }

    protected class SmartLineStartAction
    extends AbstractTextEditor.LineStartAction {
        public SmartLineStartAction(StyledText textWidget, boolean doSelect) {
            super((AbstractTextEditor)AsnEditor.this, textWidget, doSelect);
        }

        protected int getLineStartPosition(IDocument document, String line, int length, int offset) {
            String type = "__dftl_partition_content_type";
            try {
                type = TextUtilities.getContentType((IDocument)document, (String)"___asn_partitioning", (int)offset, (boolean)true);
            }
            catch (BadLocationException badLocationException) {}
            int index = super.getLineStartPosition(document, line, length, offset);
            if (type.equals("__asn_multiline_comment")) {
                if (index < length - 1 && line.charAt(index) == '*' && line.charAt(index + 1) != '/') {
                    while (++index < length && Character.isWhitespace(line.charAt(index))) {
                    }
                }
            } else if (index < length - 1 && line.charAt(index) == '/' && line.charAt(index + 1) == '/') {
                ++index;
                while (++index < length && Character.isWhitespace(line.charAt(index))) {
                }
            }
            return index;
        }
    }

    private final class ToggleFoldingRunner
    implements IPartListener2 {
        private IWorkbenchPage fPage;

        private ToggleFoldingRunner() {
        }

        private void toggleFolding() {
            ProjectionViewer pv;
            ISourceViewer sourceViewer = AsnEditor.this.getSourceViewer();
            if (sourceViewer instanceof ProjectionViewer && (pv = (ProjectionViewer)sourceViewer).isProjectionMode() != AsnEditor.this.isFoldingEnabled() && pv.canDoOperation(19)) {
                pv.doOperation(19);
            }
        }

        public void runWhenNextVisible() {
            IWorkbenchPage page;
            if (AsnEditor.this.fFoldingRunner != null) {
                AsnEditor.this.fFoldingRunner.cancel();
                return;
            }
            IWorkbenchPartSite site = AsnEditor.this.getSite();
            if (site != null && !(page = site.getPage()).isPartVisible((IWorkbenchPart)AsnEditor.this)) {
                this.fPage = page;
                AsnEditor.this.fFoldingRunner = this;
                page.addPartListener((IPartListener2)this);
                return;
            }
            this.toggleFolding();
        }

        private void cancel() {
            if (this.fPage != null) {
                this.fPage.removePartListener((IPartListener2)this);
                this.fPage = null;
            }
            if (AsnEditor.this.fFoldingRunner == this) {
                AsnEditor.this.fFoldingRunner = null;
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            if (AsnEditor.this.equals(partRef.getPart(false))) {
                this.cancel();
                this.toggleFolding();
            }
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (AsnEditor.this.equals(partRef.getPart(false))) {
                this.cancel();
            }
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    }
}

