/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.asneditor;

import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.AsnPluginImages;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditorMessages;
import org.asnlab.asndt.internal.ui.asneditor.CompilationUnitEditor;
import org.asnlab.asndt.internal.ui.asneditor.WorkingCopyManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class TogglePresentationAction
extends TextEditorAction
implements IPropertyChangeListener {
    private IPreferenceStore fStore;

    public TogglePresentationAction() {
        super(AsnEditorMessages.getBundleForConstructedKeys(), "TogglePresentation.", null, 2);
        AsnPluginImages.setToolImageDescriptors((IAction)this, "segment_edit.gif");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.asnlab.asndt.ui.toggle_presentation_action_context");
        this.update();
    }

    public void run() {
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        IRegion remembered = editor.getHighlightRange();
        editor.resetHighlightRange();
        boolean showAll = !editor.showsHighlightRangeOnly();
        this.setChecked(showAll);
        editor.showHighlightRangeOnly(showAll);
        if (remembered != null) {
            editor.setHighlightRange(remembered.getOffset(), remembered.getLength(), true);
        }
        this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
        this.fStore.setValue("org.asnlab.asndt.ui.editor.showSegments", showAll);
        this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void update() {
        ITextEditor editor = this.getTextEditor();
        boolean checked = editor != null && editor.showsHighlightRangeOnly();
        this.setChecked(checked);
        if (editor instanceof CompilationUnitEditor) {
            WorkingCopyManager manager = AsnPlugin.getDefault().getWorkingCopyManager();
            this.setEnabled(manager.getWorkingCopy(editor.getEditorInput()) != null);
        } else {
            this.setEnabled(editor != null);
        }
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        if (editor != null) {
            if (this.fStore == null) {
                this.fStore = AsnPlugin.getDefault().getPreferenceStore();
                this.fStore.addPropertyChangeListener((IPropertyChangeListener)this);
            }
            this.synchronizeWithPreference(editor);
        } else if (this.fStore != null) {
            this.fStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fStore = null;
        }
        this.update();
    }

    private void synchronizeWithPreference(ITextEditor editor) {
        if (editor == null) {
            return;
        }
        boolean showSegments = this.fStore.getBoolean("org.asnlab.asndt.ui.editor.showSegments");
        this.setChecked(showSegments);
        if (editor.showsHighlightRangeOnly() != showSegments) {
            IRegion remembered = editor.getHighlightRange();
            editor.resetHighlightRange();
            editor.showHighlightRangeOnly(showSegments);
            if (remembered != null) {
                editor.setHighlightRange(remembered.getOffset(), remembered.getLength(), true);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.asnlab.asndt.ui.editor.showSegments")) {
            this.synchronizeWithPreference(this.getTextEditor());
        }
    }
}

