/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.infoviews;

import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.ICodeAssist;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.internal.corext.util.AsnModelUtil;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditor;
import org.asnlab.asndt.internal.ui.asneditor.WorkingCopyManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorInput;

class TextSelectionConverter {
    private static final IAsnElement[] EMPTY_RESULT = new IAsnElement[0];

    private TextSelectionConverter() {
    }

    public static IAsnElement[] codeResolve(AsnEditor editor, ITextSelection selection) throws AsnModelException {
        return TextSelectionConverter.codeResolve(TextSelectionConverter.getInput(editor), selection);
    }

    public static IAsnElement getElementAtOffset(AsnEditor editor, ITextSelection selection) throws AsnModelException {
        return TextSelectionConverter.getElementAtOffset(TextSelectionConverter.getInput(editor), selection);
    }

    private static IAsnElement getInput(AsnEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput input = editor.getEditorInput();
        WorkingCopyManager manager = AsnPlugin.getDefault().getWorkingCopyManager();
        return manager.getWorkingCopy(input);
    }

    private static IAsnElement[] codeResolve(IAsnElement input, ITextSelection selection) throws AsnModelException {
        if (input instanceof ICodeAssist) {
            IAsnElement[] elements;
            ICompilationUnit cunit;
            if (input instanceof ICompilationUnit && (cunit = (ICompilationUnit)input).isWorkingCopy()) {
                AsnModelUtil.reconcile(cunit);
            }
            if ((elements = ((ICodeAssist)input).codeSelect(selection.getOffset())) != null && elements.length > 0) {
                return elements;
            }
        }
        return EMPTY_RESULT;
    }

    private static IAsnElement getElementAtOffset(IAsnElement input, ITextSelection selection) throws AsnModelException {
        if (input instanceof ICompilationUnit) {
            IAsnElement ref;
            ICompilationUnit cunit = (ICompilationUnit)input;
            if (cunit.isWorkingCopy()) {
                AsnModelUtil.reconcile(cunit);
            }
            if ((ref = cunit.getElementAt(selection.getOffset())) == null) {
                return input;
            }
            return ref;
        }
        return null;
    }
}

