/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.preferences.formatter;

import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.asnlab.asndt.internal.ui.preferences.formatter.AsnPreview;
import org.asnlab.asndt.internal.ui.preferences.formatter.CompilationUnitPreview;
import org.asnlab.asndt.internal.ui.preferences.formatter.FormatterMessages;
import org.asnlab.asndt.internal.ui.preferences.formatter.ModifyDialog;
import org.asnlab.asndt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class IndentationTabPage
extends ModifyDialogTabPage {
    private final String PREVIEW = String.valueOf(IndentationTabPage.createPreviewHeader(FormatterMessages.IndentationTabPage_preview_header)) + "Module1 DEFINITIONS ::= BEGIN\n" + "EXPORTS Type1, Type2, value1;" + "IMPORTS Type3, Type4 FROM Module2 { 1 2 3 4 5 5 };" + "Checkbox ::= BIT STRING {checkbox1(1), checkbox2(2)}" + "Selection ::= CHOICE {alternative1 NULL,alternative2 NULL}" + "Radio ::= ENUMERATED {radio1,radio2}" + "Number ::= INTEGER {one(1),two(2)}" + "Fruit ::= SEQUENCE {name VisibleString,price INTEGER}" + "apple Fruit ::= {name \"Apple\",price 9}" + "array SEQUENCE OF INTEGER ::= {1,2,3,4,5,6,7,8,9}" + "END";
    private CompilationUnitPreview fPreview;
    private String fOldTabChar = null;

    public IndentationTabPage(ModifyDialog modifyDialog, Map workingValues) {
        super(modifyDialog, workingValues);
    }

    protected void doCreatePreferences(Composite composite, int numColumns) {
        Group generalGroup = this.createGroup(numColumns, composite, FormatterMessages.IndentationTabPage_general_group_title);
        String[] tabPolicyValues = new String[]{"space", "tab", "mixed"};
        String[] tabPolicyLabels = new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_MIXED};
        ModifyDialogTabPage.ComboPreference tabPolicy = this.createComboPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_tab_policy, "org.asnlab.asndt.core.formatter.tabulation.char", tabPolicyValues, tabPolicyLabels);
        final ModifyDialogTabPage.CheckboxPreference onlyForLeading = this.createCheckboxPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_use_tabs_only_for_leading_indentations, "org.asnlab.asndt.core.formatter.use_tabs_only_for_leading_indentations", FALSE_TRUE);
        final ModifyDialogTabPage.NumberPreference indentSize = this.createNumberPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_indent_size, "org.asnlab.asndt.core.formatter.tabulation.size", 0, 32);
        final ModifyDialogTabPage.NumberPreference tabSize = this.createNumberPref((Composite)generalGroup, numColumns, FormatterMessages.IndentationTabPage_general_group_option_tab_size, "org.asnlab.asndt.core.formatter.tabulation.size", 0, 32);
        String tabchar = (String)this.fWorkingValues.get("org.asnlab.asndt.core.formatter.tabulation.char");
        this.updateTabPreferences(tabchar, tabSize, indentSize, onlyForLeading);
        tabPolicy.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                IndentationTabPage.this.updateTabPreferences((String)arg, tabSize, indentSize, onlyForLeading);
            }
        });
        tabSize.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                indentSize.updateWidget();
            }
        });
        Group typeMemberGroup = this.createGroup(numColumns, composite, FormatterMessages.IndentationTabPage_component_alignment_group_title);
        this.createCheckboxPref((Composite)typeMemberGroup, numColumns, FormatterMessages.IndentationTabPage_component_alignment_group_align_components_in_columns, "org.asnlab.asndt.core.formatter.align_components_in_columns", FALSE_TRUE);
        Group indentGroup = this.createGroup(numColumns, composite, FormatterMessages.IndentationTabPage_indent_group_title);
        this.createCheckboxPref((Composite)indentGroup, numColumns, FormatterMessages.IndentationTabPage_option_indent_assignments_within_module_definition, "org.asnlab.asndt.core.formatter.indent_assignments_within_module_definition", FALSE_TRUE);
        this.createCheckboxPref((Composite)indentGroup, numColumns, FormatterMessages.IndentationTabPage_option_indent_symbols_within_exports, "org.asnlab.asndt.core.formatter.indent_body_declarations_compare_to_enum_declaration_header", FALSE_TRUE);
        this.createCheckboxPref((Composite)indentGroup, numColumns, FormatterMessages.IndentationTabPage_option_indent_symbols_from_modules_within_imports, "org.asnlab.asndt.core.formatter.indent_symbols_from_modules_within_imports", FALSE_TRUE);
        this.createCheckboxPref((Composite)indentGroup, numColumns, FormatterMessages.IndentationTabPage_option_indent_named_bits_within_bit_strings, "org.asnlab.asndt.core.formatter_indent_named_bits_within_bit_strings", FALSE_TRUE);
        this.createCheckboxPref((Composite)indentGroup, numColumns, FormatterMessages.IndentationTabPage_option_indent_alternatives_within_choices, "org.asnlab.asndt.core.formatter_indent_alternatives_within_choices", FALSE_TRUE);
        this.createCheckboxPref((Composite)indentGroup, numColumns, FormatterMessages.IndentationTabPage_option_indent_enumerated_values_within_enumerateds, "org.asnlab.asndt.core.formatter_indent_enumerated_values_within_enumerateds", FALSE_TRUE);
        this.createCheckboxPref((Composite)indentGroup, numColumns, FormatterMessages.IndentationTabPage_option_indent_named_numbers_within_integers, "org.asnlab.asndt.core.formatter_indent_named_numbers_within_integers", FALSE_TRUE);
        this.createCheckboxPref((Composite)indentGroup, numColumns, FormatterMessages.IndentationTabPage_option_indent_component_types_within_sequence_sets, "org.asnlab.asndt.core.formatter_indent_component_types_within_sequence_sets", FALSE_TRUE);
        this.createCheckboxPref((Composite)indentGroup, numColumns, FormatterMessages.IndentationTabPage_option_indent_component_values_within_composite_values, "org.asnlab.asndt.core.formatter_indent_component_values_within_composite_values", FALSE_TRUE);
        this.createCheckboxPref((Composite)indentGroup, numColumns, FormatterMessages.IndentationTabPage_option_indent_values_within_sequence_of_set_of_values, "org.asnlab.asndt.core.formatter_indent_values_within_sequence_of_set_of_values", FALSE_TRUE);
    }

    public void initializePage() {
        this.fPreview.setPreviewText(this.PREVIEW);
    }

    protected AsnPreview doCreateAsnPreview(Composite parent) {
        this.fPreview = new CompilationUnitPreview(this.fWorkingValues, parent);
        return this.fPreview;
    }

    protected void doUpdatePreview() {
        this.fPreview.update();
    }

    private void updateTabPreferences(String tabPolicy, ModifyDialogTabPage.NumberPreference tabPreference, ModifyDialogTabPage.NumberPreference indentPreference, ModifyDialogTabPage.CheckboxPreference onlyForLeading) {
        if ("mixed".equals(tabPolicy)) {
            if ("space".equals(this.fOldTabChar) || "tab".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("org.asnlab.asndt.core.formatter.tabulation.size");
            indentPreference.setEnabled(true);
            indentPreference.setKey("org.asnlab.asndt.core.formatter.indentation.size");
            onlyForLeading.setEnabled(true);
        } else if ("space".equals(tabPolicy)) {
            if ("mixed".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("org.asnlab.asndt.core.formatter.indentation.size");
            indentPreference.setEnabled(true);
            indentPreference.setKey("org.asnlab.asndt.core.formatter.tabulation.size");
            onlyForLeading.setEnabled(false);
        } else if ("tab".equals(tabPolicy)) {
            if ("mixed".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            tabPreference.setEnabled(true);
            tabPreference.setKey("org.asnlab.asndt.core.formatter.tabulation.size");
            indentPreference.setEnabled(false);
            indentPreference.setKey("org.asnlab.asndt.core.formatter.tabulation.size");
            onlyForLeading.setEnabled(true);
        } else {
            Assert.isTrue((boolean)false);
        }
        this.fOldTabChar = tabPolicy;
    }

    private void swapTabValues() {
        Object tabSize = this.fWorkingValues.get("org.asnlab.asndt.core.formatter.tabulation.size");
        Object indentSize = this.fWorkingValues.get("org.asnlab.asndt.core.formatter.indentation.size");
        this.fWorkingValues.put("org.asnlab.asndt.core.formatter.tabulation.size", indentSize);
        this.fWorkingValues.put("org.asnlab.asndt.core.formatter.indentation.size", tabSize);
    }
}

