/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.preferences.formatter.AsnPreview;
import org.asnlab.asndt.internal.ui.preferences.formatter.CompilationUnitPreview;
import org.asnlab.asndt.internal.ui.preferences.formatter.FormatterMessages;
import org.asnlab.asndt.internal.ui.preferences.formatter.ModifyDialog;
import org.asnlab.asndt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.asnlab.asndt.internal.ui.preferences.formatter.WhiteSpaceOptions;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.PageBook;

public class WhiteSpaceTabPage
extends ModifyDialogTabPage {
    private final String PREVIEW = String.valueOf(WhiteSpaceTabPage.createPreviewHeader(FormatterMessages.IndentationTabPage_preview_header)) + "Module1 DEFINITIONS ::= BEGIN\n" + "EXPORTS Type1, Type2, value1;" + "IMPORTS Type3, Type4 FROM Module2 { 1 2 3 4 5 5 };" + "Selection ::= CHOICE {alternative1 [1] NULL,alternative2 [2] Module2.Type4}" + "selection Selection ::=alternative1:NULL " + "Fruit ::= SEQUENCE {name VisibleString,price INTEGER(MIN..<60)}" + "prices SEQUENCE OF INTEGER ::= { 1, 2, 3, 4, 5, 6, 7, 8, 9 }" + "END";
    private PageBook fPageBook;
    private final AsnElementComponent fAsnElementComponent;
    protected final IDialogSettings fDialogSettings = AsnPlugin.getDefault().getDialogSettings();
    private CompilationUnitPreview fPreview;

    public WhiteSpaceTabPage(ModifyDialog modifyDialog, Map workingValues) {
        super(modifyDialog, workingValues);
        this.fAsnElementComponent = new AsnElementComponent();
    }

    protected void doCreatePreferences(Composite composite, int numColumns) {
        this.fPageBook = new PageBook(composite, 0);
        this.fPageBook.setLayoutData((Object)WhiteSpaceTabPage.createGridData(numColumns, 1808, -1));
        this.fAsnElementComponent.createContents(numColumns, (Composite)this.fPageBook);
    }

    protected void initializePage() {
        this.fAsnElementComponent.initialize();
        this.fAsnElementComponent.refreshState();
        this.fPageBook.showPage(this.fAsnElementComponent.getControl());
        this.fPreview.setPreviewText(this.PREVIEW);
    }

    protected AsnPreview doCreateAsnPreview(Composite parent) {
        this.fPreview = new CompilationUnitPreview(this.fWorkingValues, parent);
        return this.fPreview;
    }

    protected void doUpdatePreview() {
        this.fPreview.update();
    }

    private final class AsnElementComponent
    implements ISelectionChangedListener,
    ICheckStateListener {
        private final String PREF_INNER_INDEX = "org.asnlab.asndt.uiformatter_page.white_space.asn_view.inner";
        private final String PREF_OPTION_INDEX = "org.asnlab.asndt.uiformatter_page.white_space.asn_view.option";
        private final ArrayList fIndexedNodeList = new ArrayList();
        private final ArrayList fTree;
        private WhiteSpaceOptions.InnerNode fLastSelected;
        private TreeViewer fInnerViewer;
        private CheckboxTableViewer fOptionsViewer;
        private Composite fComposite;

        public AsnElementComponent() {
            this.fTree = WhiteSpaceOptions.createTree(WhiteSpaceTabPage.this.fWorkingValues);
            WhiteSpaceOptions.makeIndexForNodes(this.fTree, this.fIndexedNodeList);
        }

        public void createContents(int numColumns, Composite parent) {
            this.fComposite = new Composite(parent, 0);
            this.fComposite.setLayoutData((Object)WhiteSpaceTabPage.createGridData(numColumns, 256, -1));
            this.fComposite.setLayout((Layout)WhiteSpaceTabPage.this.createGridLayout(numColumns, false));
            WhiteSpaceTabPage.createLabel(numColumns, this.fComposite, FormatterMessages.WhiteSpaceTabPage_insert_space, 32);
            SashForm sashForm = new SashForm(this.fComposite, 512);
            sashForm.setLayoutData((Object)WhiteSpaceTabPage.createGridData(numColumns, 1808, -1));
            this.fInnerViewer = new TreeViewer((Composite)sashForm, 2564);
            this.fInnerViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return ((Collection)inputElement).toArray();
                }

                public Object[] getChildren(Object parentElement) {
                    List children = ((WhiteSpaceOptions.Node)parentElement).getChildren();
                    ArrayList innerChildren = new ArrayList();
                    for (Object o : children) {
                        if (!(o instanceof WhiteSpaceOptions.InnerNode)) continue;
                        innerChildren.add(o);
                    }
                    return innerChildren.toArray();
                }

                public Object getParent(Object element) {
                    if (element instanceof WhiteSpaceOptions.InnerNode) {
                        return ((WhiteSpaceOptions.InnerNode)element).getParent();
                    }
                    return null;
                }

                public boolean hasChildren(Object element) {
                    List children = ((WhiteSpaceOptions.Node)element).getChildren();
                    Iterator iter = children.iterator();
                    while (iter.hasNext()) {
                        if (!(iter.next() instanceof WhiteSpaceOptions.InnerNode)) continue;
                        return true;
                    }
                    return false;
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }
            });
            this.fInnerViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            GridData innerGd = WhiteSpaceTabPage.createGridData(numColumns, 1296, -1);
            innerGd.heightHint = WhiteSpaceTabPage.this.fPixelConverter.convertHeightInCharsToPixels(3);
            this.fInnerViewer.getControl().setLayoutData((Object)innerGd);
            this.fOptionsViewer = CheckboxTableViewer.newCheckList((Composite)sashForm, (int)2308);
            this.fOptionsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.fOptionsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            GridData optionsGd = WhiteSpaceTabPage.createGridData(numColumns, 1296, -1);
            optionsGd.heightHint = WhiteSpaceTabPage.this.fPixelConverter.convertHeightInCharsToPixels(3);
            this.fOptionsViewer.getControl().setLayoutData((Object)optionsGd);
            WhiteSpaceTabPage.this.fDefaultFocusManager.add(this.fInnerViewer.getControl());
            WhiteSpaceTabPage.this.fDefaultFocusManager.add(this.fOptionsViewer.getControl());
            this.fInnerViewer.setInput((Object)this.fTree);
        }

        public void refreshState() {
            if (this.fLastSelected != null) {
                this.innerViewerChanged(this.fLastSelected);
            }
        }

        public void initialize() {
            this.fInnerViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.fOptionsViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this.fOptionsViewer.addCheckStateListener((ICheckStateListener)this);
            this.restoreSelections();
            this.refreshState();
        }

        private void restoreSelections() {
            int optionIndex;
            int innerIndex = this.getValidatedIndex("org.asnlab.asndt.uiformatter_page.white_space.asn_view.inner");
            WhiteSpaceOptions.Node node = (WhiteSpaceOptions.Node)this.fIndexedNodeList.get(innerIndex);
            if (node instanceof WhiteSpaceOptions.InnerNode) {
                this.fInnerViewer.expandToLevel((Object)node, 0);
                this.fInnerViewer.setSelection((ISelection)new StructuredSelection(new Object[]{node}));
                this.fLastSelected = (WhiteSpaceOptions.InnerNode)node;
            }
            if ((node = (WhiteSpaceOptions.Node)this.fIndexedNodeList.get(optionIndex = this.getValidatedIndex("org.asnlab.asndt.uiformatter_page.white_space.asn_view.option"))) instanceof WhiteSpaceOptions.OptionNode) {
                this.fOptionsViewer.setSelection((ISelection)new StructuredSelection(new Object[]{node}));
            }
        }

        private int getValidatedIndex(String key) {
            int index;
            try {
                index = WhiteSpaceTabPage.this.fDialogSettings.getInt(key);
            }
            catch (NumberFormatException numberFormatException) {
                index = 0;
            }
            if (index < 0 || index > this.fIndexedNodeList.size() - 1) {
                index = 0;
            }
            return index;
        }

        public Control getControl() {
            return this.fComposite;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.isEmpty() || !(selection.getFirstElement() instanceof WhiteSpaceOptions.Node)) {
                return;
            }
            WhiteSpaceOptions.Node selected = (WhiteSpaceOptions.Node)selection.getFirstElement();
            if (selected == null || selected == this.fLastSelected) {
                return;
            }
            if (event.getSource() == this.fInnerViewer && selected instanceof WhiteSpaceOptions.InnerNode) {
                this.fLastSelected = (WhiteSpaceOptions.InnerNode)selected;
                WhiteSpaceTabPage.this.fDialogSettings.put("org.asnlab.asndt.uiformatter_page.white_space.asn_view.inner", selected.index);
                this.innerViewerChanged((WhiteSpaceOptions.InnerNode)selected);
            } else if (event.getSource() == this.fOptionsViewer && selected instanceof WhiteSpaceOptions.OptionNode) {
                WhiteSpaceTabPage.this.fDialogSettings.put("org.asnlab.asndt.uiformatter_page.white_space.asn_view.option", selected.index);
            }
        }

        private void innerViewerChanged(WhiteSpaceOptions.InnerNode selectedNode) {
            List children = selectedNode.getChildren();
            ArrayList optionsChildren = new ArrayList();
            for (Object o : children) {
                if (!(o instanceof WhiteSpaceOptions.OptionNode)) continue;
                optionsChildren.add(o);
            }
            this.fOptionsViewer.setInput((Object)optionsChildren.toArray());
            for (WhiteSpaceOptions.OptionNode child : optionsChildren) {
                this.fOptionsViewer.setChecked((Object)child, child.getChecked());
            }
            WhiteSpaceTabPage.this.doUpdatePreview();
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            WhiteSpaceOptions.OptionNode option = (WhiteSpaceOptions.OptionNode)event.getElement();
            if (option != null) {
                option.setChecked(event.getChecked());
            }
            WhiteSpaceTabPage.this.doUpdatePreview();
            WhiteSpaceTabPage.this.notifyValuesModified();
        }
    }
}

