/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text.asn;

import org.asnlab.asndt.internal.ui.text.AsnPairMatcher;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;

public class AsnDoubleClickSelector
implements ITextDoubleClickStrategy {
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']', '<', '>'};
    protected AsnPairMatcher fPairMatcher = new AsnPairMatcher(BRACKETS);

    public void doubleClicked(ITextViewer textViewer) {
        int offset = textViewer.getSelectedRange().x;
        if (offset < 0) {
            return;
        }
        IDocument document = textViewer.getDocument();
        IRegion region = this.fPairMatcher.match(document, offset);
        if (region != null && region.getLength() >= 2) {
            textViewer.setSelectedRange(region.getOffset() + 1, region.getLength() - 2);
        } else {
            region = this.selectWord(document, offset);
            textViewer.setSelectedRange(region.getOffset(), region.getLength());
        }
    }

    protected IRegion selectWord(IDocument document, int anchor) {
        int fStart = anchor;
        int fEnd = anchor;
        try {
            char c;
            int max = document.getLength();
            int offset = anchor;
            while (offset >= 0) {
                c = document.getChar(offset);
                if (!this.isValidCharInAsnWord(c)) break;
                --offset;
            }
            fStart = offset == anchor ? anchor : offset + 1;
            offset = anchor;
            while (offset < max) {
                c = document.getChar(offset);
                if (!this.isValidCharInAsnWord(c)) break;
                ++offset;
            }
            fEnd = offset;
        }
        catch (BadLocationException badLocationException) {
            return new Region(anchor, 0);
        }
        return new Region(fStart, fEnd - fStart);
    }

    public boolean isValidCharInAsnWord(char c) {
        return Character.isJavaIdentifierPart(c) || c == '-';
    }
}

