/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text.template.contentassist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.internal.corext.template.asn.CompilationUnitContext;
import org.asnlab.asndt.internal.corext.template.asn.CompilationUnitContextType;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.AsnPluginImages;
import org.asnlab.asndt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Point;

public class TemplateEngine {
    private static final String $_LINE_SELECTION = "${line_selection}";
    private static final String $_WORD_SELECTION = "${word_selection}";
    private TemplateContextType fContextType;
    private ArrayList fProposals = new ArrayList();
    private final Map fPositions = new HashMap();

    public TemplateEngine(TemplateContextType contextType) {
        Assert.isNotNull((Object)contextType);
        this.fContextType = contextType;
    }

    public void reset() {
        this.fProposals.clear();
        for (Map.Entry entry : this.fPositions.entrySet()) {
            IDocument doc = (IDocument)entry.getKey();
            Position position = (Position)entry.getValue();
            doc.removePosition(position);
        }
        this.fPositions.clear();
    }

    public TemplateProposal[] getResults() {
        return this.fProposals.toArray(new TemplateProposal[this.fProposals.size()]);
    }

    public void complete(ITextViewer viewer, int completionPosition, ICompilationUnit compilationUnit) {
        IDocument document = viewer.getDocument();
        if (!(this.fContextType instanceof CompilationUnitContextType)) {
            return;
        }
        Point selection = viewer.getSelectedRange();
        Position position = new Position(completionPosition, selection.y);
        String selectedText = null;
        if (selection.y != 0) {
            try {
                selectedText = document.get(selection.x, selection.y);
                document.addPosition(position);
                this.fPositions.put(document, position);
            }
            catch (BadLocationException badLocationException) {}
        }
        CompilationUnitContext context = ((CompilationUnitContextType)this.fContextType).createContext(document, position, compilationUnit);
        context.setVariable("selection", selectedText);
        int start = context.getStart();
        int end = context.getEnd();
        Region region = new Region(start, end - start);
        Template[] templates = AsnPlugin.getDefault().getTemplateStore().getTemplates();
        if (selection.y == 0) {
            int i = 0;
            while (i != templates.length) {
                if (context.canEvaluate(templates[i])) {
                    this.fProposals.add(new TemplateProposal(templates[i], (TemplateContext)context, (IRegion)region, AsnPluginImages.get("org.asnlab.asndt.ui.template_obj.gif")));
                }
                ++i;
            }
        } else {
            if (context.getKey().length() == 0) {
                context.setForceEvaluation(true);
            }
            boolean multipleLinesSelected = this.areMultipleLinesSelected(viewer);
            int i = 0;
            while (i != templates.length) {
                Template template = templates[i];
                if (context.canEvaluate(template) && template.getContextTypeId().equals(context.getContextType().getId()) && (!multipleLinesSelected && template.getPattern().indexOf($_WORD_SELECTION) != -1 || multipleLinesSelected && template.getPattern().indexOf($_LINE_SELECTION) != -1)) {
                    this.fProposals.add(new TemplateProposal(templates[i], (TemplateContext)context, (IRegion)region, AsnPluginImages.get("org.asnlab.asndt.ui.template_obj.gif")));
                }
                ++i;
            }
        }
    }

    private boolean areMultipleLinesSelected(ITextViewer viewer) {
        if (viewer == null) {
            return false;
        }
        Point s = viewer.getSelectedRange();
        if (s.y == 0) {
            return false;
        }
        try {
            IDocument document = viewer.getDocument();
            int startLine = document.getLineOfOffset(s.x);
            int endLine = document.getLineOfOffset(s.x + s.y);
            IRegion line = document.getLineInformation(startLine);
            return startLine != endLine || s.x == line.getOffset() && s.y == line.getLength();
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }
}

