/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.viewsupport;

import org.asnlab.asndt.core.AsnCore;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.IMember;
import org.asnlab.asndt.core.ISymbol;
import org.asnlab.asndt.core.dom.FieldSpec;
import org.asnlab.asndt.core.dom.FixedTypeValueFieldSpec;
import org.asnlab.asndt.core.dom.FixedTypeValueSetFieldSpec;
import org.asnlab.asndt.core.dom.Name;
import org.asnlab.asndt.core.dom.ObjectFieldSpec;
import org.asnlab.asndt.core.dom.ObjectSetFieldSpec;
import org.asnlab.asndt.core.dom.TypeFieldSpec;
import org.asnlab.asndt.core.dom.VariableTypeValueFieldSpec;
import org.asnlab.asndt.core.dom.VariableTypeValueSetFieldSpec;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.AsnPluginImages;
import org.asnlab.asndt.internal.ui.AsnUIMessages;
import org.asnlab.asndt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.asnlab.asndt.ui.AsnElementImageDescriptor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class AsnElementImageProvider {
    public static final int OVERLAY_ICONS = 1;
    public static final int SMALL_ICONS = 2;
    public static final int LIGHT_TYPE_ICONS = 4;
    public static final Point SMALL_SIZE = new Point(16, 16);
    public static final Point BIG_SIZE = new Point(22, 16);
    private static ImageDescriptor DESC_OBJ_PROJECT_CLOSED;
    private static ImageDescriptor DESC_OBJ_PROJECT;
    private ImageDescriptorRegistry fRegistry;

    public AsnElementImageProvider() {
        ISharedImages images = AsnPlugin.getDefault().getWorkbench().getSharedImages();
        DESC_OBJ_PROJECT_CLOSED = images.getImageDescriptor("IMG_OBJ_PROJECT_CLOSED");
        DESC_OBJ_PROJECT = images.getImageDescriptor("IMG_OBJ_PROJECT");
        this.fRegistry = null;
    }

    public Image getImageLabel(Object element, int flags) {
        return this.getImageLabel(this.computeDescriptor(element, flags));
    }

    private Image getImageLabel(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return this.getRegistry().get(descriptor);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = AsnPlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    private ImageDescriptor computeDescriptor(Object element, int flags) {
        if (element instanceof IAsnElement) {
            return this.getAsnImageDescriptor((IAsnElement)element, flags);
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            if (AsnCore.isAsnLikeFileName((String)file.getName())) {
                return this.getCUResourceImageDescriptor(file, flags);
            }
            return this.getWorkbenchImageDescriptor((IAdaptable)file, flags);
        }
        if (element instanceof IAdaptable) {
            return this.getWorkbenchImageDescriptor((IAdaptable)element, flags);
        }
        return null;
    }

    private static boolean showOverlayIcons(int flags) {
        return (flags & 1) != 0;
    }

    private static boolean useSmallSize(int flags) {
        return (flags & 2) != 0;
    }

    private static boolean useLightIcons(int flags) {
        return (flags & 4) != 0;
    }

    public ImageDescriptor getCUResourceImageDescriptor(IFile file, int flags) {
        Point size = AsnElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new AsnElementImageDescriptor(AsnPluginImages.DESC_OBJS_CUNIT_RESOURCE, 0, size);
    }

    public ImageDescriptor getAsnImageDescriptor(IAsnElement element, int flags) {
        int adornmentFlags = this.computeAsnAdornmentFlags(element, flags);
        Point size = AsnElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new AsnElementImageDescriptor(this.getBaseImageDescriptor(element, flags), adornmentFlags, size);
    }

    public ImageDescriptor getWorkbenchImageDescriptor(IAdaptable adaptable, int flags) {
        IWorkbenchAdapter wbAdapter = (IWorkbenchAdapter)adaptable.getAdapter(IWorkbenchAdapter.class);
        if (wbAdapter == null) {
            return null;
        }
        ImageDescriptor descriptor = wbAdapter.getImageDescriptor((Object)adaptable);
        if (descriptor == null) {
            return null;
        }
        Point size = AsnElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new AsnElementImageDescriptor(descriptor, 0, size);
    }

    public ImageDescriptor getBaseImageDescriptor(IAsnElement element, int renderFlags) {
        switch (element.getElementType()) {
            case 1: {
                return AsnPluginImages.DESC_OBJS_ASN_MODEL;
            }
            case 2: {
                IAsnProject ap = (IAsnProject)element;
                if (ap.getProject().isOpen()) {
                    ImageDescriptor result;
                    IProject project = ap.getProject();
                    IWorkbenchAdapter adapter = (IWorkbenchAdapter)project.getAdapter(IWorkbenchAdapter.class);
                    if (adapter != null && (result = adapter.getImageDescriptor((Object)project)) != null) {
                        return result;
                    }
                    return DESC_OBJ_PROJECT;
                }
                return DESC_OBJ_PROJECT_CLOSED;
            }
            case 4: {
                return AsnPluginImages.DESC_OBJS_FOLDER;
            }
            case 5: {
                return AsnPluginImages.DESC_OBJS_CUNIT;
            }
            case 6: {
                return AsnPluginImages.DESC_OBJS_MOLDECL;
            }
            case 17: {
                return AsnPluginImages.DESC_OBJS_IMPCONT;
            }
            case 18: {
                return AsnPluginImages.DESC_OBJS_IMPCONT;
            }
            case 19: {
                return AsnPluginImages.DESC_OBJS_IMPDECL;
            }
            case 20: {
                ISymbol symbol = (ISymbol)element;
                Name name = (Name)symbol.getAst();
                if (name.isWord()) {
                    return AsnPluginImages.DESC_OBJS_CLASS;
                }
                if (name.isReference()) {
                    return AsnPluginImages.DESC_OBJS_TYPE;
                }
                return AsnPluginImages.DESC_OBJS_VALUE;
            }
            case 7: {
                return AsnPluginImages.DESC_OBJS_CLASS;
            }
            case 8: {
                return AsnPluginImages.DESC_OBJS_OBJECT;
            }
            case 9: {
                return AsnPluginImages.DESC_OBJS_OBJECT;
            }
            case 10: 
            case 12: {
                return AsnPluginImages.DESC_OBJS_TYPE;
            }
            case 11: {
                return AsnPluginImages.DESC_OBJS_VALUE;
            }
            case 13: {
                FieldSpec field = (FieldSpec)element.getAst();
                if (field instanceof FixedTypeValueFieldSpec) {
                    return AsnPluginImages.DESC_OBJS_VALUE;
                }
                if (field instanceof FixedTypeValueSetFieldSpec) {
                    return AsnPluginImages.DESC_OBJS_TYPE;
                }
                if (field instanceof ObjectFieldSpec) {
                    return AsnPluginImages.DESC_OBJS_OBJECT;
                }
                if (field instanceof ObjectSetFieldSpec) {
                    return AsnPluginImages.DESC_OBJS_OBJECT;
                }
                if (field instanceof VariableTypeValueFieldSpec) {
                    return AsnPluginImages.DESC_OBJS_VALUE;
                }
                if (field instanceof VariableTypeValueSetFieldSpec) {
                    return AsnPluginImages.DESC_OBJS_TYPE;
                }
                if (field instanceof TypeFieldSpec) {
                    return AsnPluginImages.DESC_OBJS_TYPE;
                }
            }
            case 15: 
            case 16: {
                return AsnPluginImages.DESC_OBJS_COMPONENT;
            }
        }
        Assert.isTrue((boolean)false, (String)AsnUIMessages.AsnImageLabelprovider_assert_wrongImage);
        return AsnPluginImages.DESC_OBJS_GHOST;
    }

    public void dispose() {
    }

    private int computeAsnAdornmentFlags(IAsnElement element, int renderFlags) {
        int flags = 0;
        if (AsnElementImageProvider.showOverlayIcons(renderFlags)) {
            boolean cfr_ignored_0 = element instanceof IMember;
        }
        return flags;
    }

    public static Image getDecoratedImage(ImageDescriptor baseImage, int adornments, Point size) {
        return AsnPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new AsnElementImageDescriptor(baseImage, adornments, size));
    }
}

