/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.ui.actions;

import java.util.ArrayList;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.AsnPluginImages;
import org.asnlab.asndt.internal.ui.actions.ActionMessages;
import org.asnlab.asndt.internal.ui.viewsupport.MemberFilter;
import org.asnlab.asndt.internal.ui.viewsupport.MemberFilterAction;
import org.asnlab.asndt.ui.PreferenceConstants;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionGroup;

public class MemberFilterActionGroup
extends ActionGroup {
    public static final int FILTER_EXPORTS_IMPORTS = 1;
    public static final int FILTER_CLASSES = 2;
    public static final int FILTER_OBJECTS = 4;
    public static final int FILTER_TYPES = 8;
    public static final int FILTER_VALUES = 16;
    public static final int FILTER_COMPONENTS = 32;
    public static final int ALL_FILTERS = 63;
    private static final String TAG_HIDE_EXPORTS_IMPORTS = "hideexportsimports";
    private static final String TAG_HIDE_CLASSES = "hideclasses";
    private static final String TAG_HIDE_OBJECTS = "hideobjects";
    private static final String TAG_HIDE_TYPES = "hidetypes";
    private static final String TAG_HIDE_VALUES = "hidevalues";
    private static final String TAG_HIDE_COMPONENTS = "hidecomponents";
    private MemberFilterAction[] fFilterActions;
    private MemberFilter fFilter;
    private StructuredViewer fViewer;
    private String fViewerId;
    private boolean fInViewMenu;

    public MemberFilterActionGroup(StructuredViewer viewer, String viewerId) {
        this(viewer, viewerId, false);
    }

    public MemberFilterActionGroup(StructuredViewer viewer, String viewerId, boolean inViewMenu) {
        this(viewer, viewerId, inViewMenu, 63);
    }

    public MemberFilterActionGroup(StructuredViewer viewer, String viewerId, boolean inViewMenu, int availableFilters) {
        MemberFilterAction hideFields;
        MemberFilterAction hideLocalTypes;
        String helpContext;
        String title;
        boolean filterEnabled;
        this.fViewer = viewer;
        this.fViewerId = viewerId;
        this.fInViewMenu = inViewMenu;
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        this.fFilter = new MemberFilter();
        ArrayList<MemberFilterAction> actions = new ArrayList<MemberFilterAction>(4);
        int filterProperty = 1;
        if (this.isSet(filterProperty, availableFilters)) {
            filterEnabled = store.getBoolean(this.getPreferenceKey(filterProperty));
            if (filterEnabled) {
                this.fFilter.addFilter(filterProperty);
            }
            title = ActionMessages.MemberFilterActionGroup_hide_exports_imports_label;
            helpContext = "org.asnlab.asndt.ui.filter_exports_imports_action";
            MemberFilterAction hideExportsAndImports = new MemberFilterAction(this, title, filterProperty, helpContext, filterEnabled);
            hideExportsAndImports.setDescription(ActionMessages.MemberFilterActionGroup_hide_exports_imports_description);
            hideExportsAndImports.setToolTipText(ActionMessages.MemberFilterActionGroup_hide_exports_imports_tooltip);
            AsnPluginImages.setLocalImageDescriptors((IAction)hideExportsAndImports, "exports_imports_co.gif");
            actions.add(hideExportsAndImports);
        }
        if (this.isSet(filterProperty = 2, availableFilters)) {
            filterEnabled = store.getBoolean(this.getPreferenceKey(filterProperty));
            if (filterEnabled) {
                this.fFilter.addFilter(filterProperty);
            }
            title = ActionMessages.MemberFilterActionGroup_hide_classes_label;
            helpContext = "org.asnlab.asndt.ui.filter_classes_action";
            hideLocalTypes = new MemberFilterAction(this, title, filterProperty, helpContext, filterEnabled);
            hideLocalTypes.setDescription(ActionMessages.MemberFilterActionGroup_hide_classes_description);
            hideLocalTypes.setToolTipText(ActionMessages.MemberFilterActionGroup_hide_classes_tooltip);
            AsnPluginImages.setLocalImageDescriptors((IAction)hideLocalTypes, "classes_co.gif");
            actions.add(hideLocalTypes);
        }
        if (this.isSet(filterProperty = 4, availableFilters)) {
            filterEnabled = store.getBoolean(this.getPreferenceKey(filterProperty));
            if (filterEnabled) {
                this.fFilter.addFilter(filterProperty);
            }
            title = ActionMessages.MemberFilterActionGroup_hide_objects_label;
            helpContext = "org.asnlab.asndt.ui.filter_objects_action";
            hideFields = new MemberFilterAction(this, title, filterProperty, helpContext, filterEnabled);
            hideFields.setDescription(ActionMessages.MemberFilterActionGroup_hide_objects_description);
            hideFields.setToolTipText(ActionMessages.MemberFilterActionGroup_hide_objects_tooltip);
            AsnPluginImages.setLocalImageDescriptors((IAction)hideFields, "objects_co.gif");
            actions.add(hideFields);
        }
        if (this.isSet(filterProperty = 8, availableFilters)) {
            filterEnabled = store.getBoolean(this.getPreferenceKey(filterProperty));
            if (filterEnabled) {
                this.fFilter.addFilter(filterProperty);
            }
            title = ActionMessages.MemberFilterActionGroup_hide_types_label;
            helpContext = "org.asnlab.asndt.ui.filter_types_action";
            hideLocalTypes = new MemberFilterAction(this, title, filterProperty, helpContext, filterEnabled);
            hideLocalTypes.setDescription(ActionMessages.MemberFilterActionGroup_hide_types_description);
            hideLocalTypes.setToolTipText(ActionMessages.MemberFilterActionGroup_hide_types_tooltip);
            AsnPluginImages.setLocalImageDescriptors((IAction)hideLocalTypes, "types_co.gif");
            actions.add(hideLocalTypes);
        }
        if (this.isSet(filterProperty = 16, availableFilters)) {
            filterEnabled = store.getBoolean(this.getPreferenceKey(filterProperty));
            if (filterEnabled) {
                this.fFilter.addFilter(filterProperty);
            }
            title = ActionMessages.MemberFilterActionGroup_hide_values_label;
            helpContext = "org.asnlab.asndt.ui.filter_values_action";
            hideFields = new MemberFilterAction(this, title, filterProperty, helpContext, filterEnabled);
            hideFields.setDescription(ActionMessages.MemberFilterActionGroup_hide_values_description);
            hideFields.setToolTipText(ActionMessages.MemberFilterActionGroup_hide_values_tooltip);
            AsnPluginImages.setLocalImageDescriptors((IAction)hideFields, "values_co.gif");
            actions.add(hideFields);
        }
        if (this.isSet(filterProperty = 32, availableFilters)) {
            filterEnabled = store.getBoolean(this.getPreferenceKey(filterProperty));
            if (filterEnabled) {
                this.fFilter.addFilter(filterProperty);
            }
            title = ActionMessages.MemberFilterActionGroup_hide_components_label;
            helpContext = "org.asnlab.asndt.ui.filter_components_action";
            MemberFilterAction hideStatic = new MemberFilterAction(this, title, 32, helpContext, filterEnabled);
            hideStatic.setDescription(ActionMessages.MemberFilterActionGroup_hide_components_description);
            hideStatic.setToolTipText(ActionMessages.MemberFilterActionGroup_hide_components_tooltip);
            AsnPluginImages.setLocalImageDescriptors((IAction)hideStatic, "components_co.gif");
            actions.add(hideStatic);
        }
        this.fFilterActions = actions.toArray(new MemberFilterAction[actions.size()]);
        this.fViewer.addFilter((ViewerFilter)this.fFilter);
    }

    private String getPreferenceKey(int filterProperty) {
        return "MemberFilterActionGroup." + this.fViewerId + '.' + String.valueOf(filterProperty);
    }

    public void setMemberFilter(int filterProperty, boolean set) {
        this.setMemberFilters(new int[]{filterProperty}, new boolean[]{set}, true);
    }

    private void setMemberFilters(int[] propertyKeys, boolean[] propertyValues, boolean refresh) {
        if (propertyKeys.length == 0) {
            return;
        }
        Assert.isTrue((propertyKeys.length == propertyValues.length ? 1 : 0) != 0);
        int i = 0;
        while (i < propertyKeys.length) {
            int filterProperty = propertyKeys[i];
            boolean set = propertyValues[i];
            IPreferenceStore store = AsnPlugin.getDefault().getPreferenceStore();
            boolean found = false;
            int j = 0;
            while (j < this.fFilterActions.length) {
                int currProperty = this.fFilterActions[j].getFilterProperty();
                if (currProperty == filterProperty) {
                    this.fFilterActions[j].setChecked(set);
                    found = true;
                    store.setValue(this.getPreferenceKey(filterProperty), set);
                }
                ++j;
            }
            if (found) {
                if (set) {
                    this.fFilter.addFilter(filterProperty);
                } else {
                    this.fFilter.removeFilter(filterProperty);
                }
            }
            ++i;
        }
        if (refresh) {
            this.fViewer.getControl().setRedraw(false);
            BusyIndicator.showWhile((Display)this.fViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    MemberFilterActionGroup.this.fViewer.refresh();
                }
            });
            this.fViewer.getControl().setRedraw(true);
        }
    }

    private boolean isSet(int flag, int set) {
        return (flag & set) != 0;
    }

    public boolean hasMemberFilter(int filterProperty) {
        return this.fFilter.hasFilter(filterProperty);
    }

    public void saveState(IMemento memento) {
        memento.putString(TAG_HIDE_EXPORTS_IMPORTS, String.valueOf(this.hasMemberFilter(1)));
        memento.putString(TAG_HIDE_CLASSES, String.valueOf(this.hasMemberFilter(2)));
        memento.putString(TAG_HIDE_OBJECTS, String.valueOf(this.hasMemberFilter(4)));
        memento.putString(TAG_HIDE_TYPES, String.valueOf(this.hasMemberFilter(8)));
        memento.putString(TAG_HIDE_VALUES, String.valueOf(this.hasMemberFilter(16)));
        memento.putString(TAG_HIDE_COMPONENTS, String.valueOf(this.hasMemberFilter(32)));
    }

    public void restoreState(IMemento memento) {
        this.setMemberFilters(new int[]{1, 2, 4, 8, 16, 32}, new boolean[]{Boolean.valueOf(memento.getString(TAG_HIDE_EXPORTS_IMPORTS)), Boolean.valueOf(memento.getString(TAG_HIDE_CLASSES)), Boolean.valueOf(memento.getString(TAG_HIDE_OBJECTS)), Boolean.valueOf(memento.getString(TAG_HIDE_TYPES)), Boolean.valueOf(memento.getString(TAG_HIDE_VALUES)), Boolean.valueOf(memento.getString(TAG_HIDE_COMPONENTS))}, false);
    }

    public void fillActionBars(IActionBars actionBars) {
        this.contributeToToolBar(actionBars.getToolBarManager());
    }

    public void contributeToToolBar(IToolBarManager tbm) {
        if (this.fInViewMenu) {
            return;
        }
        int i = 0;
        while (i < this.fFilterActions.length) {
            tbm.add((IAction)this.fFilterActions[i]);
            ++i;
        }
    }

    public void contributeToViewMenu(IMenuManager menu) {
        if (!this.fInViewMenu) {
            return;
        }
        if (menu.find("filters") != null) {
            int i = 0;
            while (i < this.fFilterActions.length) {
                menu.prependToGroup("filters", (IAction)this.fFilterActions[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.fFilterActions.length) {
                menu.add((IAction)this.fFilterActions[i]);
                ++i;
            }
        }
    }

    public void dispose() {
        super.dispose();
    }
}

