/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.ui.actions;

import org.asnlab.asndt.internal.corext.util.Messages;
import org.asnlab.asndt.internal.ui.actions.ActionMessages;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditor;
import org.asnlab.asndt.internal.ui.search.SearchMessages;
import org.asnlab.asndt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.keys.IBindingService;

public class OccurrencesSearchGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private AsnEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;

    public OccurrencesSearchGroup(IWorkbenchSite site) {
        this.fSite = site;
        this.fGroupId = "group.search";
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        provider.getSelection();
    }

    public OccurrencesSearchGroup(AsnEditor editor) {
        this.fEditor = editor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
    }

    private void registerAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
    }

    private IAction[] getActions() {
        IAction[] actions = new IAction[]{};
        return actions;
    }

    public void fillContextMenu(IMenuManager manager) {
        String menuText = SearchMessages.group_occurrences;
        String shortcut = this.getShortcutString();
        if (shortcut != null) {
            Object[] args = new String[]{menuText, shortcut};
            menuText = Messages.format(ActionMessages.QuickMenuAction_menuTextWithShortcut, args);
        }
        MenuManager asnSearchMM = new MenuManager(menuText, "group.search");
        IAction[] actions = this.getActions();
        int i = 0;
        while (i < actions.length) {
            IAction action = actions[i];
            if (action.isEnabled()) {
                asnSearchMM.add(action);
            }
            ++i;
        }
        if (!asnSearchMM.isEmpty()) {
            manager.appendToGroup(this.fGroupId, (IContributionItem)asnSearchMM);
        }
    }

    private String getShortcutString() {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService == null) {
            return null;
        }
        return bindingService.getBestActiveBindingFormattedFor("org.asnlab.asndt.ui.edit.text.asn.search.occurrences.in.file.quickMenu");
    }

    public void fillActionBars(IActionBars actionBars) {
        Assert.isNotNull((Object)actionBars);
        super.fillActionBars(actionBars);
        this.fActionBars = actionBars;
        this.updateGlobalActionHandlers();
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        super.dispose();
        this.updateGlobalActionHandlers();
    }

    private void updateGlobalActionHandlers() {
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }
}

