/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.ui.actions;

import java.util.Iterator;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditor;
import org.asnlab.asndt.internal.ui.search.SearchMessages;
import org.asnlab.asndt.internal.ui.search.SearchUtil;
import org.asnlab.asndt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;

public class ReadReferencesSearchGroup
extends ActionGroup {
    private static final String MENU_TEXT = SearchMessages.group_readReferences;
    private IWorkbenchSite fSite;
    private AsnEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;

    public ReadReferencesSearchGroup(IWorkbenchSite site) {
        this.fSite = site;
        this.fGroupId = "group.search";
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        provider.getSelection();
    }

    public ReadReferencesSearchGroup(AsnEditor editor) {
        this.fEditor = editor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
    }

    private void registerAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
    }

    private void addAction(IAction action, IMenuManager manager) {
        if (action.isEnabled()) {
            manager.add(action);
        }
    }

    private void addWorkingSetAction(IWorkingSet[] workingSets, IMenuManager manager) {
    }

    public void fillContextMenu(IMenuManager manager) {
        MenuManager asnSearchMM = new MenuManager(MENU_TEXT, "group.search");
        asnSearchMM.add((IContributionItem)new Separator());
        Iterator iter = SearchUtil.getLRUWorkingSets().sortedIterator();
        while (iter.hasNext()) {
            this.addWorkingSetAction((IWorkingSet[])iter.next(), (IMenuManager)asnSearchMM);
        }
        if (!asnSearchMM.isEmpty()) {
            manager.appendToGroup(this.fGroupId, (IContributionItem)asnSearchMM);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        Assert.isNotNull((Object)actionBars);
        super.fillActionBars(actionBars);
        this.fActionBars = actionBars;
        this.updateGlobalActionHandlers();
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        this.updateGlobalActionHandlers();
        super.dispose();
    }

    private void updateGlobalActionHandlers() {
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }
}

