/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.ui.text;

import org.asnlab.asndt.internal.ui.text.AsnColorManager;
import org.asnlab.asndt.internal.ui.text.AsnCommentScanner;
import org.asnlab.asndt.internal.ui.text.AsnPartitionScanner;
import org.asnlab.asndt.internal.ui.text.SingleTokenAsnScanner;
import org.asnlab.asndt.internal.ui.text.asn.AsnCodeScanner;
import org.asnlab.asndt.ui.text.IColorManager;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class AsnTextTools {
    private static final String[] LEGAL_CONTENT_TYPES = new String[]{"__asn_singleline_comment", "__asn_multiline_comment", "__asn_string", "__asn_character"};
    private AsnColorManager fColorManager;
    private AsnCodeScanner fCodeScanner;
    private AsnCommentScanner fMultilineCommentScanner;
    private AsnCommentScanner fSinglelineCommentScanner;
    private SingleTokenAsnScanner fStringScanner;
    private IPartitionTokenScanner fPartitionScanner;
    private IPreferenceStore fPreferenceStore;
    private Preferences fCorePreferenceStore;
    private PreferenceListener fPreferenceListener = new PreferenceListener();

    public AsnTextTools(IPreferenceStore store) {
        this(store, null, true);
    }

    public AsnTextTools(IPreferenceStore store, boolean autoDisposeOnDisplayDispose) {
        this(store, null, autoDisposeOnDisplayDispose);
    }

    public AsnTextTools(IPreferenceStore store, Preferences coreStore) {
        this(store, coreStore, true);
    }

    public AsnTextTools(IPreferenceStore store, Preferences coreStore, boolean autoDisposeOnDisplayDispose) {
        this.fPreferenceStore = store;
        this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.fCorePreferenceStore = coreStore;
        if (this.fCorePreferenceStore != null) {
            this.fCorePreferenceStore.addPropertyChangeListener((Preferences.IPropertyChangeListener)this.fPreferenceListener);
        }
        this.fColorManager = new AsnColorManager(autoDisposeOnDisplayDispose);
        this.fCodeScanner = new AsnCodeScanner(this.fColorManager, store);
        this.fMultilineCommentScanner = new AsnCommentScanner((IColorManager)this.fColorManager, store, coreStore, "asn_multi_line_comment");
        this.fSinglelineCommentScanner = new AsnCommentScanner((IColorManager)this.fColorManager, store, coreStore, "asn_single_line_comment");
        this.fStringScanner = new SingleTokenAsnScanner(this.fColorManager, store, "asn_string");
        this.fPartitionScanner = new AsnPartitionScanner();
    }

    public void dispose() {
        this.fCodeScanner = null;
        this.fMultilineCommentScanner = null;
        this.fSinglelineCommentScanner = null;
        this.fStringScanner = null;
        this.fPartitionScanner = null;
        if (this.fColorManager != null) {
            this.fColorManager.dispose();
            this.fColorManager = null;
        }
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
            this.fPreferenceStore = null;
            if (this.fCorePreferenceStore != null) {
                this.fCorePreferenceStore.removePropertyChangeListener((Preferences.IPropertyChangeListener)this.fPreferenceListener);
                this.fCorePreferenceStore = null;
            }
            this.fPreferenceListener = null;
        }
    }

    public IColorManager getColorManager() {
        return this.fColorManager;
    }

    public RuleBasedScanner getCodeScanner() {
        return this.fCodeScanner;
    }

    public RuleBasedScanner getMultilineCommentScanner() {
        return this.fMultilineCommentScanner;
    }

    public RuleBasedScanner getSinglelineCommentScanner() {
        return this.fSinglelineCommentScanner;
    }

    public RuleBasedScanner getStringScanner() {
        return this.fStringScanner;
    }

    public IPartitionTokenScanner getPartitionScanner() {
        return this.fPartitionScanner;
    }

    public IDocumentPartitioner createDocumentPartitioner() {
        return new FastPartitioner(this.getPartitionScanner(), LEGAL_CONTENT_TYPES);
    }

    public String[] getPartitionManagingPositionCategories() {
        return new String[]{"__content_types_category"};
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return this.fCodeScanner.affectsBehavior(event) || this.fMultilineCommentScanner.affectsBehavior(event) || this.fSinglelineCommentScanner.affectsBehavior(event) || this.fStringScanner.affectsBehavior(event);
    }

    protected void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fMultilineCommentScanner.affectsBehavior(event)) {
            this.fMultilineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fSinglelineCommentScanner.affectsBehavior(event)) {
            this.fSinglelineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringScanner.affectsBehavior(event)) {
            this.fStringScanner.adaptToPreferenceChange(event);
        }
    }

    public void setupAsnDocumentPartitioner(IDocument document) {
        this.setupAsnDocumentPartitioner(document, "__dftl_partitioning");
    }

    public void setupAsnDocumentPartitioner(IDocument document, String partitioning) {
        IDocumentPartitioner partitioner = this.createDocumentPartitioner();
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            extension3.setDocumentPartitioner(partitioning, partitioner);
        } else {
            document.setDocumentPartitioner(partitioner);
        }
        partitioner.connect(document);
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    protected Preferences getCorePreferenceStore() {
        return this.fCorePreferenceStore;
    }

    private class PreferenceListener
    implements IPropertyChangeListener,
    Preferences.IPropertyChangeListener {
        private PreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            AsnTextTools.this.adaptToPreferenceChange(event);
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            AsnTextTools.this.adaptToPreferenceChange(new PropertyChangeEvent(event.getSource(), event.getProperty(), event.getOldValue(), event.getNewValue()));
        }
    }
}

